/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.executor.AbstractAugumentingClientRegistrationPolicyExecutor;

public class SecureClientAuthEnforceExecutor
extends AbstractAugumentingClientRegistrationPolicyExecutor {
    private static final Logger logger = Logger.getLogger(SecureClientAuthEnforceExecutor.class);

    public SecureClientAuthEnforceExecutor(KeycloakSession session, ComponentModel componentModel) {
        super(session, componentModel);
    }

    @Override
    protected void augment(ClientRepresentation rep) {
        if (Boolean.valueOf((String)this.componentModel.getConfig().getFirst((Object)"is-augment")).booleanValue()) {
            rep.setClientAuthenticatorType(this.enforcedClientAuthenticatorType());
        }
    }

    @Override
    protected void validate(ClientRepresentation rep) throws ClientPolicyException {
        this.verifyClientAuthenticationMethod(rep.getClientAuthenticatorType());
    }

    private String enforcedClientAuthenticatorType() {
        return (String)this.componentModel.getConfig().getFirst((Object)"client-authns-augment");
    }

    private void verifyClientAuthenticationMethod(String clientAuthenticatorType) throws ClientPolicyException {
        List acceptableClientAuthn = this.componentModel.getConfig().getList((Object)"client-authns");
        if (acceptableClientAuthn != null && acceptableClientAuthn.stream().anyMatch(i -> i.equals(clientAuthenticatorType))) {
            return;
        }
        throw new ClientPolicyException("invalid_client_metadata", "Invalid client metadata: token_endpoint_auth_method");
    }
}

