/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.net.URI;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.Token;
import org.keycloak.TokenVerifier;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.AuthenticationFlowException;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.ConsoleDisplayMode;
import org.keycloak.authentication.DisplayTypeRequiredActionFactory;
import org.keycloak.authentication.InitiatedActionSupport;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionContextResult;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.authentication.actiontoken.DefaultActionTokenKey;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.ServerCookie;
import org.keycloak.common.util.Time;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.ActionTokenKeyModel;
import org.keycloak.models.ActionTokenStoreProvider;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.SystemClientUtil;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.oidc.BackchannelLogoutResponse;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.services.managers.BruteForceProtector;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.managers.IdentityCookieToken;
import org.keycloak.services.managers.UserSessionManager;
import org.keycloak.services.resources.IdentityBrokerService;
import org.keycloak.services.resources.LoginActionsService;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.util.CookieHelper;
import org.keycloak.services.util.P3PHelper;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;
import org.keycloak.util.TokenUtil;

public class AuthenticationManager {
    public static final String SET_REDIRECT_URI_AFTER_REQUIRED_ACTIONS = "SET_REDIRECT_URI_AFTER_REQUIRED_ACTIONS";
    public static final String END_AFTER_REQUIRED_ACTIONS = "END_AFTER_REQUIRED_ACTIONS";
    public static final String INVALIDATE_ACTION_TOKEN = "INVALIDATE_ACTION_TOKEN";
    public static final String USER_SESSION_PERSISTENT_STATE = "USER_SESSION_PERSISTENT_STATE";
    public static final String CLIENT_LOGOUT_STATE = "logout.state.";
    public static final String AUTH_TIME = "AUTH_TIME";
    public static final String SSO_AUTH = "SSO_AUTH";
    protected static final Logger logger = Logger.getLogger(AuthenticationManager.class);
    public static final String FORM_USERNAME = "username";
    public static final String KEYCLOAK_IDENTITY_COOKIE = "KEYCLOAK_IDENTITY";
    public static final String KEYCLOAK_SESSION_COOKIE = "KEYCLOAK_SESSION";
    public static final String KEYCLOAK_REMEMBER_ME = "KEYCLOAK_REMEMBER_ME";
    public static final String KEYCLOAK_LOGOUT_PROTOCOL = "KEYCLOAK_LOGOUT_PROTOCOL";
    private static final TokenVerifier.TokenTypeCheck VALIDATE_IDENTITY_COOKIE = new TokenVerifier.TokenTypeCheck("Serialized-ID");

    public static boolean isSessionValid(RealmModel realm, UserSessionModel userSession) {
        if (userSession == null) {
            logger.debug((Object)"No user session");
            return false;
        }
        int currentTime = Time.currentTime();
        int maxIdle = userSession.isRememberMe() && realm.getSsoSessionIdleTimeoutRememberMe() > 0 ? realm.getSsoSessionIdleTimeoutRememberMe() : realm.getSsoSessionIdleTimeout();
        int maxLifespan = userSession.isRememberMe() && realm.getSsoSessionMaxLifespanRememberMe() > 0 ? realm.getSsoSessionMaxLifespanRememberMe() : realm.getSsoSessionMaxLifespan();
        boolean sessionIdleOk = maxIdle > currentTime - userSession.getLastSessionRefresh() - 120;
        boolean sessionMaxOk = maxLifespan > currentTime - userSession.getStarted();
        return sessionIdleOk && sessionMaxOk;
    }

    public static boolean isOfflineSessionValid(RealmModel realm, UserSessionModel userSession) {
        if (userSession == null) {
            logger.debug((Object)"No offline user session");
            return false;
        }
        int currentTime = Time.currentTime();
        int maxIdle = realm.getOfflineSessionIdleTimeout() + 120;
        if (realm.isOfflineSessionMaxLifespanEnabled()) {
            int max = userSession.getStarted() + realm.getOfflineSessionMaxLifespan();
            return userSession.getLastSessionRefresh() + maxIdle > currentTime && max > currentTime;
        }
        return userSession.getLastSessionRefresh() + maxIdle > currentTime;
    }

    public static boolean expireUserSessionCookie(KeycloakSession session, UserSessionModel userSession, RealmModel realm, UriInfo uriInfo, HttpHeaders headers, ClientConnection connection) {
        try {
            Cookie cookie = CookieHelper.getCookie(headers.getCookies(), KEYCLOAK_IDENTITY_COOKIE);
            if (cookie == null) {
                return true;
            }
            String tokenString = cookie.getValue();
            TokenVerifier verifier = TokenVerifier.create((String)tokenString, AccessToken.class).realmUrl(Urls.realmIssuer(uriInfo.getBaseUri(), realm.getName())).checkActive(false).checkTokenType(false).withChecks(new TokenVerifier.Predicate[]{VALIDATE_IDENTITY_COOKIE});
            String kid = verifier.getHeader().getKeyId();
            String algorithm = verifier.getHeader().getAlgorithm().name();
            SignatureVerifierContext signatureVerifier = ((SignatureProvider)session.getProvider(SignatureProvider.class, algorithm)).verifier(kid);
            verifier.verifierContext(signatureVerifier);
            AccessToken token = (AccessToken)verifier.verify().getToken();
            UserSessionModel cookieSession = session.sessions().getUserSession(realm, token.getSessionState());
            if (cookieSession == null || !cookieSession.getId().equals(userSession.getId())) {
                return true;
            }
            AuthenticationManager.expireIdentityCookie(realm, uriInfo, connection);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void backchannelLogout(KeycloakSession session, UserSessionModel userSession, boolean logoutBroker) {
        AuthenticationManager.backchannelLogout(session, session.getContext().getRealm(), userSession, (UriInfo)session.getContext().getUri(), session.getContext().getConnection(), session.getContext().getRequestHeaders(), logoutBroker);
    }

    public static BackchannelLogoutResponse backchannelLogout(KeycloakSession session, RealmModel realm, UserSessionModel userSession, UriInfo uriInfo, ClientConnection connection, HttpHeaders headers, boolean logoutBroker) {
        return AuthenticationManager.backchannelLogout(session, realm, userSession, uriInfo, connection, headers, logoutBroker, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BackchannelLogoutResponse backchannelLogout(KeycloakSession session, RealmModel realm, UserSessionModel userSession, UriInfo uriInfo, ClientConnection connection, HttpHeaders headers, boolean logoutBroker, boolean offlineSession) {
        BackchannelLogoutResponse backchannelLogoutResponse = new BackchannelLogoutResponse();
        if (userSession == null) {
            backchannelLogoutResponse.setLocalLogoutSucceeded(true);
            return backchannelLogoutResponse;
        }
        UserModel user = userSession.getUser();
        if (userSession.getState() != UserSessionModel.State.LOGGING_OUT) {
            userSession.setState(UserSessionModel.State.LOGGING_OUT);
        }
        logger.debugv("Logging out: {0} ({1}) offline: {2}", (Object)user.getUsername(), (Object)userSession.getId(), (Object)userSession.isOffline());
        boolean expireUserSessionCookieSucceeded = AuthenticationManager.expireUserSessionCookie(session, userSession, realm, uriInfo, headers, connection);
        AuthenticationSessionManager asm = new AuthenticationSessionManager(session);
        AuthenticationSessionModel logoutAuthSession = AuthenticationManager.createOrJoinLogoutSession(session, realm, asm, userSession, false);
        boolean userSessionOnlyHasLoggedOutClients = false;
        try {
            backchannelLogoutResponse = AuthenticationManager.backchannelLogoutAll(session, realm, userSession, logoutAuthSession, uriInfo, headers, logoutBroker);
            userSessionOnlyHasLoggedOutClients = AuthenticationManager.checkUserSessionOnlyHasLoggedOutClients(realm, userSession, logoutAuthSession);
        }
        finally {
            RootAuthenticationSessionModel rootAuthSession = logoutAuthSession.getParentSession();
            rootAuthSession.removeAuthenticationSessionByTabId(logoutAuthSession.getTabId());
        }
        userSession.setState(UserSessionModel.State.LOGGED_OUT);
        if (offlineSession) {
            new UserSessionManager(session).revokeOfflineUserSession(userSession);
            UserSessionModel onlineUserSession = session.sessions().getUserSession(realm, userSession.getId());
            if (onlineUserSession != null) {
                session.sessions().removeUserSession(realm, onlineUserSession);
            }
        } else {
            session.sessions().removeUserSession(realm, userSession);
        }
        backchannelLogoutResponse.setLocalLogoutSucceeded(expireUserSessionCookieSucceeded && userSessionOnlyHasLoggedOutClients);
        return backchannelLogoutResponse;
    }

    private static AuthenticationSessionModel createOrJoinLogoutSession(KeycloakSession session, RealmModel realm, AuthenticationSessionManager asm, UserSessionModel userSession, boolean browserCookie) {
        Optional<AuthenticationSessionModel> found;
        String authSessionId;
        ClientModel client = SystemClientUtil.getSystemClient((RealmModel)realm);
        RootAuthenticationSessionModel rootLogoutSession = null;
        boolean browserCookiePresent = false;
        if (browserCookie) {
            rootLogoutSession = asm.getCurrentRootAuthenticationSession(realm);
        }
        if (rootLogoutSession != null) {
            authSessionId = rootLogoutSession.getId();
            browserCookiePresent = true;
        } else {
            authSessionId = userSession.getId();
            rootLogoutSession = session.authenticationSessions().getRootAuthenticationSession(realm, authSessionId);
        }
        if (rootLogoutSession == null) {
            rootLogoutSession = session.authenticationSessions().createRootAuthenticationSession(realm, authSessionId);
        }
        if (browserCookie && !browserCookiePresent) {
            asm.setAuthSessionCookie(authSessionId, realm);
        }
        AuthenticationSessionModel logoutAuthSession = (found = rootLogoutSession.getAuthenticationSessions().values().stream().filter(authSession -> client.equals(authSession.getClient()) && Objects.equals(CommonClientSessionModel.Action.LOGGING_OUT.name(), authSession.getAction())).findFirst()).isPresent() ? found.get() : rootLogoutSession.createAuthenticationSession(client);
        session.getContext().setAuthenticationSession(logoutAuthSession);
        logoutAuthSession.setAction(CommonClientSessionModel.Action.LOGGING_OUT.name());
        return logoutAuthSession;
    }

    private static BackchannelLogoutResponse backchannelLogoutAll(KeycloakSession session, RealmModel realm, UserSessionModel userSession, AuthenticationSessionModel logoutAuthSession, UriInfo uriInfo, HttpHeaders headers, boolean logoutBroker) {
        String brokerId;
        BackchannelLogoutResponse backchannelLogoutResponse = new BackchannelLogoutResponse();
        for (AuthenticatedClientSessionModel clientSession : userSession.getAuthenticatedClientSessions().values()) {
            Response clientSessionLogoutResponse = AuthenticationManager.backchannelLogoutClientSession(session, realm, clientSession, logoutAuthSession, uriInfo, headers);
            String backchannelLogoutUrl = OIDCAdvancedConfigWrapper.fromClientModel(clientSession.getClient()).getBackchannelLogoutUrl();
            BackchannelLogoutResponse.DownStreamBackchannelLogoutResponse downStreamBackchannelLogoutResponse = new BackchannelLogoutResponse.DownStreamBackchannelLogoutResponse();
            downStreamBackchannelLogoutResponse.setWithBackchannelLogoutUrl(backchannelLogoutUrl != null);
            if (clientSessionLogoutResponse != null) {
                downStreamBackchannelLogoutResponse.setResponseCode(clientSessionLogoutResponse.getStatus());
            } else {
                downStreamBackchannelLogoutResponse.setResponseCode(null);
            }
            backchannelLogoutResponse.addClientResponses(downStreamBackchannelLogoutResponse);
        }
        if (logoutBroker && (brokerId = userSession.getNote("identity_provider")) != null) {
            IdentityProvider identityProvider = IdentityBrokerService.getIdentityProvider(session, realm, brokerId);
            try {
                identityProvider.backchannelLogout(session, userSession, uriInfo, realm);
            }
            catch (Exception e) {
                logger.warn((Object)("Exception at broker backchannel logout for broker " + brokerId), (Throwable)e);
                backchannelLogoutResponse.setLocalLogoutSucceeded(false);
            }
        }
        return backchannelLogoutResponse;
    }

    private static boolean checkUserSessionOnlyHasLoggedOutClients(RealmModel realm, UserSessionModel userSession, AuthenticationSessionModel logoutAuthSession) {
        Map acs = userSession.getAuthenticatedClientSessions();
        Set notLoggedOutSessions = acs.entrySet().stream().filter(me -> !Objects.equals(CommonClientSessionModel.Action.LOGGED_OUT, AuthenticationManager.getClientLogoutAction(logoutAuthSession, (String)me.getKey()))).filter(me -> !Objects.equals(CommonClientSessionModel.Action.LOGGED_OUT.name(), ((AuthenticatedClientSessionModel)me.getValue()).getAction())).filter(me -> Objects.nonNull(((AuthenticatedClientSessionModel)me.getValue()).getProtocol())).map(Map.Entry::getValue).collect(Collectors.toSet());
        boolean allClientsLoggedOut = notLoggedOutSessions.isEmpty();
        if (!allClientsLoggedOut) {
            logger.warnf("Some clients have been not been logged out for user %s in %s realm: %s", (Object)userSession.getUser().getUsername(), (Object)realm.getName(), (Object)notLoggedOutSessions.stream().map(CommonClientSessionModel::getClient).map(ClientModel::getClientId).sorted().collect(Collectors.joining(", ")));
        } else if (logger.isDebugEnabled()) {
            logger.debugf("All clients have been logged out for user %s in %s realm, session %s", (Object)userSession.getUser().getUsername(), (Object)realm.getName(), (Object)userSession.getId());
        }
        return allClientsLoggedOut;
    }

    private static Response backchannelLogoutClientSession(KeycloakSession session, RealmModel realm, AuthenticatedClientSessionModel clientSession, AuthenticationSessionModel logoutAuthSession, UriInfo uriInfo, HttpHeaders headers) {
        UserSessionModel userSession = clientSession.getUserSession();
        ClientModel client = clientSession.getClient();
        if (client.isFrontchannelLogout() || CommonClientSessionModel.Action.LOGGED_OUT.name().equals(clientSession.getAction())) {
            return null;
        }
        CommonClientSessionModel.Action logoutState = AuthenticationManager.getClientLogoutAction(logoutAuthSession, client.getId());
        if (logoutState == CommonClientSessionModel.Action.LOGGED_OUT || logoutState == CommonClientSessionModel.Action.LOGGING_OUT) {
            return Response.ok().build();
        }
        if (!client.isEnabled()) {
            return null;
        }
        try {
            AuthenticationManager.setClientLogoutAction(logoutAuthSession, client.getId(), CommonClientSessionModel.Action.LOGGING_OUT);
            String authMethod = clientSession.getProtocol();
            if (authMethod == null) {
                return Response.ok().build();
            }
            logger.debugv("backchannel logout to: {0}", (Object)client.getClientId());
            LoginProtocol protocol = (LoginProtocol)session.getProvider(LoginProtocol.class, authMethod);
            protocol.setRealm(realm).setHttpHeaders(headers).setUriInfo(uriInfo);
            Response clientSessionLogout = protocol.backchannelLogout(userSession, clientSession);
            AuthenticationManager.setClientLogoutAction(logoutAuthSession, client.getId(), CommonClientSessionModel.Action.LOGGED_OUT);
            return clientSessionLogout;
        }
        catch (Exception ex) {
            ServicesLogger.LOGGER.failedToLogoutClient(ex);
            return Response.serverError().build();
        }
    }

    private static Response frontchannelLogoutClientSession(KeycloakSession session, RealmModel realm, AuthenticatedClientSessionModel clientSession, AuthenticationSessionModel logoutAuthSession, UriInfo uriInfo, HttpHeaders headers) {
        UserSessionModel userSession = clientSession.getUserSession();
        ClientModel client = clientSession.getClient();
        if (!client.isFrontchannelLogout() || CommonClientSessionModel.Action.LOGGED_OUT.name().equals(clientSession.getAction())) {
            return null;
        }
        CommonClientSessionModel.Action logoutState = AuthenticationManager.getClientLogoutAction(logoutAuthSession, client.getId());
        if (logoutState == CommonClientSessionModel.Action.LOGGED_OUT || logoutState == CommonClientSessionModel.Action.LOGGING_OUT) {
            return null;
        }
        try {
            AuthenticationManager.setClientLogoutAction(logoutAuthSession, client.getId(), CommonClientSessionModel.Action.LOGGING_OUT);
            String authMethod = clientSession.getProtocol();
            if (authMethod == null) {
                return null;
            }
            logger.debugv("frontchannel logout to: {0}", (Object)client.getClientId());
            LoginProtocol protocol = (LoginProtocol)session.getProvider(LoginProtocol.class, authMethod);
            protocol.setRealm(realm).setHttpHeaders(headers).setUriInfo(uriInfo);
            Response response = protocol.frontchannelLogout(userSession, clientSession);
            if (response != null) {
                logger.debug((Object)"returning frontchannel logout request to client");
                AuthenticationManager.setClientLogoutAction(logoutAuthSession, client.getId(), CommonClientSessionModel.Action.LOGGED_OUT);
                return response;
            }
        }
        catch (Exception e) {
            ServicesLogger.LOGGER.failedToLogoutClient(e);
        }
        return null;
    }

    public static void setClientLogoutAction(AuthenticationSessionModel logoutAuthSession, String clientUuid, CommonClientSessionModel.Action action) {
        if (logoutAuthSession != null && clientUuid != null) {
            logoutAuthSession.setAuthNote(CLIENT_LOGOUT_STATE + clientUuid, action.name());
        }
    }

    public static CommonClientSessionModel.Action getClientLogoutAction(AuthenticationSessionModel logoutAuthSession, String clientUuid) {
        if (logoutAuthSession == null || clientUuid == null) {
            return null;
        }
        String state = logoutAuthSession.getAuthNote(CLIENT_LOGOUT_STATE + clientUuid);
        return state == null ? null : CommonClientSessionModel.Action.valueOf((String)state);
    }

    public static void backchannelLogoutUserFromClient(KeycloakSession session, RealmModel realm, UserModel user, ClientModel client, UriInfo uriInfo, HttpHeaders headers) {
        session.sessions().getUserSessionsStream(realm, user).map(userSession -> userSession.getAuthenticatedClientSessionByClient(client.getId())).filter(Objects::nonNull).collect(Collectors.toList()).forEach(clientSession -> {
            AuthenticationManager.backchannelLogoutClientSession(session, realm, clientSession, null, uriInfo, headers);
            clientSession.setAction(CommonClientSessionModel.Action.LOGGED_OUT.name());
            TokenManager.dettachClientSession(session.sessions(), realm, clientSession);
        });
    }

    public static Response browserLogout(KeycloakSession session, RealmModel realm, UserSessionModel userSession, UriInfo uriInfo, ClientConnection connection, HttpHeaders headers, String initiatingIdp) {
        IdentityProvider identityProvider;
        AuthenticationSessionManager asm;
        AuthenticationSessionModel logoutAuthSession;
        Response response;
        if (userSession == null) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            UserModel user = userSession.getUser();
            logger.debugv("Logging out: {0} ({1})", (Object)user.getUsername(), (Object)userSession.getId());
        }
        if (userSession.getState() != UserSessionModel.State.LOGGING_OUT) {
            userSession.setState(UserSessionModel.State.LOGGING_OUT);
        }
        if ((response = AuthenticationManager.browserLogoutAllClients(userSession, session, realm, headers, uriInfo, logoutAuthSession = AuthenticationManager.createOrJoinLogoutSession(session, realm, asm = new AuthenticationSessionManager(session), userSession, true))) != null) {
            return response;
        }
        String brokerId = userSession.getNote("identity_provider");
        if (brokerId != null && !brokerId.equals(initiatingIdp) && (response = (identityProvider = IdentityBrokerService.getIdentityProvider(session, realm, brokerId)).keycloakInitiatedBrowserLogout(session, userSession, uriInfo, realm)) != null) {
            return response;
        }
        return AuthenticationManager.finishBrowserLogout(session, realm, userSession, uriInfo, connection, headers);
    }

    private static Response browserLogoutAllClients(UserSessionModel userSession, KeycloakSession session, RealmModel realm, HttpHeaders headers, UriInfo uriInfo, AuthenticationSessionModel logoutAuthSession) {
        Map<Boolean, List<AuthenticatedClientSessionModel>> acss = userSession.getAuthenticatedClientSessions().values().stream().filter(clientSession -> !Objects.equals(CommonClientSessionModel.Action.LOGGED_OUT.name(), clientSession.getAction())).filter(clientSession -> clientSession.getProtocol() != null).collect(Collectors.partitioningBy(clientSession -> clientSession.getClient().isFrontchannelLogout()));
        List<AuthenticatedClientSessionModel> backendLogoutSessions = acss.get(false) == null ? Collections.emptyList() : acss.get(false);
        backendLogoutSessions.forEach(acs -> AuthenticationManager.backchannelLogoutClientSession(session, realm, acs, logoutAuthSession, uriInfo, headers));
        List<AuthenticatedClientSessionModel> redirectClients = acss.get(true) == null ? Collections.emptyList() : acss.get(true);
        for (AuthenticatedClientSessionModel nextRedirectClient : redirectClients) {
            Response response = AuthenticationManager.frontchannelLogoutClientSession(session, realm, nextRedirectClient, logoutAuthSession, uriInfo, headers);
            if (response == null) continue;
            return response;
        }
        return null;
    }

    public static Response finishBrowserLogout(KeycloakSession session, RealmModel realm, UserSessionModel userSession, UriInfo uriInfo, ClientConnection connection, HttpHeaders headers) {
        AuthenticationSessionManager asm = new AuthenticationSessionManager(session);
        AuthenticationSessionModel logoutAuthSession = AuthenticationManager.createOrJoinLogoutSession(session, realm, asm, userSession, true);
        AuthenticationManager.checkUserSessionOnlyHasLoggedOutClients(realm, userSession, logoutAuthSession);
        AuthenticationManager.expireIdentityCookie(realm, uriInfo, connection);
        AuthenticationManager.expireRememberMeCookie(realm, uriInfo, connection);
        userSession.setState(UserSessionModel.State.LOGGED_OUT);
        String method = userSession.getNote(KEYCLOAK_LOGOUT_PROTOCOL);
        EventBuilder event = new EventBuilder(realm, session, connection);
        LoginProtocol protocol = (LoginProtocol)session.getProvider(LoginProtocol.class, method);
        protocol.setRealm(realm).setHttpHeaders(headers).setUriInfo(uriInfo).setEventBuilder(event);
        Response response = protocol.finishLogout(userSession);
        session.sessions().removeUserSession(realm, userSession);
        session.authenticationSessions().removeRootAuthenticationSession(realm, logoutAuthSession.getParentSession());
        return response;
    }

    public static IdentityCookieToken createIdentityToken(KeycloakSession keycloakSession, RealmModel realm, UserModel user, UserSessionModel session, String issuer) {
        IdentityCookieToken token = new IdentityCookieToken();
        token.id(KeycloakModelUtils.generateId());
        token.issuedNow();
        token.subject(user.getId());
        token.issuer(issuer);
        token.type("Serialized-ID");
        if (session != null) {
            token.setSessionState(session.getId());
        }
        if (session != null && session.isRememberMe() && realm.getSsoSessionMaxLifespanRememberMe() > 0) {
            token.expiration(Time.currentTime() + realm.getSsoSessionMaxLifespanRememberMe());
        } else if (realm.getSsoSessionMaxLifespan() > 0) {
            token.expiration(Time.currentTime() + realm.getSsoSessionMaxLifespan());
        }
        String stateChecker = (String)keycloakSession.getAttribute("state_checker");
        if (stateChecker == null) {
            stateChecker = Base64Url.encode((byte[])KeycloakModelUtils.generateSecret());
            keycloakSession.setAttribute("state_checker", (Object)stateChecker);
        }
        token.getOtherClaims().put("state_checker", stateChecker);
        return token;
    }

    public static void createLoginCookie(KeycloakSession keycloakSession, RealmModel realm, UserModel user, UserSessionModel session, UriInfo uriInfo, ClientConnection connection) {
        String cookiePath = AuthenticationManager.getIdentityCookiePath(realm, uriInfo);
        String issuer = Urls.realmIssuer(uriInfo.getBaseUri(), realm.getName());
        IdentityCookieToken identityCookieToken = AuthenticationManager.createIdentityToken(keycloakSession, realm, user, session, issuer);
        String encoded = keycloakSession.tokens().encode((Token)identityCookieToken);
        boolean secureOnly = realm.getSslRequired().isRequired(connection);
        int maxAge = -1;
        if (session != null && session.isRememberMe()) {
            maxAge = realm.getSsoSessionMaxLifespanRememberMe() > 0 ? realm.getSsoSessionMaxLifespanRememberMe() : realm.getSsoSessionMaxLifespan();
        }
        logger.debugv("Create login cookie - name: {0}, path: {1}, max-age: {2}", (Object)KEYCLOAK_IDENTITY_COOKIE, (Object)cookiePath, (Object)maxAge);
        CookieHelper.addCookie(KEYCLOAK_IDENTITY_COOKIE, encoded, cookiePath, null, null, maxAge, secureOnly, true, ServerCookie.SameSiteAttributeValue.NONE);
        String sessionCookieValue = realm.getName() + "/" + user.getId();
        if (session != null) {
            sessionCookieValue = sessionCookieValue + "/" + session.getId();
        }
        int sessionCookieMaxAge = session.isRememberMe() && realm.getSsoSessionMaxLifespanRememberMe() > 0 ? realm.getSsoSessionMaxLifespanRememberMe() : realm.getSsoSessionMaxLifespan();
        CookieHelper.addCookie(KEYCLOAK_SESSION_COOKIE, sessionCookieValue, cookiePath, null, null, sessionCookieMaxAge, secureOnly, false, ServerCookie.SameSiteAttributeValue.NONE);
        P3PHelper.addP3PHeader();
    }

    public static void createRememberMeCookie(RealmModel realm, String username, UriInfo uriInfo, ClientConnection connection) {
        String path = AuthenticationManager.getIdentityCookiePath(realm, uriInfo);
        boolean secureOnly = realm.getSslRequired().isRequired(connection);
        CookieHelper.addCookie(KEYCLOAK_REMEMBER_ME, "username:" + username, path, null, null, 31536000, secureOnly, true);
    }

    public static String getRememberMeUsername(RealmModel realm, HttpHeaders headers) {
        String value;
        String[] s;
        Cookie cookie;
        if (realm.isRememberMe() && (cookie = (Cookie)headers.getCookies().get(KEYCLOAK_REMEMBER_ME)) != null && (s = (value = cookie.getValue()).split(":"))[0].equals(FORM_USERNAME) && s.length == 2) {
            return s[1];
        }
        return null;
    }

    public static void expireIdentityCookie(RealmModel realm, UriInfo uriInfo, ClientConnection connection) {
        logger.debug((Object)"Expiring identity cookie");
        String path = AuthenticationManager.getIdentityCookiePath(realm, uriInfo);
        AuthenticationManager.expireCookie(realm, KEYCLOAK_IDENTITY_COOKIE, path, true, connection, ServerCookie.SameSiteAttributeValue.NONE);
        AuthenticationManager.expireCookie(realm, KEYCLOAK_SESSION_COOKIE, path, false, connection, ServerCookie.SameSiteAttributeValue.NONE);
        String oldPath = AuthenticationManager.getOldCookiePath(realm, uriInfo);
        AuthenticationManager.expireCookie(realm, KEYCLOAK_IDENTITY_COOKIE, oldPath, true, connection, ServerCookie.SameSiteAttributeValue.NONE);
        AuthenticationManager.expireCookie(realm, KEYCLOAK_SESSION_COOKIE, oldPath, false, connection, ServerCookie.SameSiteAttributeValue.NONE);
    }

    public static void expireOldIdentityCookie(RealmModel realm, UriInfo uriInfo, ClientConnection connection) {
        logger.debug((Object)"Expiring old identity cookie with wrong path");
        String oldPath = AuthenticationManager.getOldCookiePath(realm, uriInfo);
        AuthenticationManager.expireCookie(realm, KEYCLOAK_IDENTITY_COOKIE, oldPath, true, connection, ServerCookie.SameSiteAttributeValue.NONE);
        AuthenticationManager.expireCookie(realm, KEYCLOAK_SESSION_COOKIE, oldPath, false, connection, ServerCookie.SameSiteAttributeValue.NONE);
    }

    public static void expireRememberMeCookie(RealmModel realm, UriInfo uriInfo, ClientConnection connection) {
        logger.debug((Object)"Expiring remember me cookie");
        String path = AuthenticationManager.getIdentityCookiePath(realm, uriInfo);
        String cookieName = KEYCLOAK_REMEMBER_ME;
        AuthenticationManager.expireCookie(realm, cookieName, path, true, connection, null);
    }

    public static void expireOldAuthSessionCookie(RealmModel realm, UriInfo uriInfo, ClientConnection connection) {
        logger.debugv("Expire {1} cookie .", (Object)"AUTH_SESSION_ID");
        String oldPath = AuthenticationManager.getOldCookiePath(realm, uriInfo);
        AuthenticationManager.expireCookie(realm, "AUTH_SESSION_ID", oldPath, true, connection, ServerCookie.SameSiteAttributeValue.NONE);
    }

    protected static String getIdentityCookiePath(RealmModel realm, UriInfo uriInfo) {
        return AuthenticationManager.getRealmCookiePath(realm, uriInfo);
    }

    public static String getRealmCookiePath(RealmModel realm, UriInfo uriInfo) {
        URI uri = RealmsResource.realmBaseUrl(uriInfo).build(new Object[]{realm.getName()});
        return uri.getRawPath() + "/";
    }

    public static String getOldCookiePath(RealmModel realm, UriInfo uriInfo) {
        URI uri = RealmsResource.realmBaseUrl(uriInfo).build(new Object[]{realm.getName()});
        return uri.getRawPath();
    }

    public static String getAccountCookiePath(RealmModel realm, UriInfo uriInfo) {
        URI uri = RealmsResource.accountUrl(uriInfo.getBaseUriBuilder()).build(new Object[]{realm.getName()});
        return uri.getRawPath();
    }

    public static void expireCookie(RealmModel realm, String cookieName, String path, boolean httpOnly, ClientConnection connection, ServerCookie.SameSiteAttributeValue sameSite) {
        logger.debugf("Expiring cookie: %s path: %s", (Object)cookieName, (Object)path);
        boolean secureOnly = realm.getSslRequired().isRequired(connection);
        CookieHelper.addCookie(cookieName, "", path, null, "Expiring cookie", 0, secureOnly, httpOnly, sameSite);
    }

    public AuthResult authenticateIdentityCookie(KeycloakSession session, RealmModel realm) {
        return AuthenticationManager.authenticateIdentityCookie(session, realm, true);
    }

    public static AuthResult authenticateIdentityCookie(KeycloakSession session, RealmModel realm, boolean checkActive) {
        Cookie cookie = CookieHelper.getCookie(session.getContext().getRequestHeaders().getCookies(), KEYCLOAK_IDENTITY_COOKIE);
        if (cookie == null || "".equals(cookie.getValue())) {
            logger.debugv("Could not find cookie: {0}", (Object)KEYCLOAK_IDENTITY_COOKIE);
            return null;
        }
        String tokenString = cookie.getValue();
        AuthResult authResult = AuthenticationManager.verifyIdentityToken(session, realm, (UriInfo)session.getContext().getUri(), session.getContext().getConnection(), checkActive, false, null, true, tokenString, session.getContext().getRequestHeaders(), new TokenVerifier.Predicate[]{VALIDATE_IDENTITY_COOKIE});
        if (authResult == null) {
            AuthenticationManager.expireIdentityCookie(realm, (UriInfo)session.getContext().getUri(), session.getContext().getConnection());
            AuthenticationManager.expireOldIdentityCookie(realm, (UriInfo)session.getContext().getUri(), session.getContext().getConnection());
            return null;
        }
        authResult.getSession().setLastSessionRefresh(Time.currentTime());
        return authResult;
    }

    public static Response redirectAfterSuccessfulFlow(KeycloakSession session, RealmModel realm, UserSessionModel userSession, ClientSessionContext clientSessionCtx, HttpRequest request, UriInfo uriInfo, ClientConnection clientConnection, EventBuilder event, AuthenticationSessionModel authSession) {
        LoginProtocol protocolImpl = (LoginProtocol)session.getProvider(LoginProtocol.class, authSession.getProtocol());
        protocolImpl.setRealm(realm).setHttpHeaders(request.getHttpHeaders()).setUriInfo(uriInfo).setEventBuilder(event);
        return AuthenticationManager.redirectAfterSuccessfulFlow(session, realm, userSession, clientSessionCtx, request, uriInfo, clientConnection, event, authSession, protocolImpl);
    }

    public static Response redirectAfterSuccessfulFlow(KeycloakSession session, RealmModel realm, UserSessionModel userSession, ClientSessionContext clientSessionCtx, HttpRequest request, UriInfo uriInfo, ClientConnection clientConnection, EventBuilder event, AuthenticationSessionModel authSession, LoginProtocol protocol) {
        UserSessionModel oldSession;
        String oldSessionId;
        String[] split;
        Cookie sessionCookie = CookieHelper.getCookie(request.getHttpHeaders().getCookies(), KEYCLOAK_SESSION_COOKIE);
        if (sessionCookie != null && (split = sessionCookie.getValue().split("/")).length >= 3 && !(oldSessionId = split[2]).equals(userSession.getId()) && (oldSession = session.sessions().getUserSession(realm, oldSessionId)) != null) {
            logger.debugv("Removing old user session: session: {0}", (Object)oldSessionId);
            session.sessions().removeUserSession(realm, oldSession);
        }
        session.getContext().resolveLocale(userSession.getUser());
        AuthenticationManager.createLoginCookie(session, realm, userSession.getUser(), userSession, uriInfo, clientConnection);
        if (userSession.getState() != UserSessionModel.State.LOGGED_IN) {
            userSession.setState(UserSessionModel.State.LOGGED_IN);
        }
        if (userSession.isRememberMe()) {
            AuthenticationManager.createRememberMeCookie(realm, userSession.getLoginUsername(), uriInfo, clientConnection);
        } else {
            AuthenticationManager.expireRememberMeCookie(realm, uriInfo, clientConnection);
        }
        AuthenticatedClientSessionModel clientSession = clientSessionCtx.getClientSession();
        boolean isSSOAuthentication = "true".equals(session.getAttribute(SSO_AUTH));
        if (isSSOAuthentication) {
            clientSession.setNote(SSO_AUTH, "true");
        } else {
            int authTime = Time.currentTime();
            userSession.setNote(AUTH_TIME, String.valueOf(authTime));
            clientSession.removeNote(SSO_AUTH);
        }
        AuthenticationManager.logSuccess(session, authSession);
        return protocol.authenticated(authSession, userSession, clientSessionCtx);
    }

    public static String getSessionIdFromSessionCookie(KeycloakSession session) {
        Cookie cookie = CookieHelper.getCookie(session.getContext().getRequestHeaders().getCookies(), KEYCLOAK_SESSION_COOKIE);
        if (cookie == null || "".equals(cookie.getValue())) {
            logger.debugv("Could not find cookie: {0}", (Object)KEYCLOAK_SESSION_COOKIE);
            return null;
        }
        String[] parts = cookie.getValue().split("/", 3);
        if (parts.length != 3) {
            logger.debugv("Cannot parse session value from: {0}", (Object)KEYCLOAK_SESSION_COOKIE);
            return null;
        }
        return parts[2];
    }

    public static boolean isSSOAuthentication(AuthenticatedClientSessionModel clientSession) {
        String ssoAuth = clientSession.getNote(SSO_AUTH);
        return Boolean.parseBoolean(ssoAuth);
    }

    public static Response nextActionAfterAuthentication(KeycloakSession session, AuthenticationSessionModel authSession, ClientConnection clientConnection, HttpRequest request, UriInfo uriInfo, EventBuilder event) {
        Response requiredAction = AuthenticationManager.actionRequired(session, authSession, request, event);
        if (requiredAction != null) {
            return requiredAction;
        }
        return AuthenticationManager.finishedRequiredActions(session, authSession, null, clientConnection, request, uriInfo, event);
    }

    public static Response redirectToRequiredActions(KeycloakSession session, RealmModel realm, AuthenticationSessionModel authSession, UriInfo uriInfo, String requiredAction) {
        ClientSessionCode<AuthenticationSessionModel> accessCode = new ClientSessionCode<AuthenticationSessionModel>(session, realm, authSession);
        accessCode.setAction(CommonClientSessionModel.Action.REQUIRED_ACTIONS.name());
        authSession.setAuthNote("current.flow.path", "required-action");
        authSession.setAuthNote("current.authentication.execution", requiredAction);
        UriBuilder uriBuilder = LoginActionsService.loginActionsBaseUrl(uriInfo).path("required-action");
        if (requiredAction != null) {
            uriBuilder.queryParam("execution", new Object[]{requiredAction});
        }
        uriBuilder.queryParam("client_id", new Object[]{authSession.getClient().getClientId()});
        uriBuilder.queryParam("tab_id", new Object[]{authSession.getTabId()});
        if (uriInfo.getQueryParameters().containsKey((Object)"auth_session_id")) {
            uriBuilder.queryParam("auth_session_id", new Object[]{authSession.getParentSession().getId()});
        }
        URI redirect = uriBuilder.build(new Object[]{realm.getName()});
        return Response.status((int)302).location(redirect).build();
    }

    public static Response finishedRequiredActions(KeycloakSession session, AuthenticationSessionModel authSession, UserSessionModel userSession, ClientConnection clientConnection, HttpRequest request, UriInfo uriInfo, EventBuilder event) {
        DefaultActionTokenKey actionTokenKey;
        String actionTokenKeyToInvalidate = authSession.getAuthNote(INVALIDATE_ACTION_TOKEN);
        if (actionTokenKeyToInvalidate != null && (actionTokenKey = DefaultActionTokenKey.from(actionTokenKeyToInvalidate)) != null) {
            ActionTokenStoreProvider actionTokenStore = (ActionTokenStoreProvider)session.getProvider(ActionTokenStoreProvider.class);
            actionTokenStore.put((ActionTokenKeyModel)actionTokenKey, null);
        }
        if (authSession.getAuthNote(END_AFTER_REQUIRED_ACTIONS) != null) {
            LoginFormsProvider infoPage = ((LoginFormsProvider)session.getProvider(LoginFormsProvider.class)).setAuthenticationSession(authSession).setSuccess("accountUpdatedMessage", new Object[0]);
            if (authSession.getAuthNote(SET_REDIRECT_URI_AFTER_REQUIRED_ACTIONS) != null) {
                if (authSession.getRedirectUri() != null) {
                    infoPage.setAttribute("pageRedirectUri", (Object)authSession.getRedirectUri());
                }
            } else {
                infoPage.setAttribute("skipLink", (Object)true);
            }
            Response response = infoPage.createInfoPage();
            new AuthenticationSessionManager(session).removeAuthenticationSession(authSession.getRealm(), authSession, true);
            return response;
        }
        RealmModel realm = authSession.getRealm();
        ClientSessionContext clientSessionCtx = AuthenticationProcessor.attachSession(authSession, userSession, session, realm, clientConnection, event);
        userSession = clientSessionCtx.getClientSession().getUserSession();
        event.event(EventType.LOGIN);
        event.session(userSession);
        event.success();
        return AuthenticationManager.redirectAfterSuccessfulFlow(session, realm, userSession, clientSessionCtx, request, uriInfo, clientConnection, event, authSession);
    }

    public static String nextRequiredAction(KeycloakSession session, AuthenticationSessionModel authSession, HttpRequest request, EventBuilder event) {
        RealmModel realm = authSession.getRealm();
        UserModel user = authSession.getAuthenticatedUser();
        ClientModel client = authSession.getClient();
        AuthenticationManager.evaluateRequiredActionTriggers(session, authSession, request, event, realm, user);
        Optional reqAction = user.getRequiredActionsStream().findFirst();
        if (reqAction.isPresent()) {
            return (String)reqAction.get();
        }
        if (!authSession.getRequiredActions().isEmpty()) {
            return (String)authSession.getRequiredActions().iterator().next();
        }
        String kcAction = authSession.getClientNote("kc_action");
        if (kcAction != null) {
            return kcAction;
        }
        if (client.isConsentRequired()) {
            UserConsentModel grantedConsent = AuthenticationManager.getEffectiveGrantedConsent(session, authSession);
            List<ClientScopeModel> clientScopesToApprove = AuthenticationManager.getClientScopesToApproveOnConsentScreen(realm, grantedConsent, authSession);
            if (!clientScopesToApprove.isEmpty()) {
                return CommonClientSessionModel.Action.OAUTH_GRANT.name();
            }
            String consentDetail = grantedConsent != null ? "persistent_consent" : "no_consent_required";
            event.detail("consent", consentDetail);
        } else {
            event.detail("consent", "no_consent_required");
        }
        return null;
    }

    private static UserConsentModel getEffectiveGrantedConsent(KeycloakSession session, AuthenticationSessionModel authSession) {
        String prompt = authSession.getClientNote("prompt");
        if (TokenUtil.hasPrompt((String)prompt, (String)"consent")) {
            return null;
        }
        RealmModel realm = authSession.getRealm();
        UserModel user = authSession.getAuthenticatedUser();
        ClientModel client = authSession.getClient();
        return session.users().getConsentByClient(realm, user.getId(), client.getId());
    }

    public static Response actionRequired(KeycloakSession session, AuthenticationSessionModel authSession, HttpRequest request, EventBuilder event) {
        RealmModel realm = authSession.getRealm();
        UserModel user = authSession.getAuthenticatedUser();
        ClientModel client = authSession.getClient();
        AuthenticationManager.evaluateRequiredActionTriggers(session, authSession, request, event, realm, user);
        logger.debugv("processAccessCode: go to oauth page?: {0}", (Object)client.isConsentRequired());
        event.detail("code_id", authSession.getParentSession().getId());
        Stream requiredActions = user.getRequiredActionsStream();
        Response action = AuthenticationManager.executionActions(session, authSession, request, event, realm, user, requiredActions);
        if (action != null) {
            return action;
        }
        action = AuthenticationManager.executionActions(session, authSession, request, event, realm, user, authSession.getRequiredActions().stream());
        if (action != null) {
            return action;
        }
        if (client.isConsentRequired()) {
            UserConsentModel grantedConsent = AuthenticationManager.getEffectiveGrantedConsent(session, authSession);
            List<ClientScopeModel> clientScopesToApprove = AuthenticationManager.getClientScopesToApproveOnConsentScreen(realm, grantedConsent, authSession);
            if (clientScopesToApprove.size() > 0) {
                String execution = CommonClientSessionModel.Action.OAUTH_GRANT.name();
                ClientSessionCode<AuthenticationSessionModel> accessCode = new ClientSessionCode<AuthenticationSessionModel>(session, realm, authSession);
                accessCode.setAction(CommonClientSessionModel.Action.REQUIRED_ACTIONS.name());
                authSession.setAuthNote("current.authentication.execution", execution);
                return ((LoginFormsProvider)session.getProvider(LoginFormsProvider.class)).setAuthenticationSession(authSession).setExecution(execution).setClientSessionCode(accessCode.getOrGenerateCode()).setAccessRequest(clientScopesToApprove).createOAuthGrant();
            }
            String consentDetail = grantedConsent != null ? "persistent_consent" : "no_consent_required";
            event.detail("consent", consentDetail);
        } else {
            event.detail("consent", "no_consent_required");
        }
        return null;
    }

    private static List<ClientScopeModel> getClientScopesToApproveOnConsentScreen(RealmModel realm, UserConsentModel grantedConsent, AuthenticationSessionModel authSession) {
        LinkedList<ClientScopeModel> clientScopesToDisplay = new LinkedList<ClientScopeModel>();
        for (String clientScopeId : authSession.getClientScopes()) {
            ClientScopeModel clientScope = KeycloakModelUtils.findClientScopeById((RealmModel)realm, (ClientModel)authSession.getClient(), (String)clientScopeId);
            if (clientScope == null || !clientScope.isDisplayOnConsentScreen() || grantedConsent != null && grantedConsent.isClientScopeGranted(clientScope)) continue;
            clientScopesToDisplay.add(clientScope);
        }
        return clientScopesToDisplay;
    }

    public static void setClientScopesInSession(AuthenticationSessionModel authSession) {
        ClientModel client = authSession.getClient();
        UserModel user = authSession.getAuthenticatedUser();
        String scopeParam = authSession.getClientNote("scope");
        Set requestedClientScopes = TokenManager.getRequestedClientScopes(scopeParam, client).map(ClientScopeModel::getId).collect(Collectors.toSet());
        authSession.setClientScopes(requestedClientScopes);
    }

    public static RequiredActionProvider createRequiredAction(RequiredActionContextResult context) {
        RequiredActionProvider provider;
        String display = context.getAuthenticationSession().getAuthNote("display");
        if (display == null) {
            return (RequiredActionProvider)context.getFactory().create(context.getSession());
        }
        if (context.getFactory() instanceof DisplayTypeRequiredActionFactory && (provider = ((DisplayTypeRequiredActionFactory)context.getFactory()).createDisplay(context.getSession(), display)) != null) {
            return provider;
        }
        if ("console".equalsIgnoreCase(display)) {
            context.getAuthenticationSession().removeAuthNote("display");
            throw new AuthenticationFlowException(AuthenticationFlowError.DISPLAY_NOT_SUPPORTED, ConsoleDisplayMode.browserContinue((KeycloakSession)context.getSession(), (String)context.getUriInfo().getRequestUri().toString()));
        }
        return (RequiredActionProvider)context.getFactory().create(context.getSession());
    }

    protected static Response executionActions(KeycloakSession session, AuthenticationSessionModel authSession, HttpRequest request, EventBuilder event, RealmModel realm, UserModel user, Stream<String> requiredActions) {
        Optional<Response> response = AuthenticationManager.sortRequiredActionsByPriority(realm, requiredActions).map(model -> AuthenticationManager.executeAction(session, authSession, model, request, event, realm, user, false)).filter(Objects::nonNull).findFirst();
        if (response.isPresent()) {
            return response.get();
        }
        String kcAction = authSession.getClientNote("kc_action");
        if (kcAction != null) {
            Optional<RequiredActionProviderModel> requiredAction = realm.getRequiredActionProvidersStream().filter(m -> Objects.equals(m.getProviderId(), kcAction)).findFirst();
            if (requiredAction.isPresent()) {
                return AuthenticationManager.executeAction(session, authSession, requiredAction.get(), request, event, realm, user, true);
            }
            logger.debugv("Requested action {0} not configured for realm", (Object)kcAction);
            AuthenticationManager.setKcActionStatus(kcAction, RequiredActionContext.KcActionStatus.ERROR, authSession);
        }
        return null;
    }

    private static Response executeAction(KeycloakSession session, AuthenticationSessionModel authSession, RequiredActionProviderModel model, HttpRequest request, EventBuilder event, RealmModel realm, UserModel user, boolean kcActionExecution) {
        RequiredActionFactory factory = (RequiredActionFactory)session.getKeycloakSessionFactory().getProviderFactory(RequiredActionProvider.class, model.getProviderId());
        if (factory == null) {
            throw new RuntimeException("Unable to find factory for Required Action: " + model.getProviderId() + " did you forget to declare it in a META-INF/services file?");
        }
        RequiredActionContextResult context = new RequiredActionContextResult(authSession, realm, event, session, request, user, factory);
        RequiredActionProvider actionProvider = null;
        try {
            actionProvider = AuthenticationManager.createRequiredAction(context);
        }
        catch (AuthenticationFlowException e) {
            if (e.getResponse() != null) {
                return e.getResponse();
            }
            throw e;
        }
        if (kcActionExecution) {
            if (actionProvider.initiatedActionSupport() == InitiatedActionSupport.NOT_SUPPORTED) {
                logger.debugv("Requested action {0} does not support being invoked with kc_action", (Object)factory.getId());
                AuthenticationManager.setKcActionStatus(factory.getId(), RequiredActionContext.KcActionStatus.ERROR, authSession);
                return null;
            }
            if (!model.isEnabled()) {
                logger.debugv("Requested action {0} is disabled and can't be invoked with kc_action", (Object)factory.getId());
                AuthenticationManager.setKcActionStatus(factory.getId(), RequiredActionContext.KcActionStatus.ERROR, authSession);
                return null;
            }
            authSession.setClientNote("kc_action_executing", factory.getId());
        }
        actionProvider.requiredActionChallenge((RequiredActionContext)context);
        if (context.getStatus() == RequiredActionContext.Status.FAILURE) {
            LoginProtocol protocol = (LoginProtocol)context.getSession().getProvider(LoginProtocol.class, context.getAuthenticationSession().getProtocol());
            protocol.setRealm(context.getRealm()).setHttpHeaders(context.getHttpRequest().getHttpHeaders()).setUriInfo(context.getUriInfo()).setEventBuilder(event);
            Response response = protocol.sendError(context.getAuthenticationSession(), LoginProtocol.Error.CONSENT_DENIED);
            event.error("rejected_by_user");
            return response;
        }
        if (context.getStatus() == RequiredActionContext.Status.CHALLENGE) {
            authSession.setAuthNote("current.authentication.execution", model.getProviderId());
            return context.getChallenge();
        }
        if (context.getStatus() == RequiredActionContext.Status.SUCCESS) {
            event.clone().event(EventType.CUSTOM_REQUIRED_ACTION).detail("custom_required_action", factory.getId()).success();
            authSession.getAuthenticatedUser().removeRequiredAction(factory.getId());
            authSession.removeRequiredAction(factory.getId());
            AuthenticationManager.setKcActionStatus(factory.getId(), RequiredActionContext.KcActionStatus.SUCCESS, authSession);
        }
        return null;
    }

    private static Stream<RequiredActionProviderModel> sortRequiredActionsByPriority(RealmModel realm, Stream<String> requiredActions) {
        return requiredActions.map(action -> {
            RequiredActionProviderModel model = realm.getRequiredActionProviderByAlias(action);
            if (model == null) {
                logger.warnv("Could not find configuration for Required Action {0}, did you forget to register it?", action);
            }
            return model;
        }).filter(Objects::nonNull).filter(RequiredActionProviderModel::isEnabled).sorted((Comparator<RequiredActionProviderModel>)RequiredActionProviderModel.RequiredActionComparator.SINGLETON);
    }

    public static void evaluateRequiredActionTriggers(KeycloakSession session, AuthenticationSessionModel authSession, HttpRequest request, EventBuilder event, RealmModel realm, UserModel user) {
        realm.getRequiredActionProvidersStream().filter(RequiredActionProviderModel::isEnabled).map(model -> AuthenticationManager.toRequiredActionFactory(session, model)).forEachOrdered(f -> AuthenticationManager.evaluateRequiredAction(session, authSession, request, event, realm, user, f));
    }

    private static void evaluateRequiredAction(KeycloakSession session, AuthenticationSessionModel authSession, HttpRequest request, EventBuilder event, RealmModel realm, UserModel user, RequiredActionFactory factory) {
        RequiredActionProvider provider = (RequiredActionProvider)factory.create(session);
        RequiredActionContextResult result = new RequiredActionContextResult(authSession, realm, event, session, request, user, factory){

            @Override
            public void challenge(Response response) {
                throw new RuntimeException("Not allowed to call challenge() within evaluateTriggers()");
            }

            @Override
            public void failure() {
                throw new RuntimeException("Not allowed to call failure() within evaluateTriggers()");
            }

            @Override
            public void success() {
                throw new RuntimeException("Not allowed to call success() within evaluateTriggers()");
            }

            @Override
            public void ignore() {
                throw new RuntimeException("Not allowed to call ignore() within evaluateTriggers()");
            }
        };
        provider.evaluateTriggers((RequiredActionContext)result);
    }

    private static RequiredActionFactory toRequiredActionFactory(KeycloakSession session, RequiredActionProviderModel model) {
        RequiredActionFactory factory = (RequiredActionFactory)session.getKeycloakSessionFactory().getProviderFactory(RequiredActionProvider.class, model.getProviderId());
        if (factory == null) {
            throw new RuntimeException("Unable to find factory for Required Action: " + model.getProviderId() + " did you forget to declare it in a META-INF/services file?");
        }
        return factory;
    }

    public static AuthResult verifyIdentityToken(KeycloakSession session, RealmModel realm, UriInfo uriInfo, ClientConnection connection, boolean checkActive, boolean checkTokenType, String checkAudience, boolean isCookie, String tokenString, HttpHeaders headers, TokenVerifier.Predicate<? super AccessToken> ... additionalChecks) {
        try {
            TokenVerifier verifier = TokenVerifier.create((String)tokenString, AccessToken.class).withDefaultChecks().realmUrl(Urls.realmIssuer(uriInfo.getBaseUri(), realm.getName())).checkActive(checkActive).checkTokenType(checkTokenType).withChecks(additionalChecks);
            if (checkAudience != null) {
                verifier.audience(new String[]{checkAudience});
            }
            String kid = verifier.getHeader().getKeyId();
            String algorithm = verifier.getHeader().getAlgorithm().name();
            SignatureVerifierContext signatureVerifier = ((SignatureProvider)session.getProvider(SignatureProvider.class, algorithm)).verifier(kid);
            verifier.verifierContext(signatureVerifier);
            AccessToken token = (AccessToken)verifier.verify().getToken();
            if (checkActive && (!token.isActive() || token.getIssuedAt() < realm.getNotBefore())) {
                logger.debug((Object)"Identity cookie expired");
                return null;
            }
            UserSessionModel userSession = null;
            UserModel user = null;
            if (token.getSessionState() == null ? !AuthenticationManager.isUserValid(session, realm, user = TokenManager.lookupUserFromStatelessToken(session, realm, token), token) : (userSession = session.sessions().getUserSession(realm, token.getSessionState())) != null && !AuthenticationManager.isUserValid(session, realm, user = userSession.getUser(), token)) {
                return null;
            }
            if (token.getSessionState() != null && !AuthenticationManager.isSessionValid(realm, userSession)) {
                UserSessionModel offlineUserSession;
                if (!isCookie && AuthenticationManager.isOfflineSessionValid(realm, offlineUserSession = session.sessions().getOfflineUserSession(realm, token.getSessionState()))) {
                    user = offlineUserSession.getUser();
                    return new AuthResult(user, offlineUserSession, token);
                }
                if (userSession != null) {
                    AuthenticationManager.backchannelLogout(session, realm, userSession, uriInfo, connection, headers, true);
                }
                logger.debug((Object)"User session not active");
                return null;
            }
            session.setAttribute("state_checker", token.getOtherClaims().get("state_checker"));
            return new AuthResult(user, userSession, token);
        }
        catch (VerificationException e) {
            logger.debugf("Failed to verify identity token: %s", (Object)e.getMessage());
            return null;
        }
    }

    private static boolean isUserValid(KeycloakSession session, RealmModel realm, UserModel user, AccessToken token) {
        if (user == null || !user.isEnabled()) {
            logger.debug((Object)"Unknown user in identity token");
            return false;
        }
        int userNotBefore = session.users().getNotBeforeOfUser(realm, user);
        if (token.getIssuedAt() < userNotBefore) {
            logger.debug((Object)"User notBefore newer than token");
            return false;
        }
        return true;
    }

    public static void setKcActionStatus(String executedProviderId, RequiredActionContext.KcActionStatus status, AuthenticationSessionModel authSession) {
        if (executedProviderId.equals(authSession.getClientNote("kc_action"))) {
            authSession.setClientNote("kc_action_status", status.name().toLowerCase());
            authSession.removeClientNote("kc_action");
            authSession.removeClientNote("kc_action_executing");
        }
    }

    public static void logSuccess(KeycloakSession session, AuthenticationSessionModel authSession) {
        UserModel user;
        RealmModel realm = session.getContext().getRealm();
        if (realm.isBruteForceProtected() && (user = AuthenticationManager.lookupUserForBruteForceLog(session, realm, authSession)) != null) {
            BruteForceProtector bruteForceProtector = (BruteForceProtector)session.getProvider(BruteForceProtector.class);
            bruteForceProtector.successfulLogin(realm, user, session.getContext().getConnection());
        }
    }

    public static UserModel lookupUserForBruteForceLog(KeycloakSession session, RealmModel realm, AuthenticationSessionModel authenticationSession) {
        UserModel user = authenticationSession.getAuthenticatedUser();
        if (user != null) {
            return user;
        }
        String username = authenticationSession.getAuthNote("ATTEMPTED_USERNAME");
        if (username != null) {
            return KeycloakModelUtils.findUserByNameOrEmail((KeycloakSession)session, (RealmModel)realm, (String)username);
        }
        return null;
    }

    public static class AuthResult {
        private final UserModel user;
        private final UserSessionModel session;
        private final AccessToken token;

        public AuthResult(UserModel user, UserSessionModel session, AccessToken token) {
            this.user = user;
            this.session = session;
            this.token = token;
        }

        public UserSessionModel getSession() {
            return this.session;
        }

        public UserModel getUser() {
            return this.user;
        }

        public AccessToken getToken() {
            return this.token;
        }
    }

    public static enum AuthenticationStatus {
        SUCCESS,
        ACCOUNT_TEMPORARILY_DISABLED,
        ACCOUNT_DISABLED,
        ACTIONS_REQUIRED,
        INVALID_USER,
        INVALID_CREDENTIALS,
        MISSING_PASSWORD,
        MISSING_TOTP,
        FAILED;

    }
}

