/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.services.ServicesLogger;

public class UserSessionManager {
    private static final Logger logger = Logger.getLogger(UserSessionManager.class);
    private final KeycloakSession kcSession;
    private final UserSessionPersisterProvider persister;

    public UserSessionManager(KeycloakSession session) {
        this.kcSession = session;
        this.persister = (UserSessionPersisterProvider)session.getProvider(UserSessionPersisterProvider.class);
    }

    public void createOrUpdateOfflineSession(AuthenticatedClientSessionModel clientSession, UserSessionModel userSession) {
        UserModel user = userSession.getUser();
        UserSessionModel offlineUserSession = this.kcSession.sessions().getOfflineUserSession(clientSession.getRealm(), userSession.getId());
        if (offlineUserSession == null) {
            offlineUserSession = this.createOfflineUserSession(user, userSession);
        } else {
            offlineUserSession.setLastSessionRefresh(Time.currentTime());
        }
        AuthenticatedClientSessionModel offlineClientSession = offlineUserSession.getAuthenticatedClientSessionByClient(clientSession.getClient().getId());
        if (offlineClientSession == null) {
            this.createOfflineClientSession(user, clientSession, offlineUserSession);
        }
    }

    public UserSessionModel findOfflineUserSession(RealmModel realm, String userSessionId) {
        return this.kcSession.sessions().getOfflineUserSession(realm, userSessionId);
    }

    public Set<ClientModel> findClientsWithOfflineToken(RealmModel realm, UserModel user) {
        return this.kcSession.sessions().getOfflineUserSessionsStream(realm, user).flatMap(userSession -> userSession.getAuthenticatedClientSessions().keySet().stream()).map(clientUUID -> realm.getClientById(clientUUID)).collect(Collectors.toSet());
    }

    @Deprecated
    public List<UserSessionModel> findOfflineSessions(RealmModel realm, UserModel user) {
        return this.findOfflineSessionsStream(realm, user).collect(Collectors.toList());
    }

    public Stream<UserSessionModel> findOfflineSessionsStream(RealmModel realm, UserModel user) {
        return this.kcSession.sessions().getOfflineUserSessionsStream(realm, user);
    }

    public boolean revokeOfflineToken(UserModel user, ClientModel client) {
        RealmModel realm = client.getRealm();
        AtomicBoolean anyRemoved = new AtomicBoolean(false);
        this.kcSession.sessions().getOfflineUserSessionsStream(realm, user).collect(Collectors.toList()).forEach(userSession -> {
            AuthenticatedClientSessionModel clientSession = userSession.getAuthenticatedClientSessionByClient(client.getId());
            if (clientSession != null) {
                if (logger.isTraceEnabled()) {
                    logger.tracef("Removing existing offline token for user '%s' and client '%s' .", (Object)user.getUsername(), (Object)client.getClientId());
                }
                clientSession.detachFromUserSession();
                this.persister.removeClientSession(userSession.getId(), client.getId(), true);
                this.checkOfflineUserSessionHasClientSessions(realm, user, (UserSessionModel)userSession);
                anyRemoved.set(true);
            }
        });
        return anyRemoved.get();
    }

    public void revokeOfflineUserSession(UserSessionModel userSession) {
        if (logger.isTraceEnabled()) {
            logger.tracef("Removing offline user session '%s' for user '%s' ", (Object)userSession.getId(), (Object)userSession.getLoginUsername());
        }
        this.kcSession.sessions().removeOfflineUserSession(userSession.getRealm(), userSession);
        this.persister.removeUserSession(userSession.getId(), true);
    }

    public boolean isOfflineTokenAllowed(ClientSessionContext clientSessionCtx) {
        RoleModel offlineAccessRole = clientSessionCtx.getClientSession().getRealm().getRole("offline_access");
        if (offlineAccessRole == null) {
            ServicesLogger.LOGGER.roleNotInRealm("offline_access");
            return false;
        }
        return clientSessionCtx.getRolesStream().collect(Collectors.toSet()).contains(offlineAccessRole);
    }

    private UserSessionModel createOfflineUserSession(UserModel user, UserSessionModel userSession) {
        if (logger.isTraceEnabled()) {
            logger.tracef("Creating new offline user session. UserSessionID: '%s' , Username: '%s'", (Object)userSession.getId(), (Object)user.getUsername());
        }
        UserSessionModel offlineUserSession = this.kcSession.sessions().createOfflineUserSession(userSession);
        this.persister.createUserSession(offlineUserSession, true);
        return offlineUserSession;
    }

    private void createOfflineClientSession(UserModel user, AuthenticatedClientSessionModel clientSession, UserSessionModel offlineUserSession) {
        if (logger.isTraceEnabled()) {
            logger.tracef("Creating new offline token client session. ClientSessionId: '%s', UserSessionID: '%s' , Username: '%s', Client: '%s'", new Object[]{clientSession.getId(), offlineUserSession.getId(), user.getUsername(), clientSession.getClient().getClientId()});
        }
        this.kcSession.sessions().createOfflineClientSession(clientSession, offlineUserSession);
        this.persister.createClientSession(clientSession, true);
    }

    private void checkOfflineUserSessionHasClientSessions(RealmModel realm, UserModel user, UserSessionModel userSession) {
        if (!userSession.getAuthenticatedClientSessions().isEmpty()) {
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.tracef("Removing offline userSession for user %s as it doesn't have any client sessions attached. UserSessionID: %s", (Object)user.getUsername(), (Object)userSession.getId());
        }
        this.kcSession.sessions().removeOfflineUserSession(realm, userSession);
        this.persister.removeUserSession(userSession.getId(), true);
    }
}

