/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.serializing.AbstractStoreSerializer;
import org.infinispan.configuration.serializing.SerializeUtils;
import org.infinispan.configuration.serializing.XMLExtendedStreamWriter;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.Attribute;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.DataColumnConfiguration;
import org.infinispan.persistence.jdbc.configuration.Element;
import org.infinispan.persistence.jdbc.configuration.IdColumnConfiguration;
import org.infinispan.persistence.jdbc.configuration.ManagedConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.PooledConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.SegmentColumnConfiguration;
import org.infinispan.persistence.jdbc.configuration.SimpleConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.jdbc.configuration.TimestampColumnConfiguration;

public abstract class AbstractJdbcStoreConfigurationSerializer
extends AbstractStoreSerializer {
    protected void writeJdbcStoreAttributes(XMLExtendedStreamWriter writer, AbstractJdbcStoreConfiguration configuration) throws XMLStreamException {
        configuration.attributes().write((XMLStreamWriter)writer);
    }

    private void writeJDBCStoreConnection(XMLExtendedStreamWriter writer, SimpleConnectionFactoryConfiguration configuration) throws XMLStreamException {
        writer.writeStartElement((Enum)Element.SIMPLE_CONNECTION);
        SerializeUtils.writeOptional((XMLExtendedStreamWriter)writer, (Enum)Attribute.CONNECTION_URL, (String)configuration.connectionUrl());
        SerializeUtils.writeOptional((XMLExtendedStreamWriter)writer, (Enum)Attribute.DRIVER_CLASS, (String)configuration.driverClass());
        SerializeUtils.writeOptional((XMLExtendedStreamWriter)writer, (Enum)Attribute.USERNAME, (String)configuration.username());
        SerializeUtils.writeOptional((XMLExtendedStreamWriter)writer, (Enum)Attribute.PASSWORD, (String)configuration.password());
        writer.writeEndElement();
    }

    private void writeJDBCStoreConnection(XMLExtendedStreamWriter writer, PooledConnectionFactoryConfiguration configuration) throws XMLStreamException {
        writer.writeStartElement((Enum)Element.CONNECTION_POOL);
        SerializeUtils.writeOptional((XMLExtendedStreamWriter)writer, (Enum)Attribute.CONNECTION_URL, (String)configuration.connectionUrl());
        SerializeUtils.writeOptional((XMLExtendedStreamWriter)writer, (Enum)Attribute.DRIVER_CLASS, (String)configuration.driverClass());
        SerializeUtils.writeOptional((XMLExtendedStreamWriter)writer, (Enum)Attribute.USERNAME, (String)configuration.username());
        SerializeUtils.writeOptional((XMLExtendedStreamWriter)writer, (Enum)Attribute.PASSWORD, (String)configuration.password());
        writer.writeEndElement();
    }

    private void writeJDBCStoreConnection(XMLExtendedStreamWriter writer, ManagedConnectionFactoryConfiguration configuration) throws XMLStreamException {
        writer.writeStartElement((Enum)Element.DATA_SOURCE);
        writer.writeAttribute((Enum)Attribute.JNDI_URL, configuration.jndiUrl());
        writer.writeEndElement();
    }

    protected void writeJDBCStoreConnection(XMLExtendedStreamWriter writer, AbstractJdbcStoreConfiguration configuration) throws XMLStreamException {
        ConnectionFactoryConfiguration cfc = configuration.connectionFactory();
        if (cfc instanceof SimpleConnectionFactoryConfiguration) {
            this.writeJDBCStoreConnection(writer, (SimpleConnectionFactoryConfiguration)cfc);
        } else if (cfc instanceof PooledConnectionFactoryConfiguration) {
            this.writeJDBCStoreConnection(writer, (PooledConnectionFactoryConfiguration)cfc);
        } else if (cfc instanceof ManagedConnectionFactoryConfiguration) {
            this.writeJDBCStoreConnection(writer, (ManagedConnectionFactoryConfiguration)cfc);
        }
    }

    protected void writeJDBCStoreTable(XMLExtendedStreamWriter writer, Element element, TableManipulationConfiguration configuration) throws XMLStreamException {
        AttributeSet attributes = configuration.attributes();
        writer.writeStartElement((Enum)element);
        attributes.write((XMLStreamWriter)writer, TableManipulationConfiguration.TABLE_NAME_PREFIX, (Enum)Attribute.PREFIX);
        attributes.write((XMLStreamWriter)writer, TableManipulationConfiguration.BATCH_SIZE, (Enum)Attribute.BATCH_SIZE);
        attributes.write((XMLStreamWriter)writer, TableManipulationConfiguration.FETCH_SIZE, (Enum)Attribute.FETCH_SIZE);
        attributes.write((XMLStreamWriter)writer, TableManipulationConfiguration.CREATE_ON_START, (Enum)Attribute.CREATE_ON_START);
        attributes.write((XMLStreamWriter)writer, TableManipulationConfiguration.DROP_ON_EXIT, (Enum)Attribute.DROP_ON_EXIT);
        this.writeJDBCStoreColumn(writer, Element.ID_COLUMN, configuration.idColumnConfiguration().attributes(), IdColumnConfiguration.ID_COLUMN_NAME, IdColumnConfiguration.ID_COLUMN_TYPE);
        this.writeJDBCStoreColumn(writer, Element.DATA_COLUMN, configuration.dataColumnConfiguration().attributes(), DataColumnConfiguration.DATA_COLUMN_NAME, DataColumnConfiguration.DATA_COLUMN_TYPE);
        this.writeJDBCStoreColumn(writer, Element.TIMESTAMP_COLUMN, configuration.timeStampColumnConfiguration().attributes(), TimestampColumnConfiguration.TIMESTAMP_COLUMN_NAME, TimestampColumnConfiguration.TIMESTAMP_COLUMN_TYPE);
        this.writeJDBCStoreColumn(writer, Element.SEGMENT_COLUMN, configuration.segmentColumnConfiguration().attributes(), SegmentColumnConfiguration.SEGMENT_COLUMN_NAME, SegmentColumnConfiguration.SEGMENT_COLUMN_TYPE);
        writer.writeEndElement();
    }

    private void writeJDBCStoreColumn(XMLExtendedStreamWriter writer, Element element, AttributeSet attributes, AttributeDefinition<?> columnName, AttributeDefinition<?> columnType) throws XMLStreamException {
        writer.writeStartElement((Enum)element);
        attributes.write((XMLStreamWriter)writer, columnName, (Enum)Attribute.NAME);
        attributes.write((XMLStreamWriter)writer, columnType, (Enum)Attribute.TYPE);
        writer.writeEndElement();
    }
}

