/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.executors.ExecutorFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.Parser;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.persistence.remote.configuration.Attribute;
import org.infinispan.persistence.remote.configuration.AuthenticationConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.ConnectionPoolConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.Element;
import org.infinispan.persistence.remote.configuration.ExecutorFactoryConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.ExhaustedAction;
import org.infinispan.persistence.remote.configuration.RemoteServerConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.SecurityConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.SslConfigurationBuilder;
import org.infinispan.persistence.remote.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Namespaces(value={@Namespace(root="remote-store"), @Namespace(uri="urn:infinispan:config:store:remote:*", root="remote-store")})
public class RemoteStoreConfigurationParser
implements ConfigurationParser {
    private static final Log log = (Log)LogFactory.getLog(RemoteStoreConfigurationParser.class, Log.class);

    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case REMOTE_STORE: {
                this.parseRemoteStore(reader, builder.persistence(), holder.getClassLoader());
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    private void parseRemoteStore(XMLExtendedStreamReader reader, PersistenceConfigurationBuilder persistenceBuilder, ClassLoader classLoader) throws XMLStreamException {
        RemoteStoreConfigurationBuilder builder = new RemoteStoreConfigurationBuilder(persistenceBuilder);
        this.parseRemoteStoreAttributes(reader, builder);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ASYNC_TRANSPORT_EXECUTOR: {
                    this.parseAsyncTransportExecutor(reader, builder.asyncExecutorFactory(), classLoader);
                    continue block6;
                }
                case CONNECTION_POOL: {
                    this.parseConnectionPool(reader, builder.connectionPool());
                    continue block6;
                }
                case SERVER: {
                    this.parseServer(reader, builder.addServer());
                    continue block6;
                }
                case SECURITY: {
                    this.parseSecurity(reader, builder.remoteSecurity());
                    continue block6;
                }
            }
            Parser.parseStoreElement((XMLExtendedStreamReader)reader, (StoreConfigurationBuilder)builder);
        }
        persistenceBuilder.addStore((StoreConfigurationBuilder)builder);
    }

    private void parseSecurity(XMLExtendedStreamReader reader, SecurityConfigurationBuilder security) throws XMLStreamException {
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case AUTHENTICATION: {
                    this.parseAuthentication(reader, security.authentication());
                    continue block4;
                }
                case ENCRYPTION: {
                    this.parseEncryption(reader, security.ssl());
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseAuthentication(XMLExtendedStreamReader reader, AuthenticationConfigurationBuilder authentication) throws XMLStreamException {
        authentication.enable();
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SERVER_NAME: {
                    authentication.serverName(value);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        boolean hasMech = false;
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case AUTH_PLAIN: {
                    if (hasMech) {
                        throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
                    }
                    this.parseAuthenticationPlain(reader, authentication);
                    hasMech = true;
                    continue block9;
                }
                case AUTH_DIGEST: {
                    if (hasMech) {
                        throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
                    }
                    this.parseAuthenticationDigest(reader, authentication);
                    hasMech = true;
                    continue block9;
                }
                case AUTH_EXTERNAL: {
                    if (hasMech) {
                        throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
                    }
                    this.parseAuthenticationExternal(reader, authentication);
                    hasMech = true;
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseAuthenticationPlain(XMLExtendedStreamReader reader, AuthenticationConfigurationBuilder authentication) throws XMLStreamException {
        String[] attributes = ParseUtils.requireAttributes((XMLStreamReader)reader, (String[])new String[]{Attribute.USERNAME.getLocalName(), Attribute.PASSWORD.getLocalName()});
        authentication.saslMechanism("PLAIN").username(attributes[0]).password(attributes[1]);
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseAuthenticationDigest(XMLExtendedStreamReader reader, AuthenticationConfigurationBuilder authentication) throws XMLStreamException {
        String[] attributes = ParseUtils.requireAttributes((XMLStreamReader)reader, (String[])new String[]{Attribute.USERNAME.getLocalName(), Attribute.PASSWORD.getLocalName(), Attribute.REALM.getLocalName()});
        authentication.saslMechanism("DIGEST-MD5").username(attributes[0]).password(attributes[1]).realm(attributes[2]);
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseAuthenticationExternal(XMLExtendedStreamReader reader, AuthenticationConfigurationBuilder authentication) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLStreamReader)reader);
        authentication.saslMechanism("EXTERNAL");
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseEncryption(XMLExtendedStreamReader reader, SslConfigurationBuilder ssl) throws XMLStreamException {
        ssl.enable();
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PROTOCOL: {
                    ssl.protocol(value);
                    continue block8;
                }
                case SNI_HOSTNAME: {
                    ssl.sniHostName(value);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case KEYSTORE: {
                    this.parseKeystore(reader, ssl);
                    continue block9;
                }
                case TRUSTSTORE: {
                    this.parseTruststore(reader, ssl);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseKeystore(XMLExtendedStreamReader reader, SslConfigurationBuilder ssl) throws XMLStreamException {
        String[] attributes = ParseUtils.requireAttributes((XMLStreamReader)reader, (boolean)true, (String[])new String[]{Attribute.FILENAME.getLocalName(), Attribute.PASSWORD.getLocalName()});
        ssl.keyStoreFileName(attributes[0]);
        ssl.keyStorePassword(attributes[1].toCharArray());
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FILENAME: 
                case PASSWORD: {
                    continue block6;
                }
                case CERTIFICATE_PASSWORD: {
                    ssl.keyStoreCertificatePassword(value.toCharArray());
                    continue block6;
                }
                case KEY_ALIAS: {
                    ssl.keyAlias(value);
                    continue block6;
                }
                case TYPE: {
                    ssl.keyStoreType(value);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseTruststore(XMLExtendedStreamReader reader, SslConfigurationBuilder ssl) throws XMLStreamException {
        String[] attributes = ParseUtils.requireAttributes((XMLStreamReader)reader, (boolean)true, (String[])new String[]{Attribute.FILENAME.getLocalName(), Attribute.PASSWORD.getLocalName()});
        ssl.trustStoreFileName(attributes[0]);
        ssl.trustStorePassword(attributes[1].toCharArray());
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FILENAME: 
                case PASSWORD: {
                    continue block4;
                }
                case TYPE: {
                    ssl.trustStoreType(value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseAsyncTransportExecutor(XMLExtendedStreamReader reader, ExecutorFactoryConfigurationBuilder builder, ClassLoader classLoader) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FACTORY: {
                    builder.factory((ExecutorFactory)Util.getInstance((String)value, (ClassLoader)classLoader));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        builder.withExecutorProperties(Parser.parseProperties((XMLExtendedStreamReader)reader));
    }

    private void parseConnectionPool(XMLExtendedStreamReader reader, ConnectionPoolConfigurationBuilder builder) throws XMLStreamException {
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case EXHAUSTED_ACTION: {
                    builder.exhaustedAction(ExhaustedAction.valueOf(value));
                    continue block9;
                }
                case MAX_ACTIVE: {
                    builder.maxActive(Integer.parseInt(value));
                    continue block9;
                }
                case MAX_PENDING_REQUESTS: {
                    builder.maxPendingRequests(Integer.parseInt(value));
                    continue block9;
                }
                case MIN_EVICTABLE_IDLE_TIME: {
                    builder.minEvictableIdleTime(Long.parseLong(value));
                    continue block9;
                }
                case MIN_IDLE: {
                    builder.minIdle(Integer.parseInt(value));
                    continue block9;
                }
                case MAX_WAIT: {
                    builder.maxWait(Integer.parseInt(value));
                    continue block9;
                }
                case MAX_IDLE: 
                case MAX_TOTAL: 
                case TEST_WHILE_IDLE: 
                case TIME_BETWEEN_EVICTION_RUNS: {
                    if (reader.getSchema().since(10, 0)) {
                        throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                    }
                    Log.CONFIG.ignoreXmlAttribute(attribute.getLocalName());
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseServer(XMLExtendedStreamReader reader, RemoteServerConfigurationBuilder builder) throws XMLStreamException {
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case HOST: {
                    builder.host(value);
                    continue block5;
                }
                case PORT: {
                    builder.port(Integer.parseInt(value));
                    continue block5;
                }
                case OUTBOUND_SOCKET_BINDING: {
                    Log.CONFIG.ignoreXmlAttribute((Object)attribute);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseRemoteStoreAttributes(XMLExtendedStreamReader reader, RemoteStoreConfigurationBuilder builder) throws XMLStreamException {
        block16: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            String attrName = reader.getAttributeLocalName(i);
            Attribute attribute = Attribute.forName(attrName);
            switch (attribute) {
                case BALANCING_STRATEGY: {
                    builder.balancingStrategy(value);
                    continue block16;
                }
                case CONNECT_TIMEOUT: {
                    builder.connectionTimeout(Long.parseLong(value));
                    continue block16;
                }
                case FORCE_RETURN_VALUES: {
                    builder.forceReturnValues(Boolean.parseBoolean(value));
                    continue block16;
                }
                case HOTROD_WRAPPING: {
                    builder.hotRodWrapping(Boolean.parseBoolean(value));
                    continue block16;
                }
                case KEY_SIZE_ESTIMATE: {
                    builder.keySizeEstimate(Integer.parseInt(value));
                    continue block16;
                }
                case MARSHALLER: {
                    builder.marshaller(value);
                    continue block16;
                }
                case PING_ON_STARTUP: {
                    if (!reader.getSchema().since(9, 1)) {
                        throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                    }
                    Log.CONFIG.ignoreXmlAttribute((Object)attribute);
                    continue block16;
                }
                case PROTOCOL_VERSION: {
                    builder.protocolVersion(ProtocolVersion.parseVersion((String)value));
                    continue block16;
                }
                case RAW_VALUES: {
                    builder.rawValues(Boolean.parseBoolean(value));
                    continue block16;
                }
                case REMOTE_CACHE_NAME: {
                    builder.remoteCacheName(value);
                    continue block16;
                }
                case SOCKET_TIMEOUT: {
                    builder.socketTimeout(Long.parseLong(value));
                    continue block16;
                }
                case TCP_NO_DELAY: {
                    builder.tcpNoDelay(Boolean.parseBoolean(value));
                    continue block16;
                }
                case TRANSPORT_FACTORY: {
                    builder.transportFactory(value);
                    continue block16;
                }
                case VALUE_SIZE_ESTIMATE: {
                    builder.valueSizeEstimate(Integer.parseInt(value));
                    continue block16;
                }
                default: {
                    Parser.parseStoreAttribute((XMLExtendedStreamReader)reader, (int)i, (AbstractStoreConfigurationBuilder)builder);
                }
            }
        }
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    public Class<? extends ConfigurationBuilderInfo> getConfigurationBuilderInfo() {
        return RemoteStoreConfigurationBuilder.class;
    }
}

