/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.cache.infinispan.RealmCacheSession;
import org.keycloak.models.cache.infinispan.entities.CachedClientScope;
import org.keycloak.models.utils.RoleUtils;

public class ClientScopeAdapter
implements ClientScopeModel {
    protected RealmCacheSession cacheSession;
    protected RealmModel cachedRealm;
    protected ClientScopeModel updated;
    protected CachedClientScope cached;
    protected boolean invalidated;

    public ClientScopeAdapter(RealmModel cachedRealm, CachedClientScope cached, RealmCacheSession cacheSession) {
        this.cachedRealm = cachedRealm;
        this.cacheSession = cacheSession;
        this.cached = cached;
    }

    private void getDelegateForUpdate() {
        if (this.updated == null) {
            this.cacheSession.registerClientScopeInvalidation(this.cached.getId());
            this.updated = this.cacheSession.getRealmDelegate().getClientScopeById(this.cached.getId(), this.cachedRealm);
            if (this.updated == null) {
                throw new IllegalStateException("Not found in database");
            }
        }
    }

    public void invalidate() {
        this.invalidated = true;
    }

    protected boolean isUpdated() {
        if (this.updated != null) {
            return true;
        }
        if (!this.invalidated) {
            return false;
        }
        this.updated = this.cacheSession.getRealmDelegate().getClientScopeById(this.cached.getId(), this.cachedRealm);
        if (this.updated == null) {
            throw new IllegalStateException("Not found in database");
        }
        return true;
    }

    public String getId() {
        if (this.isUpdated()) {
            return this.updated.getId();
        }
        return this.cached.getId();
    }

    public RealmModel getRealm() {
        return this.cachedRealm;
    }

    public Stream<ProtocolMapperModel> getProtocolMappersStream() {
        if (this.isUpdated()) {
            return this.updated.getProtocolMappersStream();
        }
        return this.cached.getProtocolMappers().stream();
    }

    public ProtocolMapperModel addProtocolMapper(ProtocolMapperModel model) {
        this.getDelegateForUpdate();
        return this.updated.addProtocolMapper(model);
    }

    public void removeProtocolMapper(ProtocolMapperModel mapping) {
        this.getDelegateForUpdate();
        this.updated.removeProtocolMapper(mapping);
    }

    public void updateProtocolMapper(ProtocolMapperModel mapping) {
        this.getDelegateForUpdate();
        this.updated.updateProtocolMapper(mapping);
    }

    public ProtocolMapperModel getProtocolMapperById(String id) {
        for (ProtocolMapperModel mapping : this.cached.getProtocolMappers()) {
            if (!mapping.getId().equals(id)) continue;
            return mapping;
        }
        return null;
    }

    public ProtocolMapperModel getProtocolMapperByName(String protocol, String name) {
        for (ProtocolMapperModel mapping : this.cached.getProtocolMappers()) {
            if (!mapping.getProtocol().equals(protocol) || !mapping.getName().equals(name)) continue;
            return mapping;
        }
        return null;
    }

    public String getName() {
        if (this.isUpdated()) {
            return this.updated.getName();
        }
        return this.cached.getName();
    }

    public void setName(String name) {
        this.getDelegateForUpdate();
        this.updated.setName(name);
    }

    public String getDescription() {
        if (this.isUpdated()) {
            return this.updated.getDescription();
        }
        return this.cached.getDescription();
    }

    public void setDescription(String description) {
        this.getDelegateForUpdate();
        this.updated.setDescription(description);
    }

    public String getProtocol() {
        if (this.isUpdated()) {
            return this.updated.getProtocol();
        }
        return this.cached.getProtocol();
    }

    public void setProtocol(String protocol) {
        this.getDelegateForUpdate();
        this.updated.setProtocol(protocol);
    }

    public Stream<RoleModel> getScopeMappingsStream() {
        if (this.isUpdated()) {
            return this.updated.getScopeMappingsStream();
        }
        return this.cached.getScope().stream().map(id -> this.cacheSession.getRoleById(this.cachedRealm, (String)id));
    }

    public void addScopeMapping(RoleModel role) {
        this.getDelegateForUpdate();
        this.updated.addScopeMapping(role);
    }

    public void deleteScopeMapping(RoleModel role) {
        this.getDelegateForUpdate();
        this.updated.deleteScopeMapping(role);
    }

    public Stream<RoleModel> getRealmScopeMappingsStream() {
        return this.getScopeMappingsStream().filter(r -> RoleUtils.isRealmRole((RoleModel)r, (RealmModel)this.cachedRealm));
    }

    public boolean hasScope(RoleModel role) {
        if (this.isUpdated()) {
            return this.updated.hasScope(role);
        }
        if (this.cached.getScope().contains(role.getId())) {
            return true;
        }
        return RoleUtils.hasRole(this.getScopeMappingsStream(), (RoleModel)role);
    }

    public void setAttribute(String name, String value) {
        this.getDelegateForUpdate();
        this.updated.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.getDelegateForUpdate();
        this.updated.removeAttribute(name);
    }

    public String getAttribute(String name) {
        if (this.isUpdated()) {
            return this.updated.getAttribute(name);
        }
        return this.cached.getAttributes().get(name);
    }

    public Map<String, String> getAttributes() {
        if (this.isUpdated()) {
            return this.updated.getAttributes();
        }
        HashMap<String, String> copy = new HashMap<String, String>();
        copy.putAll(this.cached.getAttributes());
        return copy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientScopeModel)) {
            return false;
        }
        ClientScopeModel that = (ClientScopeModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

