/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.cache.infinispan.RealmCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.RealmCacheInvalidationEvent;

@SerializeWith(value=ExternalizerImpl.class)
public class RealmRemovedEvent
extends InvalidationEvent
implements RealmCacheInvalidationEvent {
    private String realmId;
    private String realmName;

    public static RealmRemovedEvent create(String realmId, String realmName) {
        RealmRemovedEvent event = new RealmRemovedEvent();
        event.realmId = realmId;
        event.realmName = realmName;
        return event;
    }

    @Override
    public String getId() {
        return this.realmId;
    }

    public String toString() {
        return String.format("RealmRemovedEvent [ realmId=%s, realmName=%s ]", this.realmId, this.realmName);
    }

    @Override
    public void addInvalidations(RealmCacheManager realmCache, Set<String> invalidations) {
        realmCache.realmRemoval(this.realmId, this.realmName, invalidations);
    }

    public static class ExternalizerImpl
    implements Externalizer<RealmRemovedEvent> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, RealmRemovedEvent obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.realmId, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.realmName, (ObjectOutput)output);
        }

        public RealmRemovedEvent readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public RealmRemovedEvent readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            RealmRemovedEvent res = new RealmRemovedEvent();
            res.realmId = MarshallUtil.unmarshallString((ObjectInput)input);
            res.realmName = MarshallUtil.unmarshallString((ObjectInput)input);
            return res;
        }
    }
}

