/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.TransientQueueManager;
import org.apache.activemq.artemis.utils.ReferenceCounterUtil;
import org.jboss.logging.Logger;

public class TransientQueueManagerImpl
extends ReferenceCounterUtil
implements TransientQueueManager {
    private static final Logger logger = Logger.getLogger(TransientQueueManagerImpl.class);
    private final SimpleString queueName;
    private final ActiveMQServer server;

    private void doIt() {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("deleting temporary queue " + this.queueName));
            }
            try {
                this.server.destroyQueue(this.queueName, null, false);
            }
            catch (ActiveMQNonExistentQueueException activeMQNonExistentQueueException) {
            }
            catch (ActiveMQException e) {
                ActiveMQServerLogger.LOGGER.errorOnDeletingQueue(this.queueName.toString(), (Exception)((Object)e));
            }
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.errorRemovingTempQueue(e, this.queueName);
        }
    }

    public TransientQueueManagerImpl(ActiveMQServer server, SimpleString queueName) {
        this.server = server;
        this.queueName = queueName;
        this.setTask(this::doIt);
    }

    @Override
    public SimpleString getQueueName() {
        return this.queueName;
    }
}

