/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.wildfly.common.Assert;
import org.wildfly.httpclient.common.HttpClientMessages;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSourceChannel;

class WildflyClientInputStream
extends InputStream {
    private final Object lock = new Object();
    private final ByteBufferPool bufferPool;
    private final StreamSourceChannel channel;
    private PooledByteBuffer pooledByteBuffer;
    private IOException ioException;
    private int state;
    private static final int FLAG_CLOSED = 1;
    private static final int FLAG_MINUS_ONE_READ = 4;
    private final ChannelListener<StreamSourceChannel> channelListener = new ChannelListener<StreamSourceChannel>(){

        /*
         * Exception decompiling
         */
        public void handleEvent(StreamSourceChannel streamSourceChannel) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[UNCONDITIONALDOLOOP]], but top level block is 4[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    };

    WildflyClientInputStream(ByteBufferPool bufferPool, StreamSourceChannel channel) {
        this.bufferPool = bufferPool;
        this.channel = channel;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int res = this.read(b);
        if (res == 1) {
            return b[0] & 0xFF;
        }
        return res;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (len < 1) {
                return 0;
            }
            if (Thread.currentThread() == this.channel.getIoThread()) {
                throw HttpClientMessages.MESSAGES.blockingIoFromIOThread();
            }
            if (Bits.anyAreSet((int)this.state, (int)1) && !Bits.anyAreSet((int)this.state, (int)4)) {
                throw HttpClientMessages.MESSAGES.streamIsClosed();
            }
            if (this.ioException != null) {
                throw new IOException(this.ioException);
            }
            while (this.pooledByteBuffer == null) {
                if (Bits.anyAreSet((int)this.state, (int)4)) {
                    this.state |= 1;
                    return -1;
                }
                this.runReadTask();
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException(e.getMessage());
                }
            }
            int toRead = Math.min(this.pooledByteBuffer.getBuffer().remaining(), len);
            this.pooledByteBuffer.getBuffer().get(b, off, toRead);
            if (!this.pooledByteBuffer.getBuffer().hasRemaining()) {
                this.pooledByteBuffer.close();
                this.pooledByteBuffer = null;
            }
            return toRead;
        }
    }

    private void runReadTask() {
        Assert.assertTrue((this.pooledByteBuffer == null ? 1 : 0) != 0);
        this.channel.getReadSetter().set(this.channelListener);
        this.channel.wakeupReads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.pooledByteBuffer != null) {
                return this.pooledByteBuffer.getBuffer().remaining();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            IoUtils.safeClose((Closeable)this.pooledByteBuffer);
            this.pooledByteBuffer = null;
            while (Bits.allAreClear((int)this.state, (int)4) && this.ioException == null) {
                this.runReadTask();
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    IoUtils.safeClose((Closeable[])new Closeable[]{this.pooledByteBuffer, this.channel});
                    throw new InterruptedIOException(e.getMessage());
                }
                IoUtils.safeClose((Closeable)this.pooledByteBuffer);
                this.pooledByteBuffer = null;
            }
        }
    }

    static /* synthetic */ Object access$000(WildflyClientInputStream x0) {
        return x0.lock;
    }

    static /* synthetic */ PooledByteBuffer access$100(WildflyClientInputStream x0) {
        return x0.pooledByteBuffer;
    }

    static /* synthetic */ ByteBufferPool access$200(WildflyClientInputStream x0) {
        return x0.bufferPool;
    }

    static /* synthetic */ PooledByteBuffer access$102(WildflyClientInputStream x0, PooledByteBuffer x1) {
        x0.pooledByteBuffer = x1;
        return x0.pooledByteBuffer;
    }

    static /* synthetic */ int access$300(WildflyClientInputStream x0) {
        return x0.state;
    }

    static /* synthetic */ int access$302(WildflyClientInputStream x0, int x1) {
        x0.state = x1;
        return x0.state;
    }

    static /* synthetic */ IOException access$402(WildflyClientInputStream x0, IOException x1) {
        x0.ioException = x1;
        return x0.ioException;
    }
}

