/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.model;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.json.bind.config.PropertyVisibilityStrategy;
import org.eclipse.yasson.internal.model.GetFromField;
import org.eclipse.yasson.internal.model.GetFromGetter;
import org.eclipse.yasson.internal.model.GetValueCommand;
import org.eclipse.yasson.internal.model.Property;
import org.eclipse.yasson.internal.model.PropertyValuePropagation;
import org.eclipse.yasson.internal.model.SetValueCommand;
import org.eclipse.yasson.internal.model.SetWithField;
import org.eclipse.yasson.internal.model.SetWithSetter;

public class ReflectionPropagation
extends PropertyValuePropagation {
    private GetValueCommand getValueCommand;
    private SetValueCommand setValueCommand;

    public ReflectionPropagation(Property property, PropertyVisibilityStrategy strategy) {
        super(property, strategy);
    }

    @Override
    protected void acceptMethod(Method method, PropertyValuePropagation.OperationMode mode) {
        switch (mode) {
            case GET: {
                this.getValueCommand = new GetFromGetter(method);
                break;
            }
            case SET: {
                this.setValueCommand = new SetWithSetter(method);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown mode");
            }
        }
    }

    @Override
    protected void acceptField(Field field, PropertyValuePropagation.OperationMode mode) {
        switch (mode) {
            case GET: {
                this.getValueCommand = new GetFromField(field);
                break;
            }
            case SET: {
                this.setValueCommand = new SetWithField(field);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown mode");
            }
        }
    }

    @Override
    void setValue(Object object, Object value) {
        this.setValueCommand.setValue(object, value);
    }

    @Override
    Object getValue(Object object) {
        return this.getValueCommand.getValue(object);
    }
}

