/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.util.CanonicalPathUtils;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.vfs.VirtualFile;
import org.wildfly.extension.undertow.deployment.ServletResource;
import org.wildfly.extension.undertow.deployment.VirtualFileResource;

public class ServletResourceManager
implements ResourceManager {
    public static final int TRANSFER_MIN_SIZE = 0x100000;
    private final PathResourceManager deploymentResourceManager;
    private final Collection<VirtualFile> overlays;
    private final ResourceManager[] externalOverlays;
    private final boolean explodedDeployment;

    public ServletResourceManager(VirtualFile resourcesRoot, Collection<VirtualFile> overlays, boolean explodedDeployment, boolean followSymlink, boolean disableFileWatchService, List<String> externalOverlays) throws IOException {
        this.explodedDeployment = explodedDeployment;
        Path physicalFile = resourcesRoot.getPhysicalFile().toPath().toRealPath(new LinkOption[0]);
        this.deploymentResourceManager = new PathResourceManager(physicalFile, 0x100000L, true, followSymlink, !disableFileWatchService, new String[0]);
        this.overlays = overlays;
        if (externalOverlays == null) {
            this.externalOverlays = new ResourceManager[0];
        } else {
            this.externalOverlays = new ResourceManager[externalOverlays.size()];
            for (int i = 0; i < externalOverlays.size(); ++i) {
                String path = externalOverlays.get(i);
                PathResourceManager pr = new PathResourceManager(Paths.get(path, new String[0]).toRealPath(new LinkOption[0]), 0x100000L, true, followSymlink, !disableFileWatchService, new String[0]);
                this.externalOverlays[i] = pr;
            }
        }
    }

    public Resource getResource(String path) throws IOException {
        Resource res = this.deploymentResourceManager.getResource(path);
        if (res != null) {
            return new ServletResource(this, res);
        }
        String p = path;
        if (p.startsWith("/")) {
            p = p.substring(1);
        }
        if (this.overlays != null) {
            String canonical = CanonicalPathUtils.canonicalize((String)p);
            for (VirtualFile overlay : this.overlays) {
                VirtualFile child = overlay.getChild(canonical);
                if (!child.exists()) continue;
                try {
                    child.getPathNameRelativeTo(overlay);
                    return new ServletResource(this, new VirtualFileResource(overlay.getPhysicalFile(), child, canonical));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        for (int i = 0; i < this.externalOverlays.length; ++i) {
            ResourceManager manager = this.externalOverlays[i];
            res = manager.getResource(path);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public boolean isResourceChangeListenerSupported() {
        return true;
    }

    public void registerResourceChangeListener(ResourceChangeListener listener) {
        if (this.explodedDeployment && this.deploymentResourceManager.isResourceChangeListenerSupported()) {
            this.deploymentResourceManager.registerResourceChangeListener(listener);
        }
        for (ResourceManager external : this.externalOverlays) {
            if (!external.isResourceChangeListenerSupported()) continue;
            external.registerResourceChangeListener(listener);
        }
    }

    public void removeResourceChangeListener(ResourceChangeListener listener) {
        if (this.deploymentResourceManager.isResourceChangeListenerSupported()) {
            this.deploymentResourceManager.removeResourceChangeListener(listener);
        }
        for (ResourceManager external : this.externalOverlays) {
            if (!external.isResourceChangeListenerSupported()) continue;
            external.removeResourceChangeListener(listener);
        }
    }

    public void close() throws IOException {
        this.deploymentResourceManager.close();
    }

    public List<Resource> list(String path) {
        try {
            String p;
            ArrayList<Resource> ret = new ArrayList<Resource>();
            Resource res = this.deploymentResourceManager.getResource(path);
            if (res != null) {
                for (Resource child : res.list()) {
                    ret.add(new ServletResource(this, child));
                }
            }
            if ((p = path).startsWith("/")) {
                p = p.substring(1);
            }
            if (this.overlays != null) {
                for (VirtualFile overlay : this.overlays) {
                    VirtualFile child = overlay.getChild(p);
                    if (!child.exists()) continue;
                    VirtualFileResource vfsResource = new VirtualFileResource(overlay.getPhysicalFile(), child, path);
                    for (Resource c : vfsResource.list()) {
                        ret.add(new ServletResource(this, c));
                    }
                }
            }
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

