/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.idm;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DeprecatedResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.wildfly.extension.picketlink.idm.IDMSubsystemRootResourceDefinition;
import org.wildfly.extension.picketlink.idm.Namespace;
import org.wildfly.extension.picketlink.idm.model.IdentityConfigurationResourceDefinition;
import org.wildfly.extension.picketlink.idm.model.LDAPStoreResourceDefinition;
import org.wildfly.extension.picketlink.idm.model.PartitionManagerResourceDefinition;

public class IDMExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "picketlink-identity-management";
    private static final String RESOURCE_NAME = IDMExtension.class.getPackage().getName() + ".LocalDescriptions";
    private static final ModelVersion CURRENT_MODEL_VERSION = ModelVersion.create((int)org.wildfly.extension.picketlink.federation.Namespace.CURRENT.getMajor(), (int)org.wildfly.extension.picketlink.federation.Namespace.CURRENT.getMinor());
    public static final ModelVersion DEPRECATED_SINCE = ModelVersion.create((int)2, (int)0, (int)0);

    public static ResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        return new DeprecatedResourceDescriptionResolver(SUBSYSTEM_NAME, keyPrefix, RESOURCE_NAME, IDMExtension.class.getClassLoader(), true, true);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, CURRENT_MODEL_VERSION);
        subsystem.registerSubsystemModel((ResourceDefinition)IDMSubsystemRootResourceDefinition.INSTANCE);
        subsystem.registerXMLElementWriter(Namespace.CURRENT.getXMLWriter());
        if (context.isRegisterTransformers()) {
            this.registerTransformers_1_0(context, subsystem);
        }
    }

    private void registerTransformers_1_0(ExtensionContext context, SubsystemRegistration subsystemRegistration) {
        ResourceTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        ResourceTransformationDescriptionBuilder partitionManagerResourceBuilder = builder.addChildResource((ResourceDefinition)PartitionManagerResourceDefinition.INSTANCE);
        ResourceTransformationDescriptionBuilder identityConfigResourceBuilder = partitionManagerResourceBuilder.addChildResource((ResourceDefinition)IdentityConfigurationResourceDefinition.INSTANCE);
        ResourceTransformationDescriptionBuilder ldapTransfDescBuilder = identityConfigResourceBuilder.addChildResource((ResourceDefinition)LDAPStoreResourceDefinition.INSTANCE);
        ((AttributeTransformationDescriptionBuilder)ldapTransfDescBuilder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{LDAPStoreResourceDefinition.ACTIVE_DIRECTORY})).setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, new AttributeDefinition[]{LDAPStoreResourceDefinition.ACTIVE_DIRECTORY});
        ((AttributeTransformationDescriptionBuilder)ldapTransfDescBuilder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{LDAPStoreResourceDefinition.UNIQUE_ID_ATTRIBUTE_NAME})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{LDAPStoreResourceDefinition.UNIQUE_ID_ATTRIBUTE_NAME});
        TransformationDescription.Tools.register((TransformationDescription)builder.build(), (SubsystemRegistration)subsystemRegistration, (ModelVersionRange)ModelVersion.create((int)1, (int)0));
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.CURRENT.getUri(), Namespace.CURRENT::getXMLReader);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.PICKETLINK_IDENTITY_MANAGEMENT_1_1.getUri(), Namespace.PICKETLINK_IDENTITY_MANAGEMENT_1_1::getXMLReader);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.PICKETLINK_IDENTITY_MANAGEMENT_1_0.getUri(), Namespace.PICKETLINK_IDENTITY_MANAGEMENT_1_0::getXMLReader);
    }
}

