/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.spec.SecretKeySpec;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.broker.social.SocialIdentityProviderFactory;
import org.keycloak.common.util.CertificateUtils;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.common.util.PemUtils;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.Constants;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.KeycloakTransactionManager;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.ScopeContainerModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.CertificateRepresentation;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.transaction.JtaTransactionManagerLookup;

public final class KeycloakModelUtils {
    private KeycloakModelUtils() {
    }

    public static String generateId() {
        return UUID.randomUUID().toString();
    }

    public static byte[] generateSecret() {
        return KeycloakModelUtils.generateSecret(32);
    }

    public static byte[] generateSecret(int bytes) {
        byte[] buf = new byte[bytes];
        new SecureRandom().nextBytes(buf);
        return buf;
    }

    public static PublicKey getPublicKey(String publicKeyPem) {
        if (publicKeyPem != null) {
            try {
                return PemUtils.decodePublicKey((String)publicKeyPem);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static X509Certificate getCertificate(String cert) {
        if (cert != null) {
            try {
                return PemUtils.decodeCertificate((String)cert);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static PrivateKey getPrivateKey(String privateKeyPem) {
        if (privateKeyPem != null) {
            try {
                return PemUtils.decodePrivateKey((String)privateKeyPem);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static Key getSecretKey(String secret) {
        return secret != null ? new SecretKeySpec(secret.getBytes(), "HmacSHA256") : null;
    }

    public static String getPemFromKey(Key key) {
        return PemUtils.encodeKey((Key)key);
    }

    public static String getPemFromCertificate(X509Certificate certificate) {
        return PemUtils.encodeCertificate((Certificate)certificate);
    }

    public static CertificateRepresentation generateKeyPairCertificate(String subject) {
        KeyPair keyPair = KeyUtils.generateRsaKeyPair((int)2048);
        X509Certificate certificate = CertificateUtils.generateV1SelfSignedCertificate((KeyPair)keyPair, (String)subject);
        String privateKeyPem = PemUtils.encodeKey((Key)keyPair.getPrivate());
        String certPem = PemUtils.encodeCertificate((Certificate)certificate);
        CertificateRepresentation rep = new CertificateRepresentation();
        rep.setPrivateKey(privateKeyPem);
        rep.setCertificate(certPem);
        return rep;
    }

    public static UserCredentialModel generateSecret(ClientModel client) {
        UserCredentialModel secret = UserCredentialModel.generateSecret();
        client.setSecret(secret.getChallengeResponse());
        return secret;
    }

    public static String getDefaultClientAuthenticatorType() {
        return "client-secret";
    }

    public static String generateCodeSecret() {
        return UUID.randomUUID().toString();
    }

    public static ClientModel createClient(RealmModel realm, String name) {
        ClientModel app = realm.addClient(name);
        app.setClientAuthenticatorType(KeycloakModelUtils.getDefaultClientAuthenticatorType());
        KeycloakModelUtils.generateSecret(app);
        app.setFullScopeAllowed(true);
        return app;
    }

    public static boolean searchFor(RoleModel role, RoleModel composite, Set<String> visited) {
        if (visited.contains(composite.getId())) {
            return false;
        }
        visited.add(composite.getId());
        if (!composite.isComposite()) {
            return false;
        }
        Set compositeRoles = composite.getCompositesStream().collect(Collectors.toSet());
        return compositeRoles.contains(role) || compositeRoles.stream().anyMatch(x -> x.isComposite() && KeycloakModelUtils.searchFor(role, x, visited));
    }

    public static UserModel findUserByNameOrEmail(KeycloakSession session, RealmModel realm, String username) {
        UserModel user;
        if (realm.isLoginWithEmailAllowed() && username.indexOf(64) != -1 && (user = session.users().getUserByEmail(username, realm)) != null) {
            return user;
        }
        return session.users().getUserByUsername(username, realm);
    }

    public static void runJobInTransaction(KeycloakSessionFactory factory, KeycloakSessionTask task) {
        KeycloakSession session = factory.create();
        KeycloakTransactionManager tx = session.getTransactionManager();
        try {
            tx.begin();
            task.run(session);
            if (tx.isActive()) {
                if (tx.getRollbackOnly()) {
                    tx.rollback();
                } else {
                    tx.commit();
                }
            }
        }
        catch (RuntimeException re) {
            if (tx.isActive()) {
                tx.rollback();
            }
            throw re;
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runJobInTransactionWithTimeout(KeycloakSessionFactory factory, KeycloakSessionTask task, int timeoutInSeconds) {
        JtaTransactionManagerLookup lookup = (JtaTransactionManagerLookup)factory.getProviderFactory(JtaTransactionManagerLookup.class);
        try {
            if (lookup != null && lookup.getTransactionManager() != null) {
                try {
                    lookup.getTransactionManager().setTransactionTimeout(timeoutInSeconds);
                }
                catch (SystemException e) {
                    throw new RuntimeException(e);
                }
            }
            KeycloakModelUtils.runJobInTransaction(factory, task);
        }
        finally {
            if (lookup != null && lookup.getTransactionManager() != null) {
                try {
                    lookup.getTransactionManager().setTransactionTimeout(0);
                }
                catch (SystemException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static String getMasterRealmAdminApplicationClientId(String realmName) {
        return realmName + "-realm";
    }

    public static UserStorageProviderModel findUserStorageProviderByName(String displayName, RealmModel realm) {
        if (displayName == null) {
            return null;
        }
        return realm.getUserStorageProvidersStream().filter(fedProvider -> Objects.equals(fedProvider.getName(), displayName)).findFirst().orElse(null);
    }

    public static UserStorageProviderModel findUserStorageProviderById(String fedProviderId, RealmModel realm) {
        return realm.getUserStorageProvidersStream().filter(fedProvider -> Objects.equals(fedProvider.getId(), fedProviderId)).findFirst().orElse(null);
    }

    public static ComponentModel createComponentModel(String name, String parentId, String providerId, String providerType, String ... config) {
        ComponentModel mapperModel = new ComponentModel();
        mapperModel.setParentId(parentId);
        mapperModel.setName(name);
        mapperModel.setProviderId(providerId);
        mapperModel.setProviderType(providerType);
        String key = null;
        for (String configEntry : config) {
            if (key == null) {
                key = configEntry;
                continue;
            }
            mapperModel.getConfig().add((Object)key, (Object)configEntry);
            key = null;
        }
        if (key != null) {
            throw new IllegalStateException("Invalid count of arguments for config. Maybe mistake?");
        }
        return mapperModel;
    }

    public static String toLowerCaseSafe(String str) {
        return str == null ? null : str.toLowerCase();
    }

    public static RoleModel setupOfflineRole(RealmModel realm) {
        RoleModel offlineRole = realm.getRole("offline_access");
        if (offlineRole == null) {
            offlineRole = realm.addRole("offline_access");
            offlineRole.setDescription("${role_offline-access}");
            realm.addDefaultRole("offline_access");
        }
        return offlineRole;
    }

    public static void setupDeleteAccount(ClientModel accountClient) {
        RoleModel deleteOwnAccount = accountClient.getRole("delete-account");
        if (deleteOwnAccount == null) {
            deleteOwnAccount = accountClient.addRole("delete-account");
        }
        deleteOwnAccount.setDescription("${role_delete-account}");
    }

    public static void deepFindAuthenticationExecutions(RealmModel realm, AuthenticationFlowModel flow, List<AuthenticationExecutionModel> result) {
        realm.getAuthenticationExecutionsStream(flow.getId()).forEachOrdered(execution -> {
            if (execution.isAuthenticatorFlow()) {
                AuthenticationFlowModel subFlow = realm.getAuthenticationFlowById(execution.getFlowId());
                KeycloakModelUtils.deepFindAuthenticationExecutions(realm, subFlow, result);
            } else {
                result.add((AuthenticationExecutionModel)execution);
            }
        });
    }

    public static String resolveFirstAttribute(GroupModel group, String name) {
        String value = group.getFirstAttribute(name);
        if (value != null) {
            return value;
        }
        if (group.getParentId() == null) {
            return null;
        }
        return KeycloakModelUtils.resolveFirstAttribute(group.getParent(), name);
    }

    public static List<String> resolveAttribute(GroupModel group, String name) {
        List<String> values = group.getAttributeStream(name).collect(Collectors.toList());
        if (!values.isEmpty()) {
            return values;
        }
        if (group.getParentId() == null) {
            return null;
        }
        return KeycloakModelUtils.resolveAttribute(group.getParent(), name);
    }

    public static Collection<String> resolveAttribute(UserModel user, String name, boolean aggregateAttrs) {
        List<String> values = user.getAttributeStream(name).collect(Collectors.toList());
        HashSet<String> aggrValues = new HashSet<String>();
        if (!values.isEmpty()) {
            if (!aggregateAttrs) {
                return values;
            }
            aggrValues.addAll(values);
        }
        Stream<List> attributes = user.getGroupsStream().map(group -> KeycloakModelUtils.resolveAttribute(group, name)).filter(Objects::nonNull).filter(attr -> !attr.isEmpty());
        if (!aggregateAttrs) {
            Optional<List> first = attributes.findFirst();
            if (first.isPresent()) {
                return first.get();
            }
        } else {
            aggrValues.addAll(attributes.flatMap(Collection::stream).collect(Collectors.toSet()));
        }
        return aggrValues;
    }

    private static GroupModel findSubGroup(String[] segments, int index, GroupModel parent) {
        return parent.getSubGroupsStream().map(group -> {
            String[] pathSegments;
            String groupName = group.getName();
            if (groupName.equals((pathSegments = KeycloakModelUtils.formatPathSegments(segments, index, groupName))[index])) {
                GroupModel found;
                if (pathSegments.length == index + 1) {
                    return group;
                }
                if (index + 1 < pathSegments.length && (found = KeycloakModelUtils.findSubGroup(pathSegments, index + 1, group)) != null) {
                    return found;
                }
            }
            return null;
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static String[] formatPathSegments(String[] segments, int index, String groupName) {
        String[] nameSegments = groupName.split("/");
        if (nameSegments.length > 1 && segments.length >= nameSegments.length) {
            for (int i = 0; i < nameSegments.length; ++i) {
                if (nameSegments[i].equals(segments[index + i])) continue;
                return segments;
            }
            int numMergedIndexes = nameSegments.length - 1;
            String[] newPath = new String[segments.length - numMergedIndexes];
            for (int i = 0; i < newPath.length; ++i) {
                newPath[i] = i == index ? groupName : (i > index ? segments[i + numMergedIndexes] : segments[i]);
            }
            return newPath;
        }
        return segments;
    }

    public static GroupModel findGroupByPath(RealmModel realm, String path) {
        String[] split;
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((split = path.split("/")).length == 0) {
            return null;
        }
        return realm.getTopLevelGroupsStream().map(group -> {
            String[] pathSegments;
            String groupName = group.getName();
            if (groupName.equals((pathSegments = KeycloakModelUtils.formatPathSegments(split, 0, groupName))[0])) {
                GroupModel subGroup;
                if (pathSegments.length == 1) {
                    return group;
                }
                if (pathSegments.length > 1 && (subGroup = KeycloakModelUtils.findSubGroup(pathSegments, 1, group)) != null) {
                    return subGroup;
                }
            }
            return null;
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Deprecated
    public static Set<RoleModel> getClientScopeMappings(ClientModel client, ScopeContainerModel container) {
        return KeycloakModelUtils.getClientScopeMappingsStream(client, container).collect(Collectors.toSet());
    }

    public static Stream<RoleModel> getClientScopeMappingsStream(ClientModel client, ScopeContainerModel container) {
        return container.getScopeMappingsStream().filter(role -> role.getContainer() instanceof ClientModel && Objects.equals(client.getId(), role.getContainer().getId()));
    }

    public static RoleModel getRoleFromString(RealmModel realm, String roleName) {
        int scopeIndex = roleName.lastIndexOf(46);
        while (scopeIndex >= 0) {
            String appName = roleName.substring(0, scopeIndex);
            ClientModel client = realm.getClientByClientId(appName);
            if (client != null) {
                String role = roleName.substring(scopeIndex + 1);
                return client.getRole(role);
            }
            scopeIndex = roleName.lastIndexOf(46, scopeIndex - 1);
        }
        return realm.getRole(roleName);
    }

    public static String[] parseRole(String role) {
        int scopeIndex = role.lastIndexOf(46);
        if (scopeIndex > -1) {
            String appName = role.substring(0, scopeIndex);
            role = role.substring(scopeIndex + 1);
            String[] rtn = new String[]{appName, role};
            return rtn;
        }
        String[] rtn = new String[]{null, role};
        return rtn;
    }

    public static boolean isFlowUsed(RealmModel realm, AuthenticationFlowModel model) {
        AuthenticationFlowModel realmFlow = null;
        realmFlow = realm.getBrowserFlow();
        if (realmFlow != null && realmFlow.getId().equals(model.getId())) {
            return true;
        }
        realmFlow = realm.getRegistrationFlow();
        if (realmFlow != null && realmFlow.getId().equals(model.getId())) {
            return true;
        }
        realmFlow = realm.getClientAuthenticationFlow();
        if (realmFlow != null && realmFlow.getId().equals(model.getId())) {
            return true;
        }
        realmFlow = realm.getDirectGrantFlow();
        if (realmFlow != null && realmFlow.getId().equals(model.getId())) {
            return true;
        }
        realmFlow = realm.getResetCredentialsFlow();
        if (realmFlow != null && realmFlow.getId().equals(model.getId())) {
            return true;
        }
        realmFlow = realm.getDockerAuthenticationFlow();
        if (realmFlow != null && realmFlow.getId().equals(model.getId())) {
            return true;
        }
        return realm.getIdentityProvidersStream().anyMatch(idp -> Objects.equals(idp.getFirstBrokerLoginFlowId(), model.getId()) || Objects.equals(idp.getPostBrokerLoginFlowId(), model.getId()));
    }

    public static boolean isClientScopeUsed(RealmModel realm, ClientScopeModel clientScope) {
        return realm.getClientsStream().filter(c -> c.getClientScopes(true, false).containsKey(clientScope.getName()) || c.getClientScopes(false, false).containsKey(clientScope.getName())).findFirst().isPresent();
    }

    public static ClientScopeModel getClientScopeByName(RealmModel realm, String clientScopeName) {
        return realm.getClientScopesStream().filter(clientScope -> Objects.equals(clientScopeName, clientScope.getName())).findFirst().orElse(realm.getClientsStream().filter(c -> Objects.equals(clientScopeName, c.getClientId())).findFirst().orElse(null));
    }

    public static ClientScopeModel findClientScopeById(RealmModel realm, ClientModel client, String clientScopeId) {
        ClientScopeModel clientScope = realm.getClientScopeById(clientScopeId);
        if (clientScope == null) {
            clientScope = client.getDynamicClientScope(clientScopeId);
        }
        if (clientScope != null) {
            return clientScope;
        }
        return realm.getClientById(clientScopeId);
    }

    public static String convertClientScopeName(String previousName) {
        if (previousName.contains(" ")) {
            return previousName.replaceAll(" ", "_");
        }
        return previousName;
    }

    public static void setupAuthorizationServices(RealmModel realm) {
        for (String roleName : Constants.AUTHZ_DEFAULT_AUTHORIZATION_ROLES) {
            if (realm.getRole(roleName) != null) continue;
            RoleModel role = realm.addRole(roleName);
            role.setDescription("${role_" + roleName + "}");
            realm.addDefaultRole(roleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void suspendJtaTransaction(KeycloakSessionFactory factory, Runnable runnable) {
        JtaTransactionManagerLookup lookup = (JtaTransactionManagerLookup)factory.getProviderFactory(JtaTransactionManagerLookup.class);
        Transaction suspended = null;
        try {
            if (lookup != null && lookup.getTransactionManager() != null) {
                try {
                    suspended = lookup.getTransactionManager().suspend();
                }
                catch (SystemException e) {
                    throw new RuntimeException(e);
                }
            }
            runnable.run();
            if (suspended == null) return;
        }
        catch (Throwable throwable) {
            if (suspended == null) throw throwable;
            try {
                lookup.getTransactionManager().resume(suspended);
                throw throwable;
            }
            catch (InvalidTransactionException | SystemException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            lookup.getTransactionManager().resume(suspended);
            return;
        }
        catch (InvalidTransactionException | SystemException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getIdentityProviderDisplayName(KeycloakSession session, IdentityProviderModel provider) {
        String displayName = provider.getDisplayName();
        if (displayName != null && !displayName.isEmpty()) {
            return displayName;
        }
        SocialIdentityProviderFactory providerFactory = (SocialIdentityProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(SocialIdentityProvider.class, provider.getProviderId());
        if (providerFactory != null) {
            return providerFactory.getName();
        }
        return provider.getAlias();
    }
}

