/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.actiontoken;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.regex.Pattern;
import org.keycloak.common.util.Base64;
import org.keycloak.models.ActionTokenKeyModel;
import org.keycloak.representations.JsonWebToken;

public class DefaultActionTokenKey
extends JsonWebToken
implements ActionTokenKeyModel {
    public static final String ACTION_TOKEN_USER_ID = "ACTION_TOKEN_USER";
    public static final String JSON_FIELD_ACTION_VERIFICATION_NONCE = "nonce";
    @JsonProperty(value="nonce", required=true)
    private UUID actionVerificationNonce;
    private static final Pattern DOT = Pattern.compile("\\.");

    public DefaultActionTokenKey() {
    }

    public DefaultActionTokenKey(String userId, String actionId, int absoluteExpirationInSecs, UUID actionVerificationNonce) {
        this.subject = userId;
        this.type = actionId;
        this.exp = absoluteExpirationInSecs;
        this.actionVerificationNonce = actionVerificationNonce == null ? UUID.randomUUID() : actionVerificationNonce;
    }

    @JsonIgnore
    public String getUserId() {
        return this.getSubject();
    }

    @JsonIgnore
    public String getActionId() {
        return this.getType();
    }

    public UUID getActionVerificationNonce() {
        return this.actionVerificationNonce;
    }

    public static DefaultActionTokenKey from(String serializedKey) {
        String userId;
        if (serializedKey == null) {
            return null;
        }
        String[] parsed = DOT.split(serializedKey, 4);
        if (parsed.length != 4) {
            return null;
        }
        try {
            userId = new String(Base64.decode((String)parsed[0]), StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            userId = parsed[0];
        }
        return new DefaultActionTokenKey(userId, parsed[3], Integer.parseInt(parsed[1]), UUID.fromString(parsed[2]));
    }
}

