/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.login.freemarker.model;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.UriBuilder;
import org.keycloak.credential.CredentialModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.HmacOTP;
import org.keycloak.utils.TotpUtils;

public class TotpBean {
    private final RealmModel realm;
    private final String totpSecret;
    private final String totpSecretEncoded;
    private final String totpSecretQrCode;
    private final boolean enabled;
    private UriBuilder uriBuilder;
    private final List<CredentialModel> otpCredentials;

    public TotpBean(KeycloakSession session, RealmModel realm, UserModel user, UriBuilder uriBuilder) {
        this.realm = realm;
        this.uriBuilder = uriBuilder;
        this.enabled = session.userCredentialManager().isConfiguredFor(realm, user, "otp");
        this.otpCredentials = this.enabled ? session.userCredentialManager().getStoredCredentialsByTypeStream(realm, user, "otp").collect(Collectors.toList()) : Collections.EMPTY_LIST;
        this.totpSecret = HmacOTP.generateSecret((int)20);
        this.totpSecretEncoded = TotpUtils.encode(this.totpSecret);
        this.totpSecretQrCode = TotpUtils.qrCode(this.totpSecret, realm, user);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getTotpSecret() {
        return this.totpSecret;
    }

    public String getTotpSecretEncoded() {
        return this.totpSecretEncoded;
    }

    public String getTotpSecretQrCode() {
        return this.totpSecretQrCode;
    }

    public String getManualUrl() {
        return this.uriBuilder.replaceQueryParam("session_code", new Object[0]).replaceQueryParam("mode", new Object[]{"manual"}).build(new Object[0]).toString();
    }

    public String getQrUrl() {
        return this.uriBuilder.replaceQueryParam("session_code", new Object[0]).replaceQueryParam("mode", new Object[]{"qr"}).build(new Object[0]).toString();
    }

    public OTPPolicy getPolicy() {
        return this.realm.getOTPPolicy();
    }

    public List<CredentialModel> getOtpCredentials() {
        return this.otpCredentials;
    }
}

