/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import java.util.Collections;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientPolicyLogger;
import org.keycloak.services.clientpolicy.ClientPolicyVote;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProvider;

public class ClientAccessTypeCondition
implements ClientPolicyConditionProvider {
    private static final Logger logger = Logger.getLogger(ClientAccessTypeCondition.class);
    private final KeycloakSession session;
    private final ComponentModel componentModel;

    public ClientAccessTypeCondition(KeycloakSession session, ComponentModel componentModel) {
        this.session = session;
        this.componentModel = componentModel;
    }

    public String getName() {
        return this.componentModel.getName();
    }

    public String getProviderId() {
        return this.componentModel.getProviderId();
    }

    public ClientPolicyVote applyPolicy(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case AUTHORIZATION_REQUEST: 
            case TOKEN_REQUEST: 
            case TOKEN_REFRESH: 
            case TOKEN_REVOKE: 
            case TOKEN_INTROSPECT: 
            case USERINFO_REQUEST: 
            case LOGOUT_REQUEST: {
                if (this.isClientAccessTypeMatched()) {
                    return ClientPolicyVote.YES;
                }
                return ClientPolicyVote.NO;
            }
        }
        return ClientPolicyVote.ABSTAIN;
    }

    private String getClientAccessType() {
        ClientModel client = this.session.getContext().getClient();
        if (client == null) {
            return null;
        }
        if (client.isPublicClient()) {
            return "public";
        }
        if (client.isBearerOnly()) {
            return "bearer-only";
        }
        return "confidential";
    }

    private boolean isClientAccessTypeMatched() {
        boolean isMatched;
        String accessType = this.getClientAccessType();
        List expectedAccessTypes = (List)this.componentModel.getConfig().get((Object)"type");
        if (expectedAccessTypes == null) {
            expectedAccessTypes = Collections.emptyList();
        }
        if (logger.isTraceEnabled()) {
            ClientPolicyLogger.log(logger, "client access type = " + accessType);
            expectedAccessTypes.stream().forEach(i -> ClientPolicyLogger.log(logger, "client access type expected = " + i));
        }
        if (isMatched = expectedAccessTypes.stream().anyMatch(i -> i.equals(accessType))) {
            ClientPolicyLogger.log(logger, "client access type matched.");
        } else {
            ClientPolicyLogger.log(logger, "client access type unmatched.");
        }
        return isMatched;
    }
}

