/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleMapperModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.storage.ReadOnlyException;

public class ClientRoleMappingsResource {
    protected static final Logger logger = Logger.getLogger(ClientRoleMappingsResource.class);
    protected KeycloakSession session;
    protected RealmModel realm;
    protected AdminPermissionEvaluator auth;
    protected RoleMapperModel user;
    protected ClientModel client;
    protected AdminEventBuilder adminEvent;
    private UriInfo uriInfo;
    protected AdminPermissionEvaluator.RequirePermissionCheck managePermission;
    protected AdminPermissionEvaluator.RequirePermissionCheck viewPermission;

    public ClientRoleMappingsResource(UriInfo uriInfo, KeycloakSession session, RealmModel realm, AdminPermissionEvaluator auth, RoleMapperModel user, ClientModel client, AdminEventBuilder adminEvent, AdminPermissionEvaluator.RequirePermissionCheck manageCheck, AdminPermissionEvaluator.RequirePermissionCheck viewCheck) {
        this.uriInfo = uriInfo;
        this.session = session;
        this.realm = realm;
        this.auth = auth;
        this.user = user;
        this.client = client;
        this.managePermission = manageCheck;
        this.viewPermission = viewCheck;
        this.adminEvent = adminEvent.resource(ResourceType.CLIENT_ROLE_MAPPING);
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Stream<RoleRepresentation> getClientRoleMappings() {
        this.viewPermission.require();
        return this.user.getClientRoleMappingsStream(this.client).map(ModelToRepresentation::toBriefRepresentation);
    }

    @Path(value="composite")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Stream<RoleRepresentation> getCompositeClientRoleMappings(@QueryParam(value="briefRepresentation") @DefaultValue(value="true") boolean briefRepresentation) {
        this.viewPermission.require();
        Stream roles = this.client.getRolesStream();
        Function<RoleModel, RoleRepresentation> toBriefRepresentation = briefRepresentation ? ModelToRepresentation::toBriefRepresentation : ModelToRepresentation::toRepresentation;
        return roles.filter(arg_0 -> ((RoleMapperModel)this.user).hasRole(arg_0)).map(toBriefRepresentation);
    }

    @Path(value="available")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Stream<RoleRepresentation> getAvailableClientRoleMappings() {
        this.viewPermission.require();
        return this.client.getRolesStream().filter(this.auth.roles()::canMapRole).filter(((Predicate<RoleModel>)arg_0 -> ((RoleMapperModel)this.user).hasRole(arg_0)).negate()).map(ModelToRepresentation::toBriefRepresentation);
    }

    @POST
    @Consumes(value={"application/json"})
    public void addClientRoleMapping(List<RoleRepresentation> roles) {
        this.managePermission.require();
        try {
            for (RoleRepresentation role : roles) {
                RoleModel roleModel = this.client.getRole(role.getName());
                if (roleModel == null || !roleModel.getId().equals(role.getId())) {
                    throw new NotFoundException("Role not found");
                }
                this.auth.roles().requireMapRole(roleModel);
                this.user.grantRole(roleModel);
            }
        }
        catch (ModelException | ReadOnlyException me) {
            logger.warn((Object)me.getMessage(), me);
            throw new ErrorResponseException("invalid_request", "Could not add user role mappings!", Response.Status.BAD_REQUEST);
        }
        this.adminEvent.operation(OperationType.CREATE).resourcePath(this.uriInfo).representation(roles).success();
    }

    @DELETE
    @Consumes(value={"application/json"})
    public void deleteClientRoleMapping(List<RoleRepresentation> roles) {
        this.managePermission.require();
        if (roles == null) {
            roles = this.user.getClientRoleMappingsStream(this.client).peek(roleModel -> {
                this.auth.roles().requireMapRole((RoleModel)roleModel);
                this.user.deleteRoleMapping(roleModel);
            }).map(ModelToRepresentation::toBriefRepresentation).collect(Collectors.toList());
        } else {
            for (RoleRepresentation role : roles) {
                RoleModel roleModel2 = this.client.getRole(role.getName());
                if (roleModel2 == null || !roleModel2.getId().equals(role.getId())) {
                    throw new NotFoundException("Role not found");
                }
                this.auth.roles().requireMapRole(roleModel2);
                try {
                    this.user.deleteRoleMapping(roleModel2);
                }
                catch (ModelException | ReadOnlyException me) {
                    logger.warn((Object)me.getMessage(), me);
                    throw new ErrorResponseException("invalid_request", "Could not remove user role mappings!", Response.Status.BAD_REQUEST);
                }
            }
        }
        this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo).representation(roles).success();
    }
}

