/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleMapperModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.ManagementPermissionReference;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.RoleMapperResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.AdminPermissionManagement;
import org.keycloak.services.resources.admin.permissions.AdminPermissions;

public class GroupResource {
    private final RealmModel realm;
    private final KeycloakSession session;
    private final AdminPermissionEvaluator auth;
    private final AdminEventBuilder adminEvent;
    private final GroupModel group;

    public GroupResource(RealmModel realm, GroupModel group, KeycloakSession session, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.realm = realm;
        this.session = session;
        this.auth = auth;
        this.adminEvent = adminEvent.resource(ResourceType.GROUP);
        this.group = group;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public GroupRepresentation getGroup() {
        this.auth.groups().requireView(this.group);
        GroupRepresentation rep = ModelToRepresentation.toGroupHierarchy((GroupModel)this.group, (boolean)true);
        rep.setAccess(this.auth.groups().getAccess(this.group));
        return rep;
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response updateGroup(GroupRepresentation rep) {
        this.auth.groups().requireManage(this.group);
        boolean exists = this.siblings().filter(s -> !Objects.equals(s.getId(), this.group.getId())).anyMatch(s -> Objects.equals(s.getName(), rep.getName()));
        if (exists) {
            return ErrorResponse.exists("Sibling group named '" + rep.getName() + "' already exists.");
        }
        GroupResource.updateGroup(rep, this.group);
        this.adminEvent.operation(OperationType.UPDATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(rep).success();
        return Response.noContent().build();
    }

    private Stream<GroupModel> siblings() {
        if (this.group.getParentId() == null) {
            return this.realm.getTopLevelGroupsStream();
        }
        return this.group.getParent().getSubGroupsStream();
    }

    @DELETE
    public void deleteGroup() {
        this.auth.groups().requireManage(this.group);
        this.realm.removeGroup(this.group);
        this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @POST
    @Path(value="children")
    @NoCache
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response addChild(GroupRepresentation rep) {
        this.auth.groups().requireManage(this.group);
        Response.ResponseBuilder builder = Response.status((int)204);
        GroupModel child = null;
        if (rep.getId() != null) {
            child = this.realm.getGroupById(rep.getId());
            if (child == null) {
                throw new NotFoundException("Could not find child by id");
            }
            this.realm.moveGroup(child, this.group);
            this.adminEvent.operation(OperationType.UPDATE);
        } else {
            child = this.realm.createGroup(rep.getName(), this.group);
            GroupResource.updateGroup(rep, child);
            URI uri = this.session.getContext().getUri().getBaseUriBuilder().path((String)this.session.getContext().getUri().getMatchedURIs().get(2)).path(child.getId()).build(new Object[0]);
            builder.status(201).location(uri);
            rep.setId(child.getId());
            this.adminEvent.operation(OperationType.CREATE);
        }
        this.adminEvent.resourcePath((UriInfo)this.session.getContext().getUri()).representation(rep).success();
        GroupRepresentation childRep = ModelToRepresentation.toGroupHierarchy((GroupModel)child, (boolean)true);
        return builder.type(MediaType.APPLICATION_JSON_TYPE).entity((Object)childRep).build();
    }

    public static void updateGroup(GroupRepresentation rep, GroupModel model) {
        if (rep.getName() != null) {
            model.setName(rep.getName());
        }
        if (rep.getAttributes() != null) {
            HashSet attrsToRemove = new HashSet(model.getAttributes().keySet());
            attrsToRemove.removeAll(rep.getAttributes().keySet());
            for (Map.Entry entry : rep.getAttributes().entrySet()) {
                model.setAttribute((String)entry.getKey(), (List)entry.getValue());
            }
            for (String string : attrsToRemove) {
                model.removeAttribute(string);
            }
        }
    }

    @Path(value="role-mappings")
    public RoleMapperResource getRoleMappings() {
        AdminPermissionEvaluator.RequirePermissionCheck manageCheck = () -> this.auth.groups().requireManage(this.group);
        AdminPermissionEvaluator.RequirePermissionCheck viewCheck = () -> this.auth.groups().requireView(this.group);
        RoleMapperResource resource = new RoleMapperResource(this.realm, this.auth, (RoleMapperModel)this.group, this.adminEvent, manageCheck, viewCheck);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @GET
    @NoCache
    @Path(value="members")
    @Produces(value={"application/json"})
    public Stream<UserRepresentation> getMembers(@QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults, @QueryParam(value="briefRepresentation") Boolean briefRepresentation) {
        this.auth.groups().requireViewMembers(this.group);
        firstResult = firstResult != null ? firstResult : 0;
        maxResults = maxResults != null ? maxResults : 100;
        boolean briefRepresentationB = briefRepresentation != null && briefRepresentation != false;
        return this.session.users().getGroupMembersStream(this.realm, this.group, firstResult, maxResults).map(user -> briefRepresentationB ? ModelToRepresentation.toBriefRepresentation((UserModel)user) : ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (RealmModel)this.realm, (UserModel)user));
    }

    @Path(value="management/permissions")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public ManagementPermissionReference getManagementPermissions() {
        this.auth.groups().requireView(this.group);
        AdminPermissionManagement permissions = AdminPermissions.management(this.session, this.realm);
        if (!permissions.groups().isPermissionsEnabled(this.group)) {
            return new ManagementPermissionReference();
        }
        return GroupResource.toMgmtRef(this.group, permissions);
    }

    public static ManagementPermissionReference toMgmtRef(GroupModel group, AdminPermissionManagement permissions) {
        ManagementPermissionReference ref = new ManagementPermissionReference();
        ref.setEnabled(true);
        ref.setResource(permissions.groups().resource(group).getId());
        ref.setScopePermissions(permissions.groups().getPermissions(group));
        return ref;
    }

    @Path(value="management/permissions")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @NoCache
    public ManagementPermissionReference setManagementPermissionsEnabled(ManagementPermissionReference ref) {
        this.auth.groups().requireManage(this.group);
        AdminPermissionManagement permissions = AdminPermissions.management(this.session, this.realm);
        permissions.groups().setPermissionsEnabled(this.group, ref.isEnabled());
        if (ref.isEnabled()) {
            return GroupResource.toMgmtRef(this.group, permissions);
        }
        return new ManagementPermissionReference();
    }
}

