/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.openshift;

import com.openshift.restclient.IClient;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.route.IRoute;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.storage.client.AbstractReadOnlyClientScopeAdapter;
import org.keycloak.storage.client.AbstractReadOnlyClientStorageAdapter;
import org.keycloak.storage.client.ClientStorageProviderModel;
import org.keycloak.util.JsonSerialization;

public final class OpenshiftSAClientAdapter
extends AbstractReadOnlyClientStorageAdapter {
    private static final String ANNOTATION_OAUTH_REDIRECT_URI = "serviceaccounts.openshift.io/oauth-redirecturi";
    private static final String ANNOTATION_OAUTH_REDIRECT_REFERENCE = "serviceaccounts.openshift.io/oauth-redirectreference";
    private static final Pattern ROLE_SCOPE_PATTERN = Pattern.compile("role:([^:]+):([^:!]+)(:[!])?");
    private static final Set<String> OPTIONAL_SCOPES = Stream.of("user:info", "user:check-access").collect(Collectors.toSet());
    private final IResource resource;
    private final String clientId;
    private final IClient client;
    private final ClientRepresentation defaultConfig = new ClientRepresentation();

    private static Set<ProtocolMapperModel> createDefaultProtocolMappers() {
        HashSet<ProtocolMapperModel> mappers = new HashSet<ProtocolMapperModel>();
        ProtocolMapperModel mapper = OIDCAttributeMapperHelper.createClaimMapper("username", "username", "preferred_username", "string", true, true, "oidc-usermodel-property-mapper");
        mapper.setId(KeycloakModelUtils.generateId());
        mappers.add(mapper);
        return mappers;
    }

    public OpenshiftSAClientAdapter(String clientId, IResource resource, IClient client, KeycloakSession session, RealmModel realm, ClientStorageProviderModel component) {
        super(session, realm, component);
        this.resource = resource;
        this.clientId = clientId;
        this.client = client;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getName() {
        return this.resource.getName();
    }

    public String getDescription() {
        return this.getConfigOrDefault(() -> this.defaultConfig.getDescription(), arg_0 -> ((ClientRepresentation)this.defaultConfig).setDescription(arg_0), this.resource.getKind() + " " + this.resource.getName() + " from namespace " + this.resource.getNamespace().getName());
    }

    public boolean isEnabled() {
        return this.getConfigOrDefault(() -> this.defaultConfig.isEnabled(), arg_0 -> ((ClientRepresentation)this.defaultConfig).setEnabled(arg_0), true);
    }

    public boolean isAlwaysDisplayInConsole() {
        return this.getConfigOrDefault(() -> this.defaultConfig.isAlwaysDisplayInConsole(), arg_0 -> ((ClientRepresentation)this.defaultConfig).setAlwaysDisplayInConsole(arg_0), false);
    }

    public Set<String> getWebOrigins() {
        return new HashSet<String>(this.getConfigOrDefault(() -> this.defaultConfig.getWebOrigins(), arg_0 -> ((ClientRepresentation)this.defaultConfig).setWebOrigins(arg_0), Collections.emptyList()));
    }

    public Set<String> getRedirectUris() {
        return new HashSet<String>((Collection)((Object)this.getConfigOrDefault((Supplier)() -> this.defaultConfig.getRedirectUris(), (Consumer)uris -> this.defaultConfig.setRedirectUris(uris), (Object)() -> this.resource.getAnnotations().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(ANNOTATION_OAUTH_REDIRECT_URI) || ((String)entry.getKey()).startsWith(ANNOTATION_OAUTH_REDIRECT_REFERENCE)).map(entry -> {
            Map values;
            if (((String)entry.getKey()).startsWith(ANNOTATION_OAUTH_REDIRECT_URI)) {
                return (String)entry.getValue();
            }
            try {
                values = (Map)JsonSerialization.readValue((String)((String)entry.getValue()), Map.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to parse annotation [serviceaccounts.openshift.io/oauth-redirectreference]", e);
            }
            Map reference = (Map)values.get("reference");
            String kind = (String)reference.get("kind");
            if (!"Route".equals(kind)) {
                throw new IllegalArgumentException("Only route references are supported for serviceaccounts.openshift.io/oauth-redirectreference");
            }
            String name = (String)reference.get("name");
            IRoute route = (IRoute)this.client.get(kind, name, this.resource.getNamespace().getName());
            StringBuilder url = new StringBuilder(route.getURL());
            if (url.charAt(url.length() - 1) != '/') {
                url.append('/');
            }
            return url.append('*').toString();
        }).collect(Collectors.toList()))));
    }

    public String getManagementUrl() {
        return null;
    }

    public String getRootUrl() {
        return null;
    }

    public String getBaseUrl() {
        return null;
    }

    public boolean isBearerOnly() {
        return false;
    }

    public int getNodeReRegistrationTimeout() {
        return 0;
    }

    public String getClientAuthenticatorType() {
        return null;
    }

    public boolean validateSecret(String secret) {
        return false;
    }

    public String getSecret() {
        return null;
    }

    public String getRegistrationToken() {
        return null;
    }

    public String getProtocol() {
        return "openid-connect";
    }

    public String getAttribute(String name) {
        return null;
    }

    public Map<String, String> getAttributes() {
        return Collections.emptyMap();
    }

    public String getAuthenticationFlowBindingOverride(String binding) {
        return null;
    }

    public Map<String, String> getAuthenticationFlowBindingOverrides() {
        return Collections.emptyMap();
    }

    public boolean isFrontchannelLogout() {
        return false;
    }

    public boolean isFullScopeAllowed() {
        return false;
    }

    public boolean isPublicClient() {
        return true;
    }

    public boolean isConsentRequired() {
        return this.component.get("user.consent.require", true);
    }

    public boolean isDisplayOnConsentScreen() {
        return false;
    }

    public boolean isStandardFlowEnabled() {
        return true;
    }

    public boolean isImplicitFlowEnabled() {
        return false;
    }

    public boolean isDirectAccessGrantsEnabled() {
        return false;
    }

    public boolean isServiceAccountsEnabled() {
        return false;
    }

    public Map<String, ClientScopeModel> getClientScopes(boolean defaultScope, boolean filterByProtocol) {
        if (defaultScope) {
            return Collections.emptyMap();
        }
        HashMap<String, ClientScopeModel> scopes = new HashMap<String, ClientScopeModel>();
        for (String scope : OPTIONAL_SCOPES) {
            scopes.put(scope, this.createClientScope(scope));
        }
        return scopes;
    }

    public ClientScopeModel getDynamicClientScope(String scope) {
        if (OPTIONAL_SCOPES.contains(scope)) {
            return this.createClientScope(scope);
        }
        Matcher matcher = ROLE_SCOPE_PATTERN.matcher(scope);
        if (matcher.matches()) {
            String namespace = matcher.group(2);
            if (this.resource.getNamespace().getName().equals(namespace)) {
                return this.createClientScope(scope);
            }
        }
        return null;
    }

    public int getNotBefore() {
        return 0;
    }

    public Stream<ProtocolMapperModel> getProtocolMappersStream() {
        List mappers = this.defaultConfig.getProtocolMappers();
        if (mappers == null) {
            Set<ProtocolMapperModel> defaultProtocolMappers = OpenshiftSAClientAdapter.createDefaultProtocolMappers();
            this.defaultConfig.setProtocolMappers(defaultProtocolMappers.stream().map(ModelToRepresentation::toRepresentation).collect(Collectors.toList()));
            return defaultProtocolMappers.stream();
        }
        return mappers.stream().map(RepresentationToModel::toModel);
    }

    public ProtocolMapperModel getProtocolMapperById(String id) {
        return this.getProtocolMappersStream().filter(protocolMapperModel -> Objects.equals(id, protocolMapperModel.getId())).findAny().orElse(null);
    }

    public ProtocolMapperModel getProtocolMapperByName(String protocol, String name) {
        return this.getProtocolMappersStream().filter(protocolMapperModel -> Objects.equals(name, protocolMapperModel.getName())).findAny().orElse(null);
    }

    public Stream<RoleModel> getScopeMappingsStream() {
        return Stream.empty();
    }

    public Stream<RoleModel> getRealmScopeMappingsStream() {
        return Stream.empty();
    }

    public boolean hasScope(RoleModel role) {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ClientModel)) {
            return false;
        }
        ClientModel that = (ClientModel)o;
        return that.getId().equals(this.getId());
    }

    private <V> V getConfigOrDefault(Supplier<V> valueSupplier, Consumer<V> valueConsumer, Supplier<V> defaultValue) {
        V value = valueSupplier.get();
        if (value != null) {
            return value;
        }
        value = defaultValue.get();
        if (valueConsumer != null) {
            valueConsumer.accept(value);
        }
        return value;
    }

    private <V> V getConfigOrDefault(Supplier<V> valueSupplier, Consumer<V> valueConsumer, V defaultValue) {
        return (V)this.getConfigOrDefault(valueSupplier, valueConsumer, (V)((Supplier<Object>)() -> defaultValue));
    }

    private ClientScopeModel createClientScope(final String scope) {
        ClientScopeModel managedScope = this.realm.getClientScopesStream().filter(scopeModel -> Objects.equals(scopeModel.getName(), scope)).findAny().orElse(null);
        if (managedScope != null) {
            return managedScope;
        }
        final HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("display.on.consent.screen", Boolean.valueOf(this.isConsentRequired()).toString());
        if (this.component.get("user.consent.scope.consent.text", Boolean.TRUE.booleanValue())) {
            StringBuilder consentText = new StringBuilder("${openshift.scope.");
            if (scope.indexOf(58) != -1) {
                consentText.append(scope.replaceFirst(":", "_"));
            }
            attributes.put("consent.screen.text", consentText.append("}").toString());
        } else {
            attributes.put("consent.screen.text", scope);
        }
        return new AbstractReadOnlyClientScopeAdapter(){

            public String getId() {
                return scope;
            }

            public String getName() {
                return scope;
            }

            public RealmModel getRealm() {
                return OpenshiftSAClientAdapter.this.realm;
            }

            public String getDescription() {
                return scope;
            }

            public String getProtocol() {
                return "openid-connect";
            }

            public String getAttribute(String name) {
                return (String)attributes.get(name);
            }

            public Map<String, String> getAttributes() {
                return attributes;
            }

            public Stream<ProtocolMapperModel> getProtocolMappersStream() {
                return OpenshiftSAClientAdapter.createDefaultProtocolMappers().stream();
            }

            public ProtocolMapperModel getProtocolMapperById(String id) {
                return null;
            }

            public ProtocolMapperModel getProtocolMapperByName(String protocol, String name) {
                return null;
            }

            public Stream<RoleModel> getScopeMappingsStream() {
                return Stream.empty();
            }

            public Stream<RoleModel> getRealmScopeMappingsStream() {
                return Stream.empty();
            }

            public boolean hasScope(RoleModel role) {
                return false;
            }
        };
    }
}

