/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile.validation;

import java.util.List;
import java.util.function.BiFunction;
import org.jboss.logging.Logger;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.validation.Validation;
import org.keycloak.userprofile.UserProfileContext;

public class StaticValidators {
    private static final Logger logger = Logger.getLogger(StaticValidators.class);

    public static BiFunction<String, UserProfileContext, Boolean> isBlank() {
        return (value, context) -> value == null || !Validation.isBlank(value);
    }

    public static BiFunction<String, UserProfileContext, Boolean> isEmailValid() {
        return (value, context) -> Validation.isBlank(value) || Validation.isEmailValid(value);
    }

    public static BiFunction<String, UserProfileContext, Boolean> userNameExists(KeycloakSession session) {
        return (value, context) -> {
            if (Validation.isBlank(value)) {
                return true;
            }
            return context.getCurrentProfile() == null || value.equals(context.getCurrentProfile().getAttributes().getFirstAttribute("username")) || session.users().getUserByUsername(value, session.getContext().getRealm()) == null;
        };
    }

    public static BiFunction<String, UserProfileContext, Boolean> isUserMutable(RealmModel realm) {
        return (value, context) -> {
            if (Validation.isBlank(value)) {
                return true;
            }
            return realm.isEditUsernameAllowed() || context.getCurrentProfile() == null || value.equals(context.getCurrentProfile().getAttributes().getFirstAttribute("username"));
        };
    }

    public static BiFunction<String, UserProfileContext, Boolean> checkUsernameExists(boolean externalCondition) {
        return (value, context) -> !externalCondition || !Validation.isBlank(value);
    }

    public static BiFunction<String, UserProfileContext, Boolean> doesEmailExistAsUsername(KeycloakSession session) {
        return (value, context) -> {
            if (Validation.isBlank(value)) {
                return true;
            }
            RealmModel realm = session.getContext().getRealm();
            if (!realm.isDuplicateEmailsAllowed()) {
                UserModel userByEmail = session.users().getUserByEmail(value, realm);
                return !realm.isRegistrationEmailAsUsername() || userByEmail == null || context.getCurrentProfile() == null || userByEmail.getId().equals(context.getCurrentProfile().getId());
            }
            return true;
        };
    }

    public static BiFunction<String, UserProfileContext, Boolean> isEmailDuplicated(KeycloakSession session) {
        return (value, context) -> {
            if (Validation.isBlank(value)) {
                return true;
            }
            RealmModel realm = session.getContext().getRealm();
            if (!realm.isDuplicateEmailsAllowed()) {
                UserModel userByEmail = session.users().getUserByEmail(value, realm);
                return userByEmail == null || context.getCurrentProfile() != null && userByEmail.getId().equals(context.getCurrentProfile().getId());
            }
            return true;
        };
    }

    public static BiFunction<String, UserProfileContext, Boolean> doesEmailExist(KeycloakSession session) {
        return (value, context) -> value == null || session.getContext().getRealm().isDuplicateEmailsAllowed() || session.users().getUserByEmail(value, session.getContext().getRealm()) == null;
    }

    public static BiFunction<List<String>, UserProfileContext, Boolean> isAttributeUnchanged(String attributeName) {
        return (newAttrValues, context) -> {
            List existingAttrValues = context.getCurrentProfile() == null ? null : context.getCurrentProfile().getAttributes().getAttribute(attributeName);
            boolean result = ObjectUtil.isEqualOrBothNull((Object)newAttrValues, (Object)existingAttrValues);
            if (!result) {
                logger.warnf("Attempt to edit denied attribute '%s' of user '%s'", (Object)attributeName, (Object)(context.getCurrentProfile() == null ? "new user" : context.getCurrentProfile().getAttributes().getFirstAttribute("username")));
            }
            return result;
        };
    }
}

