/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.validation.AttributeValidationResult;
import org.keycloak.userprofile.validation.AttributeValidator;
import org.keycloak.userprofile.validation.ValidationResult;
import org.keycloak.userprofile.validation.Validator;

public class ValidationChain {
    List<AttributeValidator> attributeValidators;

    public ValidationChain(List<AttributeValidator> attributeValidators) {
        this.attributeValidators = attributeValidators;
    }

    public List<AttributeValidationResult> validate(UserProfileContext updateContext, UserProfile updatedProfile) {
        ArrayList<AttributeValidationResult> overallResults = new ArrayList<AttributeValidationResult>();
        for (AttributeValidator attribute : this.attributeValidators) {
            ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
            String attributeKey = attribute.attributeKey;
            List attributeValues = updatedProfile.getAttributes().getAttribute(attributeKey);
            List existingAttrValues = updateContext.getCurrentProfile() == null ? null : updateContext.getCurrentProfile().getAttributes().getAttribute(attributeKey);
            boolean attributeChanged = !Objects.equals(attributeValues, existingAttrValues);
            for (Validator validator : attribute.validators) {
                validationResults.add(new ValidationResult(validator.function.apply(attributeValues, updateContext).booleanValue(), validator.errorType));
            }
            overallResults.add(new AttributeValidationResult(attributeKey, attributeChanged, validationResults));
        }
        return overallResults;
    }
}

