/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.impl.table;

import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.impl.table.AbstractTableManager;
import org.infinispan.persistence.jdbc.impl.table.DbMetaData;
import org.infinispan.persistence.jdbc.logging.Log;
import org.infinispan.util.logging.LogFactory;

class SQLiteTableManager
extends AbstractTableManager {
    private static final Log log = (Log)LogFactory.getLog(SQLiteTableManager.class, Log.class);

    SQLiteTableManager(ConnectionFactory connectionFactory, TableManipulationConfiguration config, DbMetaData metaData, String cacheName) {
        super(connectionFactory, config, metaData, cacheName, log);
    }

    @Override
    public boolean isUpsertSupported() {
        return super.isUpsertSupported() && (this.metaData.getMajorVersion() >= 4 || this.metaData.getMajorVersion() >= 3 && this.metaData.getMinorVersion() >= 9);
    }

    @Override
    public String initUpsertRowSql() {
        if (this.metaData.isSegmentedDisabled()) {
            return String.format("INSERT OR REPLACE INTO %s (%s, %s, %s) VALUES (?, ?, ?)", this.tableName, this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName());
        }
        return String.format("INSERT OR REPLACE INTO %s (%s, %s, %s, %s) VALUES (?, ?, ?, ?)", this.tableName, this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName(), this.config.segmentColumnName());
    }
}

