/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.util;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.callback.SocketAddressCallback;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.HttpServerRequest;

public final class SocketAddressCallbackServerMechanismFactory
implements HttpServerAuthenticationMechanismFactory {
    private final HttpServerAuthenticationMechanismFactory delegate;

    public SocketAddressCallbackServerMechanismFactory(HttpServerAuthenticationMechanismFactory delegate) {
        this.delegate = (HttpServerAuthenticationMechanismFactory)Assert.checkNotNullParam((String)"delegate", (Object)delegate);
    }

    public String[] getMechanismNames(Map<String, ?> properties) {
        return this.delegate.getMechanismNames(properties);
    }

    public HttpServerAuthenticationMechanism createAuthenticationMechanism(String mechanismName, Map<String, ?> properties, final CallbackHandler callbackHandler) throws HttpAuthenticationException {
        final HttpServerAuthenticationMechanism mechanism = this.delegate.createAuthenticationMechanism(mechanismName, properties, callbackHandler);
        return mechanism != null ? new HttpServerAuthenticationMechanism(){

            public String getMechanismName() {
                return mechanism.getMechanismName();
            }

            public void evaluateRequest(HttpServerRequest request) throws HttpAuthenticationException {
                InetSocketAddress peerAddress = request.getSourceAddress();
                if (peerAddress != null) {
                    SocketAddressCallback peerCallback = new SocketAddressCallback((SocketAddress)peerAddress, SocketAddressCallback.Kind.PEER);
                    try {
                        callbackHandler.handle(new Callback[]{peerCallback});
                    }
                    catch (IOException | UnsupportedCallbackException e) {
                        throw new HttpAuthenticationException((Throwable)e);
                    }
                }
                mechanism.evaluateRequest(request);
            }
        } : null;
    }
}

