/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics;

import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;

public abstract class MetricRegistry {
    public static String name(String name, String ... names) {
        StringBuilder builder = new StringBuilder();
        MetricRegistry.append(builder, name);
        if (names != null) {
            for (String s : names) {
                MetricRegistry.append(builder, s);
            }
        }
        return builder.toString();
    }

    private static void append(StringBuilder builder, String part) {
        if (part != null && !part.isEmpty()) {
            if (builder.length() > 0) {
                builder.append('.');
            }
            builder.append(part);
        }
    }

    public static String name(Class<?> klass, String ... names) {
        return MetricRegistry.name(klass.getName(), names);
    }

    public abstract <T extends Metric> T register(String var1, T var2) throws IllegalArgumentException;

    public abstract <T extends Metric> T register(Metadata var1, T var2) throws IllegalArgumentException;

    public abstract <T extends Metric> T register(Metadata var1, T var2, Tag ... var3) throws IllegalArgumentException;

    public abstract Counter counter(String var1);

    public abstract Counter counter(String var1, Tag ... var2);

    public abstract Counter counter(Metadata var1);

    public abstract Counter counter(Metadata var1, Tag ... var2);

    public abstract ConcurrentGauge concurrentGauge(String var1);

    public abstract ConcurrentGauge concurrentGauge(String var1, Tag ... var2);

    public abstract ConcurrentGauge concurrentGauge(Metadata var1);

    public abstract ConcurrentGauge concurrentGauge(Metadata var1, Tag ... var2);

    public abstract Histogram histogram(String var1);

    public abstract Histogram histogram(String var1, Tag ... var2);

    public abstract Histogram histogram(Metadata var1);

    public abstract Histogram histogram(Metadata var1, Tag ... var2);

    public abstract Meter meter(String var1);

    public abstract Meter meter(String var1, Tag ... var2);

    public abstract Meter meter(Metadata var1);

    public abstract Meter meter(Metadata var1, Tag ... var2);

    public abstract Timer timer(String var1);

    public abstract Timer timer(String var1, Tag ... var2);

    public abstract Timer timer(Metadata var1);

    public abstract Timer timer(Metadata var1, Tag ... var2);

    public abstract SimpleTimer simpleTimer(String var1);

    public abstract SimpleTimer simpleTimer(String var1, Tag ... var2);

    public abstract SimpleTimer simpleTimer(Metadata var1);

    public abstract SimpleTimer simpleTimer(Metadata var1, Tag ... var2);

    public abstract boolean remove(String var1);

    public abstract boolean remove(MetricID var1);

    public abstract void removeMatching(MetricFilter var1);

    public abstract SortedSet<String> getNames();

    public abstract SortedSet<MetricID> getMetricIDs();

    public abstract SortedMap<MetricID, Gauge> getGauges();

    public abstract SortedMap<MetricID, Gauge> getGauges(MetricFilter var1);

    public abstract SortedMap<MetricID, Counter> getCounters();

    public abstract SortedMap<MetricID, Counter> getCounters(MetricFilter var1);

    public abstract SortedMap<MetricID, ConcurrentGauge> getConcurrentGauges();

    public abstract SortedMap<MetricID, ConcurrentGauge> getConcurrentGauges(MetricFilter var1);

    public abstract SortedMap<MetricID, Histogram> getHistograms();

    public abstract SortedMap<MetricID, Histogram> getHistograms(MetricFilter var1);

    public abstract SortedMap<MetricID, Meter> getMeters();

    public abstract SortedMap<MetricID, Meter> getMeters(MetricFilter var1);

    public abstract SortedMap<MetricID, Timer> getTimers();

    public abstract SortedMap<MetricID, Timer> getTimers(MetricFilter var1);

    public abstract SortedMap<MetricID, SimpleTimer> getSimpleTimers();

    public abstract SortedMap<MetricID, SimpleTimer> getSimpleTimers(MetricFilter var1);

    public abstract Map<MetricID, Metric> getMetrics();

    public abstract Map<String, Metadata> getMetadata();

    public static enum Type {
        APPLICATION("application"),
        BASE("base"),
        VENDOR("vendor");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

