/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.session;

import java.time.Duration;
import java.time.Instant;

public interface ImmutableSessionMetaData {
    default public boolean isNew() {
        return this.getCreationTime().equals(this.getLastAccessedTime());
    }

    default public boolean isExpired() {
        Duration maxInactiveInterval = this.getMaxInactiveInterval();
        return !maxInactiveInterval.isZero() ? this.getLastAccessedTime().plus(maxInactiveInterval).isBefore(Instant.now()) : false;
    }

    public Instant getCreationTime();

    public Instant getLastAccessedTime();

    public Duration getMaxInactiveInterval();
}

