/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RoleModel;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientPolicyLogger;
import org.keycloak.services.clientpolicy.ClientPolicyVote;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProvider;

public class ClientRolesCondition
implements ClientPolicyConditionProvider {
    private static final Logger logger = Logger.getLogger(ClientRolesCondition.class);
    private final KeycloakSession session;
    private final ComponentModel componentModel;

    public ClientRolesCondition(KeycloakSession session, ComponentModel componentModel) {
        this.session = session;
        this.componentModel = componentModel;
    }

    public ClientPolicyVote applyPolicy(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case AUTHORIZATION_REQUEST: 
            case TOKEN_REQUEST: 
            case TOKEN_REFRESH: 
            case TOKEN_REVOKE: 
            case TOKEN_INTROSPECT: 
            case USERINFO_REQUEST: 
            case LOGOUT_REQUEST: {
                if (this.isRolesMatched(this.session.getContext().getClient())) {
                    return ClientPolicyVote.YES;
                }
                return ClientPolicyVote.NO;
            }
        }
        return ClientPolicyVote.ABSTAIN;
    }

    private boolean isRolesMatched(ClientModel client) {
        boolean isMatched;
        if (client == null) {
            return false;
        }
        Set<String> rolesForMatching = this.getRolesForMatching();
        if (rolesForMatching == null) {
            return false;
        }
        Set clientRoles = client.getRolesStream().map(RoleModel::getName).collect(Collectors.toSet());
        if (logger.isTraceEnabled()) {
            clientRoles.stream().forEach(i -> ClientPolicyLogger.log(logger, "client role assigned = " + i));
            rolesForMatching.stream().forEach(i -> ClientPolicyLogger.log(logger, "client role for matching = " + i));
        }
        if (isMatched = rolesForMatching.removeAll(clientRoles)) {
            ClientPolicyLogger.log(logger, "role matched.");
        } else {
            ClientPolicyLogger.log(logger, "role unmatched.");
        }
        return isMatched;
    }

    private Set<String> getRolesForMatching() {
        if (this.componentModel.getConfig() == null) {
            return null;
        }
        List roles = (List)this.componentModel.getConfig().get((Object)"roles");
        if (roles == null) {
            return null;
        }
        return new HashSet<String>(roles);
    }

    public String getName() {
        return this.componentModel.getName();
    }

    public String getProviderId() {
        return this.componentModel.getProviderId();
    }
}

