/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.security.auth.login.LoginException;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.SubjectIdentity;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.KeytabService;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

class KeytabIdentityFactoryService
implements Service {
    private static final String SERVICE_SUFFIX = "keytab_factory";
    private final Consumer<KeytabIdentityFactoryService> serviceConsumer;
    private final Set<Supplier<KeytabService>> keytabServices = Collections.synchronizedSet(new HashSet());
    private volatile KeytabService defaultService = null;
    private volatile Map<String, KeytabService> hostServiceMap = null;

    KeytabIdentityFactoryService(Consumer<KeytabIdentityFactoryService> serviceConsumer) {
        this.serviceConsumer = serviceConsumer;
    }

    public void start(StartContext context) throws StartException {
        Set<Supplier<KeytabService>> services = this.keytabServices;
        this.hostServiceMap = new HashMap<String, KeytabService>(services.size());
        for (Supplier<KeytabService> current : services) {
            for (String currentHost : current.get().getForHosts()) {
                String hostKey;
                if ("*".equals(currentHost)) {
                    if (this.defaultService != null) continue;
                    this.defaultService = current.get();
                    continue;
                }
                if (currentHost == null) continue;
                int idx = currentHost.indexOf("/");
                String string = hostKey = idx > -1 ? currentHost.substring(0, idx) + "/" + currentHost.substring(idx + 1).toLowerCase(Locale.ENGLISH) : currentHost.toLowerCase(Locale.ENGLISH);
                if (this.hostServiceMap.containsKey(hostKey)) continue;
                this.hostServiceMap.put(hostKey, current.get());
            }
        }
        for (Supplier<KeytabService> current : services) {
            String principalKey;
            int end;
            int start;
            String currentHost;
            String principal = current.get().getPrincipal();
            currentHost = principal.substring((start = principal.indexOf(47)) > -1 ? start + 1 : 0, (end = principal.indexOf(64)) > -1 ? end : principal.length() - 1);
            if (!this.hostServiceMap.containsKey(currentHost.toLowerCase(Locale.ENGLISH))) {
                this.hostServiceMap.put(currentHost.toLowerCase(Locale.ENGLISH), current.get());
            }
            if ((principal = principal.substring(0, end > -1 ? end : principal.length() - 1)).equals(currentHost) || this.hostServiceMap.containsKey(principalKey = principal.substring(0, start) + "/" + currentHost.toLowerCase(Locale.ENGLISH))) continue;
            this.hostServiceMap.put(principalKey, current.get());
        }
        if (this.serviceConsumer != null) {
            this.serviceConsumer.accept(this);
        }
    }

    public void stop(StopContext context) {
        if (this.serviceConsumer != null) {
            this.serviceConsumer.accept(null);
        }
        this.defaultService = null;
        this.hostServiceMap = null;
    }

    void addKeytabSupplier(Supplier<KeytabService> supplier) {
        this.keytabServices.add(supplier);
    }

    SubjectIdentity getSubjectIdentity(String protocol, String forHost) {
        KeytabService selectedService = null;
        String hostName = forHost == null ? null : forHost.toLowerCase(Locale.ENGLISH);
        String name = protocol + "/" + hostName;
        selectedService = this.hostServiceMap.get(name);
        if (selectedService == null) {
            DomainManagementLogger.SECURITY_LOGGER.tracef("No mapping for name '%s' to KeytabService, attempting to use host only match.", name);
            selectedService = this.hostServiceMap.get(hostName);
            if (selectedService == null) {
                DomainManagementLogger.SECURITY_LOGGER.tracef("No mapping for host '%s' to KeytabService, attempting to use default.", forHost);
                selectedService = this.defaultService;
            }
        }
        if (selectedService != null) {
            if (DomainManagementLogger.SECURITY_LOGGER.isTraceEnabled()) {
                DomainManagementLogger.SECURITY_LOGGER.tracef("Selected KeytabService with principal '%s' for host '%s'", selectedService.getPrincipal(), forHost);
            }
            try {
                return selectedService.createSubjectIdentity(false);
            }
            catch (LoginException e) {
                DomainManagementLogger.SECURITY_LOGGER.keytabLoginFailed(selectedService.getPrincipal(), forHost, e);
            }
        } else {
            DomainManagementLogger.SECURITY_LOGGER.tracef("No KeytabService available for host '%s' unable to return SubjectIdentity.", forHost);
        }
        return null;
    }

    public static final class ServiceUtil {
        private ServiceUtil() {
        }

        public static ServiceName createServiceName(String realmName) {
            return SecurityRealm.ServiceUtil.createServiceName(realmName).append(new String[]{KeytabIdentityFactoryService.SERVICE_SUFFIX});
        }

        public static Supplier<KeytabIdentityFactoryService> requires(ServiceBuilder<?> sb, String realmName) {
            return sb.requires(ServiceUtil.createServiceName(realmName));
        }
    }
}

