/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.common.reflection;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class SecurityActions {
    SecurityActions() {
    }

    static ClassLoader getTCCL() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        return Thread.currentThread().getContextClassLoader();
    }

    static ClassLoader getClassLoader(final Class<?> clazz) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return clazz.getClassLoader();
                }
            });
        }
        return clazz.getClassLoader();
    }

    static <T> Constructor<T> getDeclaredConstructor(final Class<T> clazz) throws NoSuchMethodException {
        if (System.getSecurityManager() != null) {
            try {
                return (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor<T>>(){

                    @Override
                    public Constructor<T> run() throws Exception {
                        return clazz.getDeclaredConstructor(new Class[0]);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw (NoSuchMethodException)pae.getException();
            }
        }
        return clazz.getDeclaredConstructor(new Class[0]);
    }
}

