/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session;

import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.agent.common.AgentForwardSupport;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.session.AbstractClientSession;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientSessionHolder;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.helpers.AbstractConnectionService;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.server.x11.X11ForwardSupport;

public class ClientConnectionService
extends AbstractConnectionService
implements ClientSessionHolder {
    protected final String heartbeatRequest = this.getStringProperty("heartbeat-request", "keepalive@sshd.apache.org");
    protected final long heartbeatInterval = this.getLongProperty("heartbeat-interval", 0L);
    protected final long heartbeatReplyMaxWait = this.getLongProperty("heartbeat-reply-wait", 0L);
    protected ScheduledFuture<?> clientHeartbeat;

    public ClientConnectionService(AbstractClientSession s) throws SshException {
        super(s);
    }

    @Override
    public final ClientSession getClientSession() {
        return this.getSession();
    }

    @Override
    public AbstractClientSession getSession() {
        return (AbstractClientSession)super.getSession();
    }

    @Override
    public void start() {
        ClientSession session = this.getClientSession();
        if (!session.isAuthenticated()) {
            throw new IllegalStateException("Session is not authenticated");
        }
        super.start();
    }

    @Override
    protected synchronized ScheduledFuture<?> startHeartBeat() {
        if (this.heartbeatInterval > 0L && GenericUtils.isNotEmpty((CharSequence)this.heartbeatRequest)) {
            this.stopHeartBeat();
            ClientSession session = this.getClientSession();
            ClientFactoryManager manager = session.getFactoryManager();
            ScheduledExecutorService service = manager.getScheduledExecutorService();
            this.clientHeartbeat = service.scheduleAtFixedRate(this::sendHeartBeat, this.heartbeatInterval, this.heartbeatInterval, TimeUnit.MILLISECONDS);
            if (this.log.isDebugEnabled()) {
                this.log.debug("startHeartbeat({}) - started at interval={} with request={}", new Object[]{session, this.heartbeatInterval, this.heartbeatRequest});
            }
            return this.clientHeartbeat;
        }
        return super.startHeartBeat();
    }

    @Override
    protected synchronized void stopHeartBeat() {
        try {
            super.stopHeartBeat();
        }
        finally {
            if (this.clientHeartbeat != null) {
                this.clientHeartbeat = null;
            }
        }
    }

    @Override
    protected boolean sendHeartBeat() {
        if (this.clientHeartbeat == null) {
            return super.sendHeartBeat();
        }
        AbstractClientSession session = this.getSession();
        try {
            boolean withReply = this.heartbeatReplyMaxWait > 0L;
            Buffer buf = session.createBuffer((byte)80, this.heartbeatRequest.length() + 8);
            buf.putString(this.heartbeatRequest);
            buf.putBoolean(withReply);
            if (withReply) {
                Buffer reply = session.request(this.heartbeatRequest, buf, this.heartbeatReplyMaxWait, TimeUnit.MILLISECONDS);
                if (reply != null && this.log.isTraceEnabled()) {
                    this.log.trace("sendHeartBeat({}) received reply size={} for request={}", new Object[]{session, reply.available(), this.heartbeatRequest});
                }
            } else {
                IoWriteFuture future = session.writePacket(buf);
                future.addListener(this::futureDone);
            }
            this.heartbeatCount.incrementAndGet();
            return true;
        }
        catch (IOException | Error | RuntimeException e) {
            session.exceptionCaught(e);
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendHeartBeat({}) failed ({}) to send heartbeat #{} request={}: {}", new Object[]{session, e.getClass().getSimpleName(), this.heartbeatCount, this.heartbeatRequest, e.getMessage()});
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("sendHeartBeat(" + session + ") exception details", e);
            }
            return false;
        }
    }

    @Override
    public AgentForwardSupport getAgentForwardSupport() {
        throw new IllegalStateException("Server side operation");
    }

    @Override
    public X11ForwardSupport getX11ForwardSupport() {
        throw new IllegalStateException("Server side operation");
    }
}

