/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.infinispan;

import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;
import org.infinispan.jboss.marshalling.core.JBossUserMarshaller;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.jboss.logging.Logger;
import org.jgroups.JChannel;
import org.keycloak.Config;
import org.keycloak.cluster.ManagedCacheManagerProvider;
import org.keycloak.cluster.infinispan.KeycloakHotRodMarshallerFactory;
import org.keycloak.connections.infinispan.DefaultInfinispanConnectionProvider;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.connections.infinispan.InfinispanConnectionProviderFactory;
import org.keycloak.connections.infinispan.RemoteCacheProvider;
import org.keycloak.connections.infinispan.TopologyInfo;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;

public class DefaultInfinispanConnectionProviderFactory
implements InfinispanConnectionProviderFactory {
    protected static final Logger logger = Logger.getLogger(DefaultInfinispanConnectionProviderFactory.class);
    protected Config.Scope config;
    protected EmbeddedCacheManager cacheManager;
    protected RemoteCacheProvider remoteCacheProvider;
    protected boolean containerManaged;
    private TopologyInfo topologyInfo;
    private static final Object CHANNEL_INIT_SYNCHRONIZER = new Object();

    public InfinispanConnectionProvider create(KeycloakSession session) {
        this.lazyInit();
        return new DefaultInfinispanConnectionProvider(this.cacheManager, this.remoteCacheProvider, this.topologyInfo);
    }

    public void close() {
        if (this.cacheManager != null && !this.containerManaged) {
            this.cacheManager.stop();
        }
        if (this.remoteCacheProvider != null) {
            this.remoteCacheProvider.stop();
        }
        this.cacheManager = null;
    }

    public String getId() {
        return "default";
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lazyInit() {
        if (this.cacheManager == null) {
            DefaultInfinispanConnectionProviderFactory defaultInfinispanConnectionProviderFactory = this;
            synchronized (defaultInfinispanConnectionProviderFactory) {
                if (this.cacheManager == null) {
                    EmbeddedCacheManager managedCacheManager = null;
                    Iterator<ManagedCacheManagerProvider> providers = ServiceLoader.load(ManagedCacheManagerProvider.class, DefaultInfinispanConnectionProvider.class.getClassLoader()).iterator();
                    if (providers.hasNext()) {
                        ManagedCacheManagerProvider provider = providers.next();
                        if (providers.hasNext()) {
                            throw new RuntimeException("Multiple " + ManagedCacheManagerProvider.class + " providers found.");
                        }
                        managedCacheManager = (EmbeddedCacheManager)provider.getCacheManager(this.config);
                    }
                    if (managedCacheManager == null) {
                        if (!this.config.getBoolean("embedded", Boolean.valueOf(false)).booleanValue()) {
                            throw new RuntimeException("No " + ManagedCacheManagerProvider.class.getName() + " found. If running in embedded mode set the [embedded] property to this provider.");
                        }
                        this.initEmbedded();
                    } else {
                        this.initContainerManaged(managedCacheManager);
                    }
                    logger.infof(this.topologyInfo.toString(), new Object[0]);
                    this.remoteCacheProvider = new RemoteCacheProvider(this.config, this.cacheManager);
                }
            }
        }
    }

    protected void initContainerManaged(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.containerManaged = true;
        long realmRevisionsMaxEntries = this.cacheManager.getCache("realms").getCacheConfiguration().memory().size();
        realmRevisionsMaxEntries = realmRevisionsMaxEntries > 0L ? 2L * realmRevisionsMaxEntries : 20000L;
        this.cacheManager.defineConfiguration("realmRevisions", this.getRevisionCacheConfig(realmRevisionsMaxEntries));
        this.cacheManager.getCache("realmRevisions", true);
        long userRevisionsMaxEntries = this.cacheManager.getCache("users").getCacheConfiguration().memory().size();
        userRevisionsMaxEntries = userRevisionsMaxEntries > 0L ? 2L * userRevisionsMaxEntries : 100000L;
        this.cacheManager.defineConfiguration("userRevisions", this.getRevisionCacheConfig(userRevisionsMaxEntries));
        this.cacheManager.getCache("userRevisions", true);
        this.cacheManager.getCache("authorization", true);
        this.cacheManager.getCache("authenticationSessions", true);
        this.cacheManager.getCache("keys", true);
        this.cacheManager.getCache("actionTokens", true);
        long authzRevisionsMaxEntries = this.cacheManager.getCache("authorization").getCacheConfiguration().memory().size();
        authzRevisionsMaxEntries = authzRevisionsMaxEntries > 0L ? 2L * authzRevisionsMaxEntries : 20000L;
        this.cacheManager.defineConfiguration("authorizationRevisions", this.getRevisionCacheConfig(authzRevisionsMaxEntries));
        this.cacheManager.getCache("authorizationRevisions", true);
        this.topologyInfo = new TopologyInfo(this.cacheManager, this.config, false);
        logger.debugv("Using container managed Infinispan cache container, lookup={0}", (Object)cacheManager);
    }

    protected void initEmbedded() {
        GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder();
        boolean clustered = this.config.getBoolean("clustered", Boolean.valueOf(false));
        boolean async = this.config.getBoolean("async", Boolean.valueOf(false));
        this.topologyInfo = new TopologyInfo(this.cacheManager, this.config, true);
        if (clustered) {
            String jgroupsUdpMcastAddr = this.config.get("jgroupsUdpMcastAddr", System.getProperty("jgroups.udp.mcast_addr"));
            this.configureTransport(gcb, this.topologyInfo.getMyNodeName(), this.topologyInfo.getMySiteName(), jgroupsUdpMcastAddr);
            gcb.jmx().jmxDomain("jboss.datagrid-infinispan-" + this.topologyInfo.getMyNodeName());
        }
        gcb.jmx().domain("jboss.datagrid-infinispan").enable();
        gcb.serialization().marshaller((Marshaller)new JBossUserMarshaller());
        this.cacheManager = new DefaultCacheManager(gcb.build());
        this.containerManaged = false;
        logger.debug((Object)"Started embedded Infinispan cache container");
        ConfigurationBuilder modelCacheConfigBuilder = new ConfigurationBuilder();
        Configuration modelCacheConfiguration = modelCacheConfigBuilder.build();
        this.cacheManager.defineConfiguration("realms", modelCacheConfiguration);
        this.cacheManager.defineConfiguration("authorization", modelCacheConfiguration);
        this.cacheManager.defineConfiguration("users", modelCacheConfiguration);
        ConfigurationBuilder sessionConfigBuilder = new ConfigurationBuilder();
        if (clustered) {
            String sessionsMode = this.config.get("sessionsMode", "distributed");
            if (sessionsMode.equalsIgnoreCase("replicated")) {
                sessionConfigBuilder.clustering().cacheMode(async ? CacheMode.REPL_ASYNC : CacheMode.REPL_SYNC);
            } else if (sessionsMode.equalsIgnoreCase("distributed")) {
                sessionConfigBuilder.clustering().cacheMode(async ? CacheMode.DIST_ASYNC : CacheMode.DIST_SYNC);
            } else {
                throw new RuntimeException("Invalid value for sessionsMode");
            }
            int owners = this.config.getInt("sessionsOwners", Integer.valueOf(2));
            logger.debugf("Session owners: %d", owners);
            int l1Lifespan = this.config.getInt("l1Lifespan", Integer.valueOf(600000));
            boolean l1Enabled = l1Lifespan > 0;
            sessionConfigBuilder.clustering().hash().numOwners(owners).numSegments(this.config.getInt("sessionsSegments", Integer.valueOf(60)).intValue()).l1().enabled(l1Enabled).lifespan((long)l1Lifespan).build();
        }
        Configuration sessionCacheConfigurationBase = sessionConfigBuilder.build();
        boolean jdgEnabled = this.config.getBoolean("remoteStoreEnabled", Boolean.valueOf(false));
        if (jdgEnabled) {
            sessionConfigBuilder = new ConfigurationBuilder();
            sessionConfigBuilder.read(sessionCacheConfigurationBase);
            this.configureRemoteCacheStore(sessionConfigBuilder, async, "sessions", true);
        }
        Configuration sessionCacheConfiguration = sessionConfigBuilder.build();
        this.cacheManager.defineConfiguration("sessions", sessionCacheConfiguration);
        if (jdgEnabled) {
            sessionConfigBuilder = new ConfigurationBuilder();
            sessionConfigBuilder.read(sessionCacheConfigurationBase);
            this.configureRemoteCacheStore(sessionConfigBuilder, async, "offlineSessions", true);
        }
        sessionCacheConfiguration = sessionConfigBuilder.build();
        this.cacheManager.defineConfiguration("offlineSessions", sessionCacheConfiguration);
        if (jdgEnabled) {
            sessionConfigBuilder = new ConfigurationBuilder();
            sessionConfigBuilder.read(sessionCacheConfigurationBase);
            this.configureRemoteCacheStore(sessionConfigBuilder, async, "clientSessions", true);
        }
        sessionCacheConfiguration = sessionConfigBuilder.build();
        this.cacheManager.defineConfiguration("clientSessions", sessionCacheConfiguration);
        if (jdgEnabled) {
            sessionConfigBuilder = new ConfigurationBuilder();
            sessionConfigBuilder.read(sessionCacheConfigurationBase);
            this.configureRemoteCacheStore(sessionConfigBuilder, async, "offlineClientSessions", true);
        }
        sessionCacheConfiguration = sessionConfigBuilder.build();
        this.cacheManager.defineConfiguration("offlineClientSessions", sessionCacheConfiguration);
        if (jdgEnabled) {
            sessionConfigBuilder = new ConfigurationBuilder();
            sessionConfigBuilder.read(sessionCacheConfigurationBase);
            this.configureRemoteCacheStore(sessionConfigBuilder, async, "loginFailures", true);
        }
        sessionCacheConfiguration = sessionConfigBuilder.build();
        this.cacheManager.defineConfiguration("loginFailures", sessionCacheConfiguration);
        this.cacheManager.defineConfiguration("authenticationSessions", sessionCacheConfigurationBase);
        this.cacheManager.getCache("sessions", true);
        this.cacheManager.getCache("offlineSessions", true);
        this.cacheManager.getCache("clientSessions", true);
        this.cacheManager.getCache("offlineClientSessions", true);
        this.cacheManager.getCache("loginFailures", true);
        this.cacheManager.getCache("authenticationSessions", true);
        ConfigurationBuilder replicationConfigBuilder = new ConfigurationBuilder();
        if (clustered) {
            replicationConfigBuilder.clustering().cacheMode(async ? CacheMode.REPL_ASYNC : CacheMode.REPL_SYNC);
        }
        if (jdgEnabled) {
            this.configureRemoteCacheStore(replicationConfigBuilder, async, "work", false);
        }
        Configuration replicationEvictionCacheConfiguration = replicationConfigBuilder.build();
        this.cacheManager.defineConfiguration("work", replicationEvictionCacheConfiguration);
        long realmRevisionsMaxEntries = this.cacheManager.getCache("realms").getCacheConfiguration().memory().size();
        realmRevisionsMaxEntries = realmRevisionsMaxEntries > 0L ? 2L * realmRevisionsMaxEntries : 20000L;
        this.cacheManager.defineConfiguration("realmRevisions", this.getRevisionCacheConfig(realmRevisionsMaxEntries));
        this.cacheManager.getCache("realmRevisions", true);
        long userRevisionsMaxEntries = this.cacheManager.getCache("users").getCacheConfiguration().memory().size();
        userRevisionsMaxEntries = userRevisionsMaxEntries > 0L ? 2L * userRevisionsMaxEntries : 100000L;
        this.cacheManager.defineConfiguration("userRevisions", this.getRevisionCacheConfig(userRevisionsMaxEntries));
        this.cacheManager.getCache("userRevisions", true);
        this.cacheManager.defineConfiguration("keys", this.getKeysCacheConfig());
        this.cacheManager.getCache("keys", true);
        ConfigurationBuilder actionTokenCacheConfigBuilder = this.getActionTokenCacheConfig();
        if (clustered) {
            actionTokenCacheConfigBuilder.clustering().cacheMode(async ? CacheMode.REPL_ASYNC : CacheMode.REPL_SYNC);
        }
        if (jdgEnabled) {
            this.configureRemoteActionTokenCacheStore(actionTokenCacheConfigBuilder, async);
        }
        this.cacheManager.defineConfiguration("actionTokens", actionTokenCacheConfigBuilder.build());
        this.cacheManager.getCache("actionTokens", true);
        long authzRevisionsMaxEntries = this.cacheManager.getCache("authorization").getCacheConfiguration().memory().size();
        authzRevisionsMaxEntries = authzRevisionsMaxEntries > 0L ? 2L * authzRevisionsMaxEntries : 20000L;
        this.cacheManager.defineConfiguration("authorizationRevisions", this.getRevisionCacheConfig(authzRevisionsMaxEntries));
        this.cacheManager.getCache("authorizationRevisions", true);
    }

    private Configuration getRevisionCacheConfig(long maxEntries) {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.invocationBatching().enable().transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        cb.transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup());
        cb.transaction().lockingMode(LockingMode.PESSIMISTIC);
        cb.memory().evictionStrategy(EvictionStrategy.REMOVE).evictionType(EvictionType.COUNT).size(maxEntries);
        return cb.build();
    }

    private void configureRemoteCacheStore(ConfigurationBuilder builder, boolean async, String cacheName, boolean sessionCache) {
        String jdgServer = this.config.get("remoteStoreHost", "localhost");
        Integer jdgPort = this.config.getInt("remoteStorePort", Integer.valueOf(11222));
        ((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)builder.persistence().passivation(false).addStore(RemoteStoreConfigurationBuilder.class)).fetchPersistentState(false)).ignoreModifications(false)).purgeOnStartup(false)).preload(false)).shared(true)).remoteCacheName(cacheName).rawValues(true).forceReturnValues(false).marshaller(KeycloakHotRodMarshallerFactory.class.getName()).protocolVersion(this.getHotrodVersion()).addServer().host(jdgServer).port(jdgPort.intValue()).async().enabled(async);
    }

    private void configureRemoteActionTokenCacheStore(ConfigurationBuilder builder, boolean async) {
        String jdgServer = this.config.get("remoteStoreHost", "localhost");
        Integer jdgPort = this.config.getInt("remoteStorePort", Integer.valueOf(11222));
        ((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)builder.persistence().passivation(false).addStore(RemoteStoreConfigurationBuilder.class)).fetchPersistentState(false)).ignoreModifications(false)).purgeOnStartup(false)).preload(true)).shared(true)).remoteCacheName("actionTokens").rawValues(true).forceReturnValues(false).marshaller(KeycloakHotRodMarshallerFactory.class.getName()).protocolVersion(this.getHotrodVersion()).addServer().host(jdgServer).port(jdgPort.intValue()).async().enabled(async);
    }

    private ProtocolVersion getHotrodVersion() {
        String hotrodVersionStr = this.config.get("hotrodProtocolVersion", ProtocolVersion.DEFAULT_PROTOCOL_VERSION.toString());
        ProtocolVersion hotrodVersion = ProtocolVersion.parseVersion((String)hotrodVersionStr);
        if (hotrodVersion == null) {
            hotrodVersion = ProtocolVersion.DEFAULT_PROTOCOL_VERSION;
        }
        logger.debugf("HotRod protocol version: %s", (Object)hotrodVersion);
        return hotrodVersion;
    }

    protected Configuration getKeysCacheConfig() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.memory().evictionStrategy(EvictionStrategy.REMOVE).evictionType(EvictionType.COUNT).size(1000L);
        cb.expiration().maxIdle(3600L, TimeUnit.SECONDS);
        return cb.build();
    }

    private ConfigurationBuilder getActionTokenCacheConfig() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.memory().evictionStrategy(EvictionStrategy.NONE).evictionType(EvictionType.COUNT).size(-1L);
        cb.expiration().maxIdle(-1L, TimeUnit.SECONDS).wakeUpInterval(300000L, TimeUnit.SECONDS);
        return cb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configureTransport(GlobalConfigurationBuilder gcb, String nodeName, String siteName, String jgroupsUdpMcastAddr) {
        if (nodeName == null) {
            gcb.transport().defaultTransport();
        } else {
            FileLookup fileLookup = FileLookupFactory.newInstance();
            Object object = CHANNEL_INIT_SYNCHRONIZER;
            synchronized (object) {
                String originalMcastAddr = System.getProperty("jgroups.udp.mcast_addr");
                if (jgroupsUdpMcastAddr == null) {
                    System.getProperties().remove("jgroups.udp.mcast_addr");
                } else {
                    System.setProperty("jgroups.udp.mcast_addr", jgroupsUdpMcastAddr);
                }
                try {
                    JChannel channel = new JChannel(fileLookup.lookupFileLocation("default-configs/default-jgroups-udp.xml", this.getClass().getClassLoader()).openStream());
                    channel.setName(nodeName);
                    JGroupsTransport transport = new JGroupsTransport(channel);
                    TransportConfigurationBuilder transportBuilder = gcb.transport().nodeName(nodeName).siteId(siteName).transport((Transport)transport);
                    if (siteName != null) {
                        transportBuilder.clusterName(siteName);
                    }
                    transportBuilder.jmx().jmxDomain("jboss.datagrid-infinispan-" + nodeName).enable();
                    logger.infof("Configured jgroups transport with the channel name: %s", (Object)nodeName);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (originalMcastAddr == null) {
                        System.getProperties().remove("jgroups.udp.mcast_addr");
                    } else {
                        System.setProperty("jgroups.udp.mcast_addr", originalMcastAddr);
                    }
                }
            }
        }
    }
}

