/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import java.lang.annotation.Annotation;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheCollection;
import org.infinispan.CacheSet;
import org.infinispan.cache.impl.AbstractDelegatingAdvancedCache;
import org.infinispan.cache.impl.BiFunctionMapper;
import org.infinispan.cache.impl.CacheImpl;
import org.infinispan.cache.impl.EncoderEntryMapper;
import org.infinispan.cache.impl.EncoderKeyMapper;
import org.infinispan.cache.impl.EncoderValueMapper;
import org.infinispan.cache.impl.FunctionMapper;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.IdentityEncoder;
import org.infinispan.commons.dataconversion.IdentityWrapper;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.commons.util.InjectiveFunction;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ForwardingCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.ListenerHolder;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.util.WriteableCacheCollectionMapper;
import org.infinispan.util.WriteableCacheSetMapper;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;

@Scope(value=Scopes.NAMED_CACHE)
public class EncoderCache<K, V>
extends AbstractDelegatingAdvancedCache<K, V> {
    @Inject
    InternalEntryFactory entryFactory;
    @Inject
    BasicComponentRegistry componentRegistry;
    private final DataConversion keyDataConversion;
    private final DataConversion valueDataConversion;
    private final Function<V, V> decodedValueForRead = this::valueFromStorage;

    public EncoderCache(AdvancedCache<K, V> cache, InternalEntryFactory entryFactory, BasicComponentRegistry componentRegistry, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        super(cache);
        this.entryFactory = entryFactory;
        this.componentRegistry = componentRegistry;
        this.keyDataConversion = keyDataConversion;
        this.valueDataConversion = valueDataConversion;
    }

    @Override
    public AdvancedCache rewrap(AdvancedCache newDelegate) {
        return new EncoderCache<K, V>(newDelegate, this.entryFactory, this.componentRegistry, this.keyDataConversion, this.valueDataConversion);
    }

    private Set<?> encodeKeysForWrite(Set<?> keys) {
        if (this.needsEncoding(keys)) {
            return keys.stream().map(this::keyToStorage).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return keys;
    }

    private boolean needsEncoding(Collection<?> keys) {
        return keys.stream().anyMatch(k -> !k.equals(this.keyToStorage(k)));
    }

    private Collection<? extends K> encodeKeysForWrite(Collection<? extends K> keys) {
        if (this.needsEncoding(keys)) {
            return keys.stream().map(this::keyToStorage).collect(Collectors.toCollection(ArrayList::new));
        }
        return keys;
    }

    public K keyToStorage(Object key) {
        return (K)this.keyDataConversion.toStorage(key);
    }

    public V valueToStorage(Object value) {
        return (V)this.valueDataConversion.toStorage(value);
    }

    public K keyFromStorage(Object key) {
        return (K)this.keyDataConversion.fromStorage(key);
    }

    public V valueFromStorage(Object value) {
        return (V)this.valueDataConversion.fromStorage(value);
    }

    @Inject
    public void wireRealCache() {
        this.componentRegistry.wireDependencies(this.keyDataConversion, false);
        this.componentRegistry.wireDependencies(this.valueDataConversion, false);
        this.componentRegistry.wireDependencies(this.cache, false);
    }

    private Map<K, V> encodeMapForWrite(Map<? extends K, ? extends V> map) {
        HashMap newMap = new HashMap(map.size());
        map.forEach((k, v) -> newMap.put(this.keyToStorage(k), this.valueToStorage(v)));
        return newMap;
    }

    private Map<K, V> decodeMapForRead(Map<? extends K, ? extends V> map) {
        LinkedHashMap newMap = new LinkedHashMap(map.size());
        map.forEach((k, v) -> newMap.put(this.keyFromStorage(k), this.valueFromStorage(v)));
        return newMap;
    }

    private CacheEntry<K, V> convertEntry(K newKey, V newValue, CacheEntry<K, V> entry) {
        if (entry instanceof InternalCacheEntry) {
            return this.entryFactory.create(newKey, newValue, (InternalCacheEntry)entry);
        }
        return this.entryFactory.create(newKey, newValue, entry.getMetadata().version(), entry.getCreated(), entry.getLifespan(), entry.getLastUsed(), entry.getMaxIdle());
    }

    private BiFunction<? super K, ? super V, ? extends V> convertFunction(BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (k, v) -> this.valueToStorage(remappingFunction.apply((K)this.keyFromStorage(k), (V)this.valueFromStorage(v)));
    }

    private Map<K, CacheEntry<K, V>> decodeEntryMapForRead(Map<K, CacheEntry<K, V>> map) {
        HashMap entryMap = new HashMap(map.size());
        map.values().forEach((? super T v) -> {
            Object originalKey = v.getKey();
            K unwrappedKey = this.keyFromStorage(originalKey);
            Object originalValue = v.getValue();
            V unwrappedValue = this.valueFromStorage(originalValue);
            CacheEntry<K, V> entryToPut = unwrappedKey != originalKey || unwrappedValue != originalValue ? this.convertEntry(unwrappedKey, unwrappedValue, (CacheEntry<K, V>)v) : v;
            entryMap.put(unwrappedKey, entryToPut);
        });
        return entryMap;
    }

    @Override
    public void putForExternalRead(K key, V value) {
        super.putForExternalRead(this.keyToStorage(key), this.valueToStorage(value));
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit unit) {
        super.putForExternalRead(this.keyToStorage(key), this.valueToStorage(value), lifespan, unit);
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        super.putForExternalRead(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public void evict(K key) {
        super.evict(this.keyToStorage(key));
    }

    @Override
    public V put(K key, V value, long lifespan, TimeUnit unit) {
        V ret = super.put(this.keyToStorage(key), this.valueToStorage(value), lifespan, unit);
        return this.valueFromStorage(ret);
    }

    @Override
    public DataConversion getKeyDataConversion() {
        return this.keyDataConversion;
    }

    @Override
    public DataConversion getValueDataConversion() {
        return this.valueDataConversion;
    }

    @Override
    protected void set(K key, V value) {
        super.set(this.keyToStorage(key), this.valueToStorage(value));
    }

    @Override
    public V putIfAbsent(K key, V value, long lifespan, TimeUnit unit) {
        V v = super.putIfAbsent(this.keyToStorage(key), this.valueToStorage(value), lifespan, unit);
        return this.valueFromStorage(v);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit unit) {
        super.putAll(this.encodeMapForWrite(map), lifespan, unit);
    }

    @Override
    public V replace(K key, V value, long lifespan, TimeUnit unit) {
        V ret = super.replace(this.keyToStorage(key), this.valueToStorage(value), lifespan, unit);
        return this.valueFromStorage(ret);
    }

    @Override
    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit unit) {
        return super.replace(this.keyToStorage(key), this.valueToStorage(oldValue), this.valueToStorage(value), lifespan, unit);
    }

    @Override
    public V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        V ret = super.put(this.keyToStorage(key), this.valueToStorage(value), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        return this.valueFromStorage(ret);
    }

    @Override
    public V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        V ret = super.putIfAbsent(this.keyToStorage(key), this.valueToStorage(value), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        return this.valueFromStorage(ret);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        super.putAll(this.encodeMapForWrite(map), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        V ret = super.replace(this.keyToStorage(key), this.valueToStorage(value), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        return this.valueFromStorage(ret);
    }

    @Override
    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return super.replace(this.keyToStorage(key), this.valueToStorage(oldValue), this.valueToStorage(value), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        super.replaceAll(this.convertFunction(function));
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value) {
        return super.putAsync(this.keyToStorage(key), this.valueToStorage(value)).thenApply(this.decodedValueForRead);
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit unit) {
        return super.putAsync(this.keyToStorage(key), this.valueToStorage(value), lifespan, unit).thenApply(this.decodedValueForRead);
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return super.putAsync(this.keyToStorage(key), this.valueToStorage(value), lifespan, lifespanUnit, maxIdle, maxIdleUnit).thenApply(this.decodedValueForRead);
    }

    @Override
    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data) {
        return super.putAllAsync(this.encodeMapForWrite(data));
    }

    @Override
    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit unit) {
        return super.putAllAsync(this.encodeMapForWrite(data), lifespan, unit);
    }

    @Override
    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return super.putAllAsync(this.encodeMapForWrite(data), lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> map, Metadata metadata) {
        return super.putAllAsync(this.encodeMapForWrite(map), metadata);
    }

    @Override
    public CompletableFuture<V> putIfAbsentAsync(K key, V value) {
        return super.putIfAbsentAsync(this.keyToStorage(key), this.valueToStorage(value)).thenApply(this.decodedValueForRead);
    }

    @Override
    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit unit) {
        return super.putIfAbsentAsync(this.keyToStorage(key), this.valueToStorage(value), lifespan, unit).thenApply(this.decodedValueForRead);
    }

    @Override
    public boolean lock(K ... keys) {
        Object[] encoded = Arrays.stream(keys).map(this::keyToStorage).toArray();
        return super.lock(encoded);
    }

    @Override
    public boolean lock(Collection<? extends K> keys) {
        return super.lock(this.encodeKeysForWrite(keys));
    }

    @Override
    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return super.putIfAbsentAsync(this.keyToStorage(key), this.valueToStorage(value), lifespan, lifespanUnit, maxIdle, maxIdleUnit).thenApply(this.decodedValueForRead);
    }

    @Override
    public CompletableFuture<V> putIfAbsentAsync(K key, V value, Metadata metadata) {
        return super.putIfAbsentAsync(this.keyToStorage(key), this.valueToStorage(value), metadata).thenApply(this.decodedValueForRead);
    }

    @Override
    public CompletableFuture<V> removeAsync(Object key) {
        return super.removeAsync(this.keyToStorage(key)).thenApply(this.decodedValueForRead);
    }

    @Override
    public CompletableFuture<Boolean> removeAsync(Object key, Object value) {
        return super.removeAsync(this.keyToStorage(key), this.valueToStorage(value));
    }

    @Override
    public CompletableFuture<V> replaceAsync(K key, V value) {
        return super.replaceAsync(this.keyToStorage(key), this.valueToStorage(value)).thenApply(this.decodedValueForRead);
    }

    @Override
    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit unit) {
        return super.replaceAsync(this.keyToStorage(key), this.valueToStorage(value), lifespan, unit).thenApply(this.decodedValueForRead);
    }

    @Override
    public CompletableFuture<V> replaceAsync(K key, V value, Metadata metadata) {
        return super.replaceAsync(this.keyToStorage(key), this.valueToStorage(value), metadata).thenApply(this.decodedValueForRead);
    }

    @Override
    public Map<K, V> getAll(Set<?> keys) {
        Map ret = super.getAll(this.encodeKeysForWrite(keys));
        return this.decodeMapForRead(ret);
    }

    @Override
    public CompletableFuture<Map<K, V>> getAllAsync(Set<?> keys) {
        return super.getAllAsync(this.encodeKeysForWrite(keys)).thenApply(this::decodeMapForRead);
    }

    @Override
    public CacheEntry<K, V> getCacheEntry(Object key) {
        K keyToStorage = this.keyToStorage(key);
        CacheEntry returned = super.getCacheEntry(keyToStorage);
        return this.unwrapCacheEntry(key, keyToStorage, returned);
    }

    @Override
    public CompletableFuture<CacheEntry<K, V>> getCacheEntryAsync(Object key) {
        K keyToStorage = this.keyToStorage(key);
        return super.getCacheEntryAsync(keyToStorage).thenApply(returned -> this.unwrapCacheEntry(key, keyToStorage, (CacheEntry<K, V>)returned));
    }

    private CacheEntry<K, V> unwrapCacheEntry(Object key, K keyToStorage, CacheEntry<K, V> returned) {
        if (returned != null) {
            V originalValue = returned.getValue();
            V valueFromStorage = this.valueFromStorage(originalValue);
            if (keyToStorage != key || valueFromStorage != originalValue) {
                return this.convertEntry(key, valueFromStorage, returned);
            }
        }
        return returned;
    }

    @Override
    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return super.replaceAsync(this.keyToStorage(key), this.valueToStorage(value), lifespan, lifespanUnit, maxIdle, maxIdleUnit).thenApply(this.decodedValueForRead);
    }

    @Override
    public Map<K, CacheEntry<K, V>> getAllCacheEntries(Set<?> keys) {
        Map returned = super.getAllCacheEntries(this.encodeKeysForWrite(keys));
        return this.decodeEntryMapForRead(returned);
    }

    @Override
    public Map<K, V> getGroup(String groupName) {
        Map ret = super.getGroup(groupName);
        return this.decodeMapForRead(ret);
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        return super.replaceAsync(this.keyToStorage(key), this.valueToStorage(oldValue), this.valueToStorage(newValue));
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit unit) {
        return super.replaceAsync(this.keyToStorage(key), this.valueToStorage(oldValue), this.valueToStorage(newValue), lifespan, unit);
    }

    @Override
    public V put(K key, V value, Metadata metadata) {
        V ret = super.put(this.keyToStorage(key), this.valueToStorage(value), metadata);
        return this.valueFromStorage(ret);
    }

    @Override
    public V replace(K key, V value, Metadata metadata) {
        V ret = super.replace(this.keyToStorage(key), this.valueToStorage(value), metadata);
        return this.valueFromStorage(ret);
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return super.replaceAsync(this.keyToStorage(key), this.valueToStorage(oldValue), this.valueToStorage(newValue), lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public boolean replace(K key, V oldValue, V value, Metadata metadata) {
        return super.replace(this.keyToStorage(key), this.valueToStorage(oldValue), this.valueToStorage(value), metadata);
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, Metadata metadata) {
        return super.replaceAsync(this.keyToStorage(key), this.valueToStorage(oldValue), this.valueToStorage(newValue), metadata);
    }

    @Override
    public V putIfAbsent(K key, V value, Metadata metadata) {
        V ret = super.putIfAbsent(this.keyToStorage(key), this.valueToStorage(value), metadata);
        return this.valueFromStorage(ret);
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value, Metadata metadata) {
        return super.putAsync(this.keyToStorage(key), this.valueToStorage(value), metadata).thenApply(this.decodedValueForRead);
    }

    @Override
    public void putForExternalRead(K key, V value, Metadata metadata) {
        super.putForExternalRead(this.keyToStorage(key), this.valueToStorage(value), metadata);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, Metadata metadata) {
        super.putAll(this.encodeMapForWrite(map), metadata);
    }

    @Override
    public CacheSet<CacheEntry<K, V>> cacheEntrySet() {
        EncoderEntryMapper cacheEntryMapper = EncoderEntryMapper.newCacheEntryMapper(this.keyDataConversion, this.valueDataConversion, this.entryFactory);
        return new WriteableCacheSetMapper(super.cacheEntrySet(), cacheEntryMapper, e -> new CacheEntryWrapper(cacheEntryMapper.apply(e), e), this::toCacheEntry, this::keyToStorage);
    }

    @Override
    public CompletableFuture<Boolean> removeLifespanExpired(K key, V value, Long lifespan) {
        return super.removeLifespanExpired(this.keyToStorage(key), this.valueToStorage(value), lifespan);
    }

    @Override
    public CompletableFuture<Boolean> removeMaxIdleExpired(K key, V value) {
        return super.removeMaxIdleExpired(this.keyToStorage(key), this.valueToStorage(value));
    }

    @Override
    public V putIfAbsent(K key, V value) {
        V ret = super.putIfAbsent(this.keyToStorage(key), this.valueToStorage(value));
        return this.valueFromStorage(ret);
    }

    private void lookupEncoderWrapper() {
        this.componentRegistry.wireDependencies(this.keyDataConversion, true);
        this.componentRegistry.wireDependencies(this.valueDataConversion, true);
    }

    @Override
    public AdvancedCache<K, V> withEncoding(Class<? extends Encoder> keyEncoderClass, Class<? extends Encoder> valueEncoderClass) {
        this.checkSubclass(keyEncoderClass, Encoder.class);
        this.checkSubclass(valueEncoderClass, Encoder.class);
        DataConversion newKeyDataConversion = this.keyDataConversion.withEncoding(keyEncoderClass);
        DataConversion newValueDataConversion = this.valueDataConversion.withEncoding(valueEncoderClass);
        EncoderCache<K, V> encoderCache = new EncoderCache<K, V>(this.cache, this.entryFactory, this.componentRegistry, newKeyDataConversion, newValueDataConversion);
        super.lookupEncoderWrapper();
        return encoderCache;
    }

    @Override
    public AdvancedCache<K, V> withEncoding(Class<? extends Encoder> encoderClass) {
        this.checkSubclass(encoderClass, Encoder.class);
        DataConversion newKeyDataConversion = this.keyDataConversion.withEncoding(encoderClass);
        DataConversion newValueDataConversion = this.valueDataConversion.withEncoding(encoderClass);
        EncoderCache<K, V> encoderCache = new EncoderCache<K, V>(this.cache, this.entryFactory, this.componentRegistry, newKeyDataConversion, newValueDataConversion);
        super.lookupEncoderWrapper();
        return encoderCache;
    }

    @Override
    public AdvancedCache<K, V> withKeyEncoding(Class<? extends Encoder> encoderClass) {
        this.checkSubclass(encoderClass, Encoder.class);
        DataConversion newKeyDataConversion = this.keyDataConversion.withEncoding(encoderClass);
        EncoderCache<K, V> encoderCache = new EncoderCache<K, V>(this.cache, this.entryFactory, this.componentRegistry, newKeyDataConversion, this.valueDataConversion);
        super.lookupEncoderWrapper();
        return encoderCache;
    }

    private void checkSubclass(Class<?> configured, Class<?> required) {
        if (!required.isAssignableFrom(configured)) {
            throw Log.CONTAINER.invalidEncodingClass(configured, required);
        }
    }

    private boolean allIdentity(Class<? extends Encoder> keyEncoderClass, Class<? extends Encoder> valueEncoderClass, Class<? extends Wrapper> keyWrapperClass, Class<? extends Wrapper> valueWrapperClass) {
        return keyEncoderClass == IdentityEncoder.class && valueEncoderClass == IdentityEncoder.class && keyWrapperClass == IdentityWrapper.class && valueWrapperClass == IdentityWrapper.class;
    }

    @Override
    public AdvancedCache<K, V> withWrapping(Class<? extends Wrapper> keyWrapperClass, Class<? extends Wrapper> valueWrapperClass) {
        this.checkSubclass(keyWrapperClass, Wrapper.class);
        this.checkSubclass(valueWrapperClass, Wrapper.class);
        DataConversion newKeyDataConversion = this.keyDataConversion.withWrapping(keyWrapperClass);
        DataConversion newValueDataConversion = this.valueDataConversion.withWrapping(valueWrapperClass);
        EncoderCache<K, V> encoderCache = new EncoderCache<K, V>(this.cache, this.entryFactory, this.componentRegistry, newKeyDataConversion, newValueDataConversion);
        super.lookupEncoderWrapper();
        return encoderCache;
    }

    @Override
    public AdvancedCache<K, V> withWrapping(Class<? extends Wrapper> wrapper) {
        return this.withWrapping(wrapper, wrapper);
    }

    @Override
    public AdvancedCache<K, V> withMediaType(String keyMediaType, String valueMediaType) {
        MediaType kType = MediaType.fromString((String)keyMediaType);
        MediaType vType = MediaType.fromString((String)valueMediaType);
        return this.withMediaType(kType, vType);
    }

    private AdvancedCache<K, V> withMediaType(MediaType kType, MediaType vType) {
        DataConversion newKeyDataConversion = this.keyDataConversion.withRequestMediaType(kType);
        DataConversion newValueDataConversion = this.valueDataConversion.withRequestMediaType(vType);
        EncoderCache<K, V> encoderCache = new EncoderCache<K, V>(this.cache, this.entryFactory, this.componentRegistry, newKeyDataConversion, newValueDataConversion);
        super.lookupEncoderWrapper();
        return encoderCache;
    }

    @Override
    public AdvancedCache<K, V> withStorageMediaType() {
        MediaType keyStorageMediaType = this.keyDataConversion.getStorageMediaType();
        MediaType valueStorageMediaType = this.valueDataConversion.getStorageMediaType();
        return this.withMediaType(keyStorageMediaType, valueStorageMediaType);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return super.remove(this.keyToStorage(key), this.valueToStorage(value));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return super.replace(this.keyToStorage(key), this.valueToStorage(oldValue), this.valueToStorage(newValue));
    }

    @Override
    public V replace(K key, V value) {
        V ret = super.replace(this.keyToStorage(key), this.valueToStorage(value));
        return this.valueFromStorage(ret);
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(this.keyToStorage(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return super.containsValue(this.valueToStorage(value));
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Object returned = super.compute(this.keyToStorage(key), this.wrapBiFunction(remappingFunction));
        return this.valueFromStorage(returned);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        Object returned = super.compute(this.keyToStorage(key), this.wrapBiFunction(remappingFunction), metadata);
        return this.valueFromStorage(returned);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        Object returned = super.compute(this.keyToStorage(key), this.wrapBiFunction(remappingFunction), lifespan, lifespanUnit);
        return this.valueFromStorage(returned);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Object returned = super.compute(this.keyToStorage(key), this.wrapBiFunction(remappingFunction), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        return this.valueFromStorage(returned);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Object returned = super.computeIfPresent(this.keyToStorage(key), this.wrapBiFunction(remappingFunction));
        return this.valueFromStorage(returned);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        Object returned = super.computeIfPresent(this.keyToStorage(key), this.wrapBiFunction(remappingFunction), metadata);
        return this.valueFromStorage(returned);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        Object returned = super.computeIfPresent(this.keyToStorage(key), this.wrapBiFunction(remappingFunction), lifespan, lifespanUnit);
        return this.valueFromStorage(returned);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Object returned = super.computeIfPresent(this.keyToStorage(key), this.wrapBiFunction(remappingFunction), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        return this.valueFromStorage(returned);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        Object ret = super.computeIfAbsent(this.keyToStorage(key), this.wrapFunction(mappingFunction));
        return this.valueFromStorage(ret);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, Metadata metadata) {
        Object ret = super.computeIfAbsent(this.keyToStorage(key), this.wrapFunction(mappingFunction), metadata);
        return this.valueFromStorage(ret);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit) {
        Object ret = super.computeIfAbsent(this.keyToStorage(key), this.wrapFunction(mappingFunction), lifespan, lifespanUnit);
        return this.valueFromStorage(ret);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Object ret = super.computeIfAbsent(this.keyToStorage(key), this.wrapFunction(mappingFunction), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        return this.valueFromStorage(ret);
    }

    @Override
    public V get(Object key) {
        Object v = super.get(this.keyToStorage(key));
        return this.valueFromStorage(v);
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        V returned = super.getOrDefault(this.keyToStorage(key), defaultValue);
        if (returned == defaultValue) {
            return returned;
        }
        return this.valueFromStorage(returned);
    }

    @Override
    public V put(K key, V value) {
        V ret = super.put(this.keyToStorage(key), this.valueToStorage(value));
        if (ret == null) {
            return null;
        }
        return this.valueFromStorage(ret);
    }

    @Override
    public V remove(Object key) {
        Object ret = super.remove(this.keyToStorage(key));
        return this.valueFromStorage(ret);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        super.putAll(this.encodeMapForWrite(t));
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        V returned = super.merge(this.keyToStorage(key), this.valueToStorage(value), this.wrapBiFunction(remappingFunction));
        return this.valueFromStorage(returned);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        V returned = super.merge(this.keyToStorage(key), this.valueToStorage(value), this.wrapBiFunction(remappingFunction), metadata);
        return this.valueFromStorage(returned);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        V returned = super.merge(this.keyToStorage(key), this.valueToStorage(value), this.wrapBiFunction(remappingFunction), lifespan, lifespanUnit);
        return this.valueFromStorage(returned);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        V returned = super.merge(this.keyToStorage(key), this.valueToStorage(value), this.wrapBiFunction(remappingFunction), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        return this.valueFromStorage(returned);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        super.forEach((k, v) -> {
            K newK = this.keyFromStorage(k);
            V newV = this.valueFromStorage(v);
            action.accept((K)newK, (V)newV);
        });
    }

    @Override
    public CacheSet<K> keySet() {
        InjectiveFunction keyToStorage = this::keyToStorage;
        return new WriteableCacheSetMapper(super.keySet(), new EncoderKeyMapper(this.keyDataConversion), keyToStorage, keyToStorage);
    }

    @Override
    public CacheSet<Map.Entry<K, V>> entrySet() {
        EncoderEntryMapper entryMapper = EncoderEntryMapper.newEntryMapper(this.keyDataConversion, this.valueDataConversion, this.entryFactory);
        return new WriteableCacheSetMapper(super.entrySet(), entryMapper, e -> new EntryWrapper(e, entryMapper.apply(e)), this::toEntry, this::keyToStorage);
    }

    Map.Entry<K, V> toEntry(Object o) {
        if (o instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            K newKey = this.keyToStorage(key);
            Object value = entry.getValue();
            V newValue = this.valueToStorage(value);
            if (key != newKey || value != newValue) {
                return new AbstractMap.SimpleEntry<K, V>(newKey, newValue);
            }
            return entry;
        }
        return null;
    }

    CacheEntry<K, V> toCacheEntry(Object o) {
        if (o instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            K newKey = this.keyToStorage(key);
            Object value = entry.getValue();
            V newValue = this.valueToStorage(value);
            if (key != newKey || value != newValue) {
                if (o instanceof CacheEntry) {
                    CacheEntry returned = (CacheEntry)o;
                    return this.convertEntry(newKey, newValue, returned);
                }
                return this.entryFactory.create(newKey, newValue, (Metadata)null);
            }
            if (entry instanceof CacheEntry) {
                return (CacheEntry)entry;
            }
            return this.entryFactory.create(key, value, (Metadata)null);
        }
        return null;
    }

    @Override
    public CacheCollection<V> values() {
        return new WriteableCacheCollectionMapper<Object, Object>(super.values(), new EncoderValueMapper(this.valueDataConversion), this::valueToStorage, this::keyToStorage);
    }

    @Override
    public CompletableFuture<V> getAsync(K key) {
        return super.getAsync(this.keyToStorage(key)).thenApply(this.decodedValueForRead);
    }

    @Override
    public void addListener(Object listener) {
        CompletionStages.join(this.addListenerAsync(listener));
    }

    @Override
    public CompletionStage<Void> addListenerAsync(Object listener) {
        Cache unwrapped = EncoderCache.unwrapCache(this.cache);
        if (unwrapped instanceof CacheImpl) {
            ListenerHolder listenerHolder = new ListenerHolder(listener, this.keyDataConversion, this.valueDataConversion, false);
            return ((CacheImpl)unwrapped).addListenerAsync(listenerHolder);
        }
        return super.addListenerAsync(listener);
    }

    @Override
    public <C> void addListener(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter) {
        CompletionStages.join(this.addListenerAsync(listener, filter, converter));
    }

    @Override
    public <C> CompletionStage<Void> addListenerAsync(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter) {
        Cache unwrapped = EncoderCache.unwrapCache(this.cache);
        if (unwrapped instanceof CacheImpl) {
            ListenerHolder listenerHolder = new ListenerHolder(listener, this.keyDataConversion, this.valueDataConversion, false);
            return ((CacheImpl)unwrapped).addListenerAsync(listenerHolder, filter, converter);
        }
        return super.addListenerAsync(listener);
    }

    @Override
    public <C> void addFilteredListener(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        CompletionStages.join(this.addFilteredListenerAsync(listener, filter, converter, filterAnnotations));
    }

    @Override
    public <C> CompletionStage<Void> addFilteredListenerAsync(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        Cache unwrapped = EncoderCache.unwrapCache(this.cache);
        if (unwrapped instanceof CacheImpl) {
            ListenerHolder listenerHolder = new ListenerHolder(listener, this.keyDataConversion, this.valueDataConversion, false);
            return ((CacheImpl)unwrapped).addFilteredListenerAsync(listenerHolder, filter, converter, filterAnnotations);
        }
        return super.addFilteredListenerAsync(listener, filter, converter, filterAnnotations);
    }

    @Override
    public <C> void addStorageFormatFilteredListener(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        CompletionStages.join(this.addStorageFormatFilteredListenerAsync(listener, filter, converter, filterAnnotations));
    }

    @Override
    public <C> CompletionStage<Void> addStorageFormatFilteredListenerAsync(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        Cache unwrapped = EncoderCache.unwrapCache(this.cache);
        if (unwrapped instanceof CacheImpl) {
            ListenerHolder listenerHolder = new ListenerHolder(listener, this.keyDataConversion, this.valueDataConversion, true);
            return ((CacheImpl)unwrapped).addFilteredListenerAsync(listenerHolder, filter, converter, filterAnnotations);
        }
        return super.addFilteredListenerAsync(listener, filter, converter, filterAnnotations);
    }

    private BiFunctionMapper wrapBiFunction(BiFunction<?, ?, ?> biFunction) {
        return biFunction == null ? null : new BiFunctionMapper(biFunction, this.keyDataConversion, this.valueDataConversion);
    }

    private FunctionMapper wrapFunction(Function<?, ?> function) {
        return function == null ? null : new FunctionMapper(function, this.keyDataConversion, this.valueDataConversion);
    }

    private class CacheEntryWrapper<A, B>
    extends ForwardingCacheEntry<A, B> {
        private final CacheEntry<A, B> previousEntry;
        private final CacheEntry<A, B> entry;

        CacheEntryWrapper(CacheEntry<A, B> previousEntry, CacheEntry<A, B> entry) {
            this.previousEntry = previousEntry;
            this.entry = entry;
        }

        @Override
        protected CacheEntry<A, B> delegate() {
            return this.entry;
        }

        @Override
        public B setValue(B value) {
            this.previousEntry.setValue(EncoderCache.this.valueToStorage(value));
            return super.setValue(value);
        }
    }

    private class EntryWrapper<A, B>
    implements Map.Entry<A, B> {
        private final Map.Entry<A, B> storageEntry;
        private final Map.Entry<A, B> entry;

        EntryWrapper(Map.Entry<A, B> storageEntry, Map.Entry<A, B> entry) {
            this.storageEntry = storageEntry;
            this.entry = entry;
        }

        @Override
        public A getKey() {
            return this.entry.getKey();
        }

        @Override
        public B getValue() {
            return this.entry.getValue();
        }

        @Override
        public B setValue(B value) {
            this.storageEntry.setValue(EncoderCache.this.valueToStorage(value));
            return this.entry.setValue(value);
        }

        public String toString() {
            return "EntryWrapper{key=" + this.entry.getKey() + ", value=" + this.entry.getValue() + "}";
        }
    }
}

