/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.credential;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.keycloak.common.util.reflections.Types;
import org.keycloak.credential.CredentialAuthentication;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialInputUpdater;
import org.keycloak.credential.CredentialInputValidator;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.CredentialProviderFactory;
import org.keycloak.credential.UserCredentialStore;
import org.keycloak.models.CredentialValidationOutput;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialManager;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserFederationProvider;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.cache.CachedUserModel;
import org.keycloak.models.cache.OnUserCache;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStorageManager;
import org.keycloak.storage.UserStorageProvider;

public class UserCredentialStoreManager
implements UserCredentialManager,
OnUserCache {
    protected KeycloakSession session;

    public UserCredentialStoreManager(KeycloakSession session) {
        this.session = session;
    }

    protected UserCredentialStore getStoreForUser(UserModel user) {
        if (StorageId.isLocalStorage((UserModel)user)) {
            return (UserCredentialStore)this.session.userLocalStorage();
        }
        return (UserCredentialStore)this.session.userFederatedStorage();
    }

    public void updateCredential(RealmModel realm, UserModel user, CredentialModel cred) {
        this.getStoreForUser(user).updateCredential(realm, user, cred);
    }

    public CredentialModel createCredential(RealmModel realm, UserModel user, CredentialModel cred) {
        return this.getStoreForUser(user).createCredential(realm, user, cred);
    }

    public boolean removeStoredCredential(RealmModel realm, UserModel user, String id) {
        return this.getStoreForUser(user).removeStoredCredential(realm, user, id);
    }

    public CredentialModel getStoredCredentialById(RealmModel realm, UserModel user, String id) {
        return this.getStoreForUser(user).getStoredCredentialById(realm, user, id);
    }

    public List<CredentialModel> getStoredCredentials(RealmModel realm, UserModel user) {
        return this.getStoreForUser(user).getStoredCredentials(realm, user);
    }

    public List<CredentialModel> getStoredCredentialsByType(RealmModel realm, UserModel user, String type) {
        return this.getStoreForUser(user).getStoredCredentialsByType(realm, user, type);
    }

    public CredentialModel getStoredCredentialByNameAndType(RealmModel realm, UserModel user, String name, String type) {
        return this.getStoreForUser(user).getStoredCredentialByNameAndType(realm, user, name, type);
    }

    public boolean isValid(RealmModel realm, UserModel user, CredentialInput ... inputs) {
        return this.isValid(realm, user, Arrays.asList(inputs));
    }

    public boolean isValid(RealmModel realm, UserModel user, List<CredentialInput> inputs) {
        UserStorageProvider provider;
        LinkedList<CredentialInput> toValidate = new LinkedList<CredentialInput>();
        toValidate.addAll(inputs);
        if (!StorageId.isLocalStorage((UserModel)user)) {
            String providerId = StorageId.resolveProviderId((UserModel)user);
            provider = UserStorageManager.getStorageProvider(this.session, realm, providerId);
            if (provider instanceof CredentialInputValidator) {
                Iterator it = toValidate.iterator();
                while (it.hasNext()) {
                    CredentialInputValidator validator = (CredentialInputValidator)provider;
                    CredentialInput input = (CredentialInput)it.next();
                    if (!validator.supportsCredentialType(input.getType()) || !validator.isValid(realm, user, input)) continue;
                    it.remove();
                }
            }
        } else {
            UserFederationProvider link = this.session.users().getFederationLink(realm, user);
            if (link != null) {
                this.session.users().validateUser(realm, user);
                this.validate(realm, user, toValidate, (CredentialInputValidator)link);
            } else if (user.getFederationLink() != null && (provider = UserStorageManager.getStorageProvider(this.session, realm, user.getFederationLink())) != null && provider instanceof CredentialInputValidator) {
                this.validate(realm, user, toValidate, (CredentialInputValidator)provider);
            }
        }
        if (toValidate.isEmpty()) {
            return true;
        }
        List<CredentialInputValidator> credentialProviders = this.getCredentialProviders(realm, CredentialInputValidator.class);
        for (CredentialInputValidator validator : credentialProviders) {
            this.validate(realm, user, toValidate, validator);
        }
        return toValidate.isEmpty();
    }

    private void validate(RealmModel realm, UserModel user, List<CredentialInput> toValidate, CredentialInputValidator validator) {
        Iterator<CredentialInput> it = toValidate.iterator();
        while (it.hasNext()) {
            CredentialInput input = it.next();
            if (!validator.supportsCredentialType(input.getType()) || !validator.isValid(realm, user, input)) continue;
            it.remove();
        }
    }

    protected <T> List<T> getCredentialProviders(RealmModel realm, Class<T> type) {
        LinkedList<Provider> list = new LinkedList<Provider>();
        for (ProviderFactory f : this.session.getKeycloakSessionFactory().getProviderFactories(CredentialProvider.class)) {
            if (!Types.supports(CredentialInputUpdater.class, (Object)f, CredentialProviderFactory.class)) continue;
            list.add(this.session.getProvider(CredentialProvider.class, f.getId()));
        }
        return list;
    }

    public void updateCredential(RealmModel realm, UserModel user, CredentialInput input) {
        UserFederationProvider link;
        CredentialInputUpdater updater2;
        String providerId;
        UserStorageProvider provider;
        if (!StorageId.isLocalStorage((UserModel)user) ? (provider = UserStorageManager.getStorageProvider(this.session, realm, providerId = StorageId.resolveProviderId((UserModel)user))) instanceof CredentialInputUpdater && (updater2 = (CredentialInputUpdater)provider).supportsCredentialType(input.getType()) && updater2.updateCredential(realm, user, input) : ((link = this.session.users().getFederationLink(realm, user)) != null ? link.updateCredential(realm, user, input) : user.getFederationLink() != null && (provider = UserStorageManager.getStorageProvider(this.session, realm, user.getFederationLink())) != null && provider instanceof CredentialInputUpdater && ((CredentialInputUpdater)provider).updateCredential(realm, user, input))) {
            return;
        }
        List<CredentialInputUpdater> credentialProviders = this.getCredentialProviders(realm, CredentialInputUpdater.class);
        for (CredentialInputUpdater updater2 : credentialProviders) {
            if (!updater2.supportsCredentialType(input.getType()) || !updater2.updateCredential(realm, user, input)) continue;
            return;
        }
    }

    public void disableCredential(RealmModel realm, UserModel user, String credentialType) {
        UserStorageProvider provider;
        if (!StorageId.isLocalStorage((UserModel)user)) {
            CredentialInputUpdater updater;
            String providerId = StorageId.resolveProviderId((UserModel)user);
            provider = UserStorageManager.getStorageProvider(this.session, realm, providerId);
            if (provider instanceof CredentialInputUpdater && (updater = (CredentialInputUpdater)provider).supportsCredentialType(credentialType)) {
                updater.disableCredentialType(realm, user, credentialType);
            }
        } else {
            UserFederationProvider link = this.session.users().getFederationLink(realm, user);
            if (link != null && link.getSupportedCredentialTypes().contains(credentialType)) {
                link.disableCredentialType(realm, user, credentialType);
            } else if (user.getFederationLink() != null && (provider = UserStorageManager.getStorageProvider(this.session, realm, user.getFederationLink())) != null && provider instanceof CredentialInputUpdater) {
                ((CredentialInputUpdater)provider).disableCredentialType(realm, user, credentialType);
            }
        }
        List<CredentialInputUpdater> credentialProviders = this.getCredentialProviders(realm, CredentialInputUpdater.class);
        for (CredentialInputUpdater updater : credentialProviders) {
            if (!updater.supportsCredentialType(credentialType)) continue;
            updater.disableCredentialType(realm, user, credentialType);
        }
    }

    public boolean isConfiguredFor(RealmModel realm, UserModel user, String type) {
        UserFederationProvider link;
        CredentialInputValidator validator;
        String providerId;
        UserStorageProvider provider;
        if (!StorageId.isLocalStorage((UserModel)user) ? (provider = UserStorageManager.getStorageProvider(this.session, realm, providerId = StorageId.resolveProviderId((UserModel)user))) instanceof CredentialInputValidator && (validator = (CredentialInputValidator)provider).supportsCredentialType(type) && validator.isConfiguredFor(realm, user, type) : ((link = this.session.users().getFederationLink(realm, user)) != null ? link.isConfiguredFor(realm, user, type) : user.getFederationLink() != null && (provider = UserStorageManager.getStorageProvider(this.session, realm, user.getFederationLink())) != null && provider instanceof CredentialInputValidator && ((CredentialInputValidator)provider).isConfiguredFor(realm, user, type))) {
            return true;
        }
        return this.isConfiguredLocally(realm, user, type);
    }

    public boolean isConfiguredLocally(RealmModel realm, UserModel user, String type) {
        List<CredentialInputValidator> credentialProviders = this.getCredentialProviders(realm, CredentialInputValidator.class);
        for (CredentialInputValidator validator : credentialProviders) {
            if (!validator.supportsCredentialType(type) || !validator.isConfiguredFor(realm, user, type)) continue;
            return true;
        }
        return false;
    }

    public CredentialValidationOutput authenticate(KeycloakSession session, RealmModel realm, CredentialInput input) {
        CredentialValidationOutput output;
        List fedProviderModels = realm.getUserFederationProviders();
        ArrayList fedProviders = new ArrayList();
        for (UserFederationProviderModel fedProviderModel : fedProviderModels) {
            UserFederationProvider provider = session.users().getFederationProvider(fedProviderModel);
            if (!(input instanceof UserCredentialModel) || provider == null || !provider.supportsCredentialType(input.getType()) || (output = provider.validCredentials(realm, (UserCredentialModel)input)) == null) continue;
            return output;
        }
        List<CredentialAuthentication> list = UserStorageManager.getStorageProviders(session, realm, CredentialAuthentication.class);
        for (CredentialAuthentication auth : list) {
            if (!auth.supportsCredentialAuthenticationFor(input.getType()) || (output = auth.authenticate(realm, input)) == null) continue;
            return output;
        }
        list = this.getCredentialProviders(realm, CredentialAuthentication.class);
        for (CredentialAuthentication auth : list) {
            if (!auth.supportsCredentialAuthenticationFor(input.getType()) || (output = auth.authenticate(realm, input)) == null) continue;
            return output;
        }
        return null;
    }

    public void onCache(RealmModel realm, CachedUserModel user, UserModel delegate) {
        List<OnUserCache> credentialProviders = this.getCredentialProviders(realm, OnUserCache.class);
        for (OnUserCache validator : credentialProviders) {
            validator.onCache(realm, user, delegate);
        }
    }

    public void close() {
    }
}

