/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.mappers;

import java.util.ArrayDeque;
import java.util.LinkedHashSet;
import java.util.Set;
import org.keycloak.models.RoleModel;
import org.keycloak.protocol.oidc.mappers.AbstractOIDCProtocolMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenMapper;
import org.keycloak.protocol.oidc.mappers.OIDCIDTokenMapper;
import org.keycloak.protocol.oidc.mappers.UserInfoTokenMapper;

abstract class AbstractUserRoleMappingMapper
extends AbstractOIDCProtocolMapper
implements OIDCAccessTokenMapper,
OIDCIDTokenMapper,
UserInfoTokenMapper {
    AbstractUserRoleMappingMapper() {
    }

    protected Set<String> flattenRoleModelToRoleNames(Set<RoleModel> roleModels, String prefix) {
        LinkedHashSet<String> roleNames = new LinkedHashSet<String>();
        ArrayDeque<RoleModel> stack = new ArrayDeque<RoleModel>(roleModels);
        while (!stack.isEmpty()) {
            RoleModel current = (RoleModel)stack.pop();
            if (current.isComposite()) {
                for (RoleModel compositeRoleModel : current.getComposites()) {
                    stack.push(compositeRoleModel);
                }
            }
            String roleName = current.getName();
            if (prefix != null && !prefix.trim().isEmpty()) {
                roleName = prefix.trim() + roleName;
            }
            roleNames.add(roleName);
        }
        return roleNames;
    }
}

