/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.scripting;

import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.keycloak.models.ScriptModel;
import org.keycloak.scripting.InvocableScriptAdapter;
import org.keycloak.scripting.Script;
import org.keycloak.scripting.ScriptBindingsConfigurer;
import org.keycloak.scripting.ScriptingProvider;

public class DefaultScriptingProvider
implements ScriptingProvider {
    private final ScriptEngineManager scriptEngineManager;

    public DefaultScriptingProvider(ScriptEngineManager scriptEngineManager) {
        if (scriptEngineManager == null) {
            throw new IllegalStateException("scriptEngineManager must not be null!");
        }
        this.scriptEngineManager = scriptEngineManager;
    }

    public InvocableScriptAdapter prepareInvocableScript(ScriptModel scriptModel, ScriptBindingsConfigurer bindingsConfigurer) {
        if (scriptModel == null) {
            throw new IllegalArgumentException("script must not be null");
        }
        if (scriptModel.getCode() == null || scriptModel.getCode().trim().isEmpty()) {
            throw new IllegalArgumentException("script must not be null or empty");
        }
        if (bindingsConfigurer == null) {
            throw new IllegalArgumentException("bindingsConfigurer must not be null");
        }
        ScriptEngine engine = this.createPreparedScriptEngine(scriptModel, bindingsConfigurer);
        return new InvocableScriptAdapter(scriptModel, engine);
    }

    public ScriptModel createScript(String realmId, String mimeType, String scriptName, String scriptCode, String scriptDescription) {
        Script script = new Script(null, realmId, scriptName, mimeType, scriptCode, scriptDescription);
        return script;
    }

    private ScriptEngine createPreparedScriptEngine(ScriptModel script, ScriptBindingsConfigurer bindingsConfigurer) {
        ScriptEngine scriptEngine = this.lookupScriptEngineFor(script);
        if (scriptEngine == null) {
            throw new IllegalStateException("Could not find ScriptEngine for script: " + script);
        }
        this.configureBindings(bindingsConfigurer, scriptEngine);
        return scriptEngine;
    }

    private void configureBindings(ScriptBindingsConfigurer bindingsConfigurer, ScriptEngine engine) {
        Bindings bindings = engine.createBindings();
        bindingsConfigurer.configureBindings(bindings);
        engine.setBindings(bindings, 100);
    }

    private ScriptEngine lookupScriptEngineFor(ScriptModel script) {
        return this.scriptEngineManager.getEngineByMimeType(script.getMimeType());
    }

    public void close() {
    }
}

