/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.NotFoundException;
import org.keycloak.common.ClientConnection;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.AdminRoot;
import org.keycloak.services.resources.admin.RealmAuth;

public class ComponentResource {
    protected static final Logger logger = Logger.getLogger(ComponentResource.class);
    protected RealmModel realm;
    private RealmAuth auth;
    private AdminEventBuilder adminEvent;
    @Context
    protected ClientConnection clientConnection;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected KeycloakSession session;
    @Context
    protected HttpHeaders headers;

    public ComponentResource(RealmModel realm, RealmAuth auth, AdminEventBuilder adminEvent) {
        this.auth = auth;
        this.realm = realm;
        this.adminEvent = adminEvent;
        auth.init(RealmAuth.Resource.USER);
    }

    @GET
    @Produces(value={"application/json"})
    public List<ComponentRepresentation> getComponents(@QueryParam(value="parent") String parent, @QueryParam(value="type") String type) {
        this.auth.requireView();
        List components = Collections.EMPTY_LIST;
        components = parent == null && type == null ? this.realm.getComponents() : (type == null ? this.realm.getComponents(parent) : (parent == null ? this.realm.getComponents(this.realm.getId(), type) : this.realm.getComponents(parent, type)));
        LinkedList<ComponentRepresentation> reps = new LinkedList<ComponentRepresentation>();
        for (ComponentModel component : components) {
            ComponentRepresentation rep = ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (ComponentModel)component, (boolean)false);
            reps.add(rep);
        }
        return reps;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response create(ComponentRepresentation rep) {
        this.auth.requireManage();
        try {
            ComponentModel model = RepresentationToModel.toModel((KeycloakSession)this.session, (ComponentRepresentation)rep);
            if (model.getParentId() == null) {
                model.setParentId(this.realm.getId());
            }
            model = this.realm.addComponentModel(model);
            this.adminEvent.operation(OperationType.CREATE).resourcePath(this.uriInfo, model.getId()).representation(rep).success();
            return Response.created((URI)this.uriInfo.getAbsolutePathBuilder().path(model.getId()).build(new Object[0])).build();
        }
        catch (ComponentValidationException e) {
            return this.localizedErrorResponse(e);
        }
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public ComponentRepresentation getComponent(@PathParam(value="id") String id) {
        this.auth.requireManage();
        ComponentModel model = this.realm.getComponent(id);
        if (model == null) {
            throw new NotFoundException("Could not find component");
        }
        return ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (ComponentModel)model, (boolean)false);
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    public Response updateComponent(@PathParam(value="id") String id, ComponentRepresentation rep) {
        this.auth.requireManage();
        try {
            ComponentModel model = this.realm.getComponent(id);
            if (model == null) {
                throw new NotFoundException("Could not find component");
            }
            RepresentationToModel.updateComponent((KeycloakSession)this.session, (ComponentRepresentation)rep, (ComponentModel)model, (boolean)false);
            this.adminEvent.operation(OperationType.UPDATE).resourcePath(this.uriInfo, model.getId()).representation(rep).success();
            this.realm.updateComponent(model);
            return Response.noContent().build();
        }
        catch (ComponentValidationException e) {
            return this.localizedErrorResponse(e);
        }
    }

    @DELETE
    @Path(value="{id}")
    public void removeComponent(@PathParam(value="id") String id) {
        this.auth.requireManage();
        ComponentModel model = this.realm.getComponent(id);
        if (model == null) {
            throw new NotFoundException("Could not find component");
        }
        this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo, model.getId()).success();
        this.realm.removeComponent(model);
    }

    private Response localizedErrorResponse(ComponentValidationException cve) {
        Properties messages = AdminRoot.getMessages(this.session, this.realm, "admin-messages", this.auth.getAuth().getToken().getLocale());
        Object[] localizedParameters = cve.getParameters() == null ? null : Arrays.asList(cve.getParameters()).stream().map(parameter -> {
            if (parameter instanceof String) {
                String paramStr = (String)parameter;
                return messages.getProperty(paramStr, paramStr);
            }
            return parameter;
        }).toArray();
        String message = MessageFormat.format(messages.getProperty(cve.getMessage(), cve.getMessage()), localizedParameters);
        return ErrorResponse.error(message, Response.Status.BAD_REQUEST);
    }
}

