/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.util.QValueParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class LocaleUtils {
    public static Locale getLocaleFromString(String localeString) {
        if (localeString == null) {
            return null;
        }
        String[] parts = localeString.split("-");
        if (parts.length == 0) {
            return null;
        }
        if (parts.length == 1) {
            return new Locale(localeString, "");
        }
        if (parts.length == 2) {
            return new Locale(parts[0], parts[1]);
        }
        return new Locale(parts[0], parts[1], parts[2]);
    }

    public static List<Locale> getLocalesFromHeader(String acceptLanguage) {
        if (acceptLanguage == null) {
            return Collections.emptyList();
        }
        return LocaleUtils.getLocalesFromHeader(Collections.singletonList(acceptLanguage));
    }

    public static List<Locale> getLocalesFromHeader(List<String> acceptLanguage) {
        if (acceptLanguage == null || acceptLanguage.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Locale> ret = new ArrayList<Locale>();
        List<List<QValueParser.QValueResult>> parsedResults = QValueParser.parse(acceptLanguage);
        for (List<QValueParser.QValueResult> qvalueResult : parsedResults) {
            for (QValueParser.QValueResult res : qvalueResult) {
                if (res.isQValueZero()) continue;
                Locale e = LocaleUtils.getLocaleFromString(res.getValue());
                ret.add(e);
            }
        }
        return ret;
    }
}

