/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.batch.operations.JobOperator;
import javax.batch.runtime.BatchRuntime;
import javax.enterprise.inject.spi.BeanManager;
import javax.transaction.TransactionManager;
import org.jberet.repository.JobRepository;
import org.jberet.spi.ArtifactFactory;
import org.jberet.spi.BatchEnvironment;
import org.jberet.spi.JobExecutor;
import org.jberet.spi.JobTask;
import org.jberet.spi.JobXmlResolver;
import org.jboss.as.server.suspend.ServerActivity;
import org.jboss.as.server.suspend.ServerActivityCallback;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.batch.jberet.BatchConfiguration;
import org.wildfly.extension.batch.jberet._private.BatchLogger;
import org.wildfly.extension.batch.jberet.impl.ClassLoaderContextHandle;
import org.wildfly.extension.batch.jberet.impl.ContextHandle;
import org.wildfly.extension.batch.jberet.impl.NamespaceContextHandle;
import org.wildfly.extension.batch.jberet.impl.SecurityContextHandle;
import org.wildfly.extension.batch.jberet.impl.WildFlyArtifactFactory;
import org.wildfly.extension.requestcontroller.ControlPoint;
import org.wildfly.extension.requestcontroller.RequestController;
import org.wildfly.jberet.BatchEnvironmentFactory;
import org.wildfly.security.manager.WildFlySecurityManager;

public class BatchEnvironmentService
implements Service<BatchEnvironment> {
    private static final Properties PROPS = new Properties();
    private static final Properties RESTART_PROPS = new Properties();
    private final InjectedValue<BeanManager> beanManagerInjector = new InjectedValue();
    private final InjectedValue<JobExecutor> jobExecutorInjector = new InjectedValue();
    private final InjectedValue<TransactionManager> transactionManagerInjector = new InjectedValue();
    private final InjectedValue<RequestController> requestControllerInjector = new InjectedValue();
    private final InjectedValue<JobRepository> jobRepositoryInjector = new InjectedValue();
    private final InjectedValue<ExecutorService> executorInjector = new InjectedValue();
    private final InjectedValue<SuspendController> suspendControllerInjector = new InjectedValue();
    private final InjectedValue<BatchConfiguration> batchConfigurationInjector = new InjectedValue();
    private final ClassLoader classLoader;
    private final JobXmlResolver jobXmlResolver;
    private final String deploymentName;
    private final BatchJobServerActivity serverActivity;
    private final Boolean restartJobsOnResume;
    private BatchEnvironment batchEnvironment = null;
    private ControlPoint controlPoint;

    public BatchEnvironmentService(ClassLoader classLoader, JobXmlResolver jobXmlResolver, String deploymentName) {
        this(classLoader, jobXmlResolver, deploymentName, null);
    }

    public BatchEnvironmentService(ClassLoader classLoader, JobXmlResolver jobXmlResolver, String deploymentName, Boolean restartJobsOnResume) {
        this.classLoader = classLoader;
        this.jobXmlResolver = jobXmlResolver;
        this.deploymentName = deploymentName;
        this.serverActivity = new BatchJobServerActivity();
        this.restartJobsOnResume = restartJobsOnResume;
    }

    public synchronized void start(StartContext context) throws StartException {
        JobRepository jobRepository;
        BatchLogger.LOGGER.debugf("Creating batch environment; %s", this.classLoader);
        ((SuspendController)this.suspendControllerInjector.getValue()).registerActivity((ServerActivity)this.serverActivity);
        RequestController requestController = (RequestController)this.requestControllerInjector.getOptionalValue();
        this.controlPoint = requestController != null ? requestController.getControlPoint(this.deploymentName, "batch-executor-service") : null;
        BatchConfiguration batchConfiguration = (BatchConfiguration)this.batchConfigurationInjector.getValue();
        JobExecutor jobExecutor = (JobExecutor)this.jobExecutorInjector.getOptionalValue();
        if (jobExecutor == null) {
            jobExecutor = batchConfiguration.getDefaultJobExecutor();
        }
        if ((jobRepository = (JobRepository)this.jobRepositoryInjector.getOptionalValue()) == null) {
            jobRepository = batchConfiguration.getDefaultJobRepository();
        }
        WildFlyBatchEnvironment batchEnvironment = new WildFlyBatchEnvironment((BeanManager)this.beanManagerInjector.getOptionalValue(), jobExecutor, (TransactionManager)this.transactionManagerInjector.getValue(), jobRepository, this.jobXmlResolver, this.controlPoint);
        BatchEnvironmentFactory.getInstance().add(this.classLoader, (BatchEnvironment)batchEnvironment);
        this.batchEnvironment = batchEnvironment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(StopContext context) {
        BatchLogger.LOGGER.debugf("Removing batch environment; %s", this.classLoader);
        ((SuspendController)this.suspendControllerInjector.getValue()).unRegisterActivity((ServerActivity)this.serverActivity);
        ExecutorService service = (ExecutorService)this.executorInjector.getValue();
        Runnable task = () -> {
            this.serverActivity.stopRunningJobs(false);
            BatchEnvironmentFactory.getInstance().remove(this.classLoader);
            this.batchEnvironment = null;
            if (this.controlPoint != null) {
                ((RequestController)this.requestControllerInjector.getValue()).removeControlPoint(this.controlPoint);
            }
            context.complete();
        };
        try {
            service.execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    public synchronized BatchEnvironment getValue() throws IllegalStateException, IllegalArgumentException {
        return this.batchEnvironment;
    }

    public InjectedValue<BeanManager> getBeanManagerInjector() {
        return this.beanManagerInjector;
    }

    public InjectedValue<JobExecutor> getJobExecutorInjector() {
        return this.jobExecutorInjector;
    }

    public InjectedValue<TransactionManager> getTransactionManagerInjector() {
        return this.transactionManagerInjector;
    }

    public InjectedValue<RequestController> getRequestControllerInjector() {
        return this.requestControllerInjector;
    }

    public InjectedValue<JobRepository> getJobRepositoryInjector() {
        return this.jobRepositoryInjector;
    }

    public Injector<ExecutorService> getExecutorServiceInjector() {
        return this.executorInjector;
    }

    public InjectedValue<SuspendController> getSuspendControllerInjector() {
        return this.suspendControllerInjector;
    }

    public InjectedValue<BatchConfiguration> getBatchConfigurationInjector() {
        return this.batchConfigurationInjector;
    }

    private class BatchJobServerActivity
    implements ServerActivity {
        private final AtomicBoolean jobsStopped = new AtomicBoolean(false);
        private final AtomicBoolean jobsRestarted = new AtomicBoolean(false);
        private final Collection<Long> stoppedIds = Collections.synchronizedCollection(new ArrayList());

        private BatchJobServerActivity() {
        }

        public void preSuspend(ServerActivityCallback serverActivityCallback) {
            serverActivityCallback.done();
        }

        public void suspended(ServerActivityCallback serverActivityCallback) {
            try {
                this.stopRunningJobs(this.isRestartOnResume());
            }
            finally {
                serverActivityCallback.done();
            }
        }

        public void resume() {
            this.restartStoppedJobs();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopRunningJobs(boolean queueForRestart) {
            if (this.jobsStopped.compareAndSet(false, true)) {
                ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
                try {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)BatchEnvironmentService.this.classLoader);
                    JobOperator jobOperator = BatchRuntime.getJobOperator();
                    Collection<String> jobNames = this.getJobNames(jobOperator);
                    for (String jobName : jobNames) {
                        List runningJobs = jobOperator.getRunningExecutions(jobName);
                        for (Long id : runningJobs) {
                            try {
                                BatchLogger.LOGGER.stoppingJob(id, jobName, BatchEnvironmentService.this.deploymentName);
                                jobOperator.stop(id.longValue());
                                if (!queueForRestart) continue;
                                this.stoppedIds.add(id);
                            }
                            catch (Exception e) {
                                BatchLogger.LOGGER.stoppingJobFailed(e, id, jobName, BatchEnvironmentService.this.deploymentName);
                            }
                        }
                    }
                }
                finally {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
                    this.jobsStopped.set(false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void restartStoppedJobs() {
            if (this.isRestartOnResume() && this.jobsRestarted.compareAndSet(false, true)) {
                ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
                try {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)BatchEnvironmentService.this.classLoader);
                    ArrayList<Long> ids = new ArrayList<Long>();
                    Collection<Long> collection = this.stoppedIds;
                    synchronized (collection) {
                        ids.addAll(this.stoppedIds);
                        this.stoppedIds.clear();
                    }
                    JobOperator jobOperator = BatchRuntime.getJobOperator();
                    for (Long id : ids) {
                        String jobName = null;
                        try {
                            jobName = jobOperator.getJobInstance(id.longValue()).getJobName();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            long newId = jobOperator.restart(id.longValue(), RESTART_PROPS);
                            BatchLogger.LOGGER.restartingJob(jobName, id, newId);
                        }
                        catch (Exception e) {
                            BatchLogger.LOGGER.failedRestartingJob(e, id, jobName, BatchEnvironmentService.this.deploymentName);
                        }
                    }
                }
                finally {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
                    this.jobsRestarted.set(false);
                }
            }
        }

        private Collection<String> getJobNames(JobOperator jobOperator) {
            Set knownJobNames = jobOperator.getJobNames();
            return BatchEnvironmentService.this.jobXmlResolver.getJobXmlNames(BatchEnvironmentService.this.classLoader).stream().map(xmlName -> BatchEnvironmentService.this.jobXmlResolver.resolveJobName(xmlName, BatchEnvironmentService.this.classLoader)).filter(knownJobNames::contains).collect(Collectors.toSet());
        }

        private boolean isRestartOnResume() {
            if (BatchEnvironmentService.this.restartJobsOnResume == null) {
                return ((BatchConfiguration)BatchEnvironmentService.this.batchConfigurationInjector.getValue()).isRestartOnResume();
            }
            return BatchEnvironmentService.this.restartJobsOnResume;
        }
    }

    private class WildFlyBatchEnvironment
    implements BatchEnvironment {
        private final ArtifactFactory artifactFactory;
        private final JobExecutor jobExecutor;
        private final TransactionManager transactionManager;
        private final JobRepository jobRepository;
        private final JobXmlResolver jobXmlResolver;
        private final ControlPoint controlPoint;

        WildFlyBatchEnvironment(BeanManager beanManager, JobExecutor jobExecutor, TransactionManager transactionManager, JobRepository jobRepository, JobXmlResolver jobXmlResolver, ControlPoint controlPoint) {
            this.jobXmlResolver = jobXmlResolver;
            this.artifactFactory = new WildFlyArtifactFactory(beanManager);
            this.jobExecutor = jobExecutor;
            this.transactionManager = transactionManager;
            this.controlPoint = controlPoint;
            this.jobRepository = jobRepository;
        }

        public ClassLoader getClassLoader() {
            return BatchEnvironmentService.this.classLoader;
        }

        public ArtifactFactory getArtifactFactory() {
            return this.artifactFactory;
        }

        public void submitTask(final JobTask jobTask) {
            final ContextHandle contextHandle = this.createContextHandle();
            JobTask task = new JobTask(){

                public int getRequiredRemainingPermits() {
                    return jobTask.getRequiredRemainingPermits();
                }

                public void run() {
                    ContextHandle.Handle handle = contextHandle.setup();
                    try {
                        jobTask.run();
                    }
                    finally {
                        handle.tearDown();
                    }
                }
            };
            if (this.controlPoint == null) {
                this.jobExecutor.execute(task);
            } else {
                this.controlPoint.queueTask((Runnable)task, (Executor)this.jobExecutor, -1L, null, false);
            }
        }

        public TransactionManager getTransactionManager() {
            return this.transactionManager;
        }

        public JobRepository getJobRepository() {
            return this.jobRepository;
        }

        public JobXmlResolver getJobXmlResolver() {
            return this.jobXmlResolver;
        }

        public Properties getBatchConfigurationProperties() {
            return PROPS;
        }

        private ContextHandle createContextHandle() {
            ClassLoader tccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
            ClassLoaderContextHandle classLoaderContextHandle = tccl == null ? new ClassLoaderContextHandle(BatchEnvironmentService.this.classLoader) : new ClassLoaderContextHandle(tccl);
            return new ContextHandle.ChainedContextHandle(classLoaderContextHandle, new NamespaceContextHandle(), new SecurityContextHandle());
        }
    }
}

