/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import javax.jms.MessageListener;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.jms.client.ActiveMQConnection;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSClientLogger;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQSession;

public class JMSMessageListenerWrapper
implements MessageHandler {
    private final ActiveMQConnection connection;
    private final ActiveMQSession session;
    private final MessageListener listener;
    private final ClientConsumer consumer;
    private final boolean transactedOrClientAck;
    private final boolean individualACK;

    protected JMSMessageListenerWrapper(ActiveMQConnection connection, ActiveMQSession session, ClientConsumer consumer, MessageListener listener, int ackMode) {
        this.connection = connection;
        this.session = session;
        this.consumer = consumer;
        this.listener = listener;
        this.transactedOrClientAck = ackMode == 0 || ackMode == 2 || session.isXA();
        this.individualACK = ackMode == 101;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(ClientMessage message) {
        ActiveMQMessage msg = ActiveMQMessage.createMessage(message, this.session.getCoreSession());
        if (this.individualACK) {
            msg.setIndividualAcknowledge();
        }
        try {
            msg.doBeforeReceive();
        }
        catch (Exception e) {
            ActiveMQJMSClientLogger.LOGGER.errorPreparingMessageForReceipt(e);
            return;
        }
        if (this.transactedOrClientAck) {
            try {
                message.acknowledge();
            }
            catch (ActiveMQException e) {
                ActiveMQJMSClientLogger.LOGGER.errorProcessingMessage(e);
            }
        }
        try {
            this.connection.getThreadAwareContext().setCurrentThread(false);
            this.listener.onMessage(msg);
        }
        catch (RuntimeException e) {
            ActiveMQJMSClientLogger.LOGGER.onMessageError(e);
            if (!this.transactedOrClientAck) {
                try {
                    if (this.individualACK) {
                        message.individualAcknowledge();
                    }
                    this.session.getCoreSession().rollback(true);
                    this.session.setRecoverCalled(true);
                }
                catch (Exception e2) {
                    ActiveMQJMSClientLogger.LOGGER.errorRecoveringSession(e2);
                }
            }
        }
        finally {
            this.connection.getThreadAwareContext().clearCurrentThread(false);
        }
        if (!this.session.isRecoverCalled() && !this.individualACK) {
            try {
                if (!this.consumer.isClosed() && !this.transactedOrClientAck) {
                    message.acknowledge();
                }
            }
            catch (ActiveMQException e) {
                ActiveMQJMSClientLogger.LOGGER.errorProcessingMessage(e);
            }
        }
        this.session.setRecoverCalled(false);
    }
}

