/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import org.keycloak.Config;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;

public class MigrationUtils {
    public static void addAdminRole(RealmModel realm, String roleName) {
        RoleModel role;
        ClientModel client = realm.getMasterAdminClient();
        if (client != null && client.getRole(roleName) == null) {
            role = client.addRole(roleName);
            role.setDescription("${role_" + roleName + "}");
            role.setScopeParamRequired(false);
            client.getRealm().getRole(AdminRoles.ADMIN).addCompositeRole(role);
        }
        if (!realm.getName().equals(Config.getAdminRealm()) && (client = realm.getClientByClientId("realm-management")) != null && client.getRole(roleName) == null) {
            role = client.addRole(roleName);
            role.setDescription("${role_" + roleName + "}");
            role.setScopeParamRequired(false);
            client.getRole(AdminRoles.REALM_ADMIN).addCompositeRole(role);
        }
    }

    public static void updateOTPRequiredAction(RequiredActionProviderModel otpAction) {
        if (otpAction == null) {
            return;
        }
        if (!UserModel.RequiredAction.CONFIGURE_TOTP.name().equals(otpAction.getProviderId())) {
            return;
        }
        if (!"Configure Totp".equals(otpAction.getName())) {
            return;
        }
        otpAction.setName("Configure OTP");
    }
}

