/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.KeycloakSession;
import org.keycloak.policy.PasswordPolicyProvider;

public class PasswordPolicy
implements Serializable {
    private String policyString;
    private Map<String, Object> policyConfig;

    public static PasswordPolicy empty() {
        return new PasswordPolicy(null, new HashMap<String, Object>());
    }

    public static PasswordPolicy parse(KeycloakSession session, String policyString) {
        HashMap<String, Object> policyConfig = new HashMap<String, Object>();
        if (policyString != null && !policyString.trim().isEmpty()) {
            for (String policy : policyString.split(" and ")) {
                String key;
                policy = policy.trim();
                String config = null;
                int i = policy.indexOf(40);
                if (i == -1) {
                    key = policy.trim();
                } else {
                    key = policy.substring(0, i).trim();
                    config = policy.substring(i + 1, policy.length() - 1);
                }
                PasswordPolicyProvider provider = session.getProvider(PasswordPolicyProvider.class, key);
                if (provider == null) {
                    throw new IllegalArgumentException("Unsupported policy");
                }
                policyConfig.put(key, provider.parseConfig(config));
            }
        }
        return new PasswordPolicy(policyString, policyConfig);
    }

    private PasswordPolicy(String policyString, Map<String, Object> policyConfig) {
        this.policyString = policyString;
        this.policyConfig = policyConfig;
    }

    public Set<String> getPolicies() {
        return this.policyConfig.keySet();
    }

    public <T> T getPolicyConfig(String key) {
        return (T)this.policyConfig.get(key);
    }

    public String getHashAlgorithm() {
        if (this.policyConfig.containsKey("hashAlgorithm")) {
            return (String)this.getPolicyConfig("hashAlgorithm");
        }
        return "pbkdf2";
    }

    public int getHashIterations() {
        if (this.policyConfig.containsKey("hashIterations")) {
            return (Integer)this.getPolicyConfig("hashIterations");
        }
        return 20000;
    }

    public int getExpiredPasswords() {
        if (this.policyConfig.containsKey("passwordHistory")) {
            return (Integer)this.getPolicyConfig("passwordHistory");
        }
        return -1;
    }

    public int getDaysToExpirePassword() {
        if (this.policyConfig.containsKey("forceExpiredPasswordChange")) {
            return (Integer)this.getPolicyConfig("forceExpiredPasswordChange");
        }
        return -1;
    }

    public String toString() {
        return this.policyString;
    }
}

