/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserFederationProvider;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.services.managers.UserManager;

public class UserFederationManager
implements UserProvider {
    private static final Logger logger = Logger.getLogger(UserFederationManager.class);
    protected KeycloakSession session;
    private Map<String, UserModel> managedUsers = new HashMap<String, UserModel>();

    public UserFederationManager(KeycloakSession session) {
        this.session = session;
    }

    @Override
    public UserModel addUser(RealmModel realm, String id, String username, boolean addDefaultRoles, boolean addDefaultRequiredActions) {
        UserModel user = this.session.userStorage().addUser(realm, id, username.toLowerCase(), addDefaultRoles, addDefaultRequiredActions);
        return this.registerWithFederation(realm, user);
    }

    @Override
    public UserModel addUser(RealmModel realm, String username) {
        UserModel user = this.session.userStorage().addUser(realm, username.toLowerCase());
        return this.registerWithFederation(realm, user);
    }

    protected UserModel registerWithFederation(RealmModel realm, UserModel user) {
        for (UserFederationProviderModel federation : realm.getUserFederationProviders()) {
            UserFederationProvider fed = this.getFederationProvider(federation);
            if (!fed.synchronizeRegistrations()) continue;
            user.setFederationLink(federation.getId());
            UserModel registered = fed.register(realm, user);
            this.managedUsers.put(registered.getId(), registered);
            return registered;
        }
        return user;
    }

    public UserFederationProvider getFederationProvider(UserFederationProviderModel model) {
        return KeycloakModelUtils.getFederationProviderInstance(this.session, model);
    }

    public UserFederationProvider getFederationLink(RealmModel realm, UserModel user) {
        if (user.getFederationLink() == null) {
            return null;
        }
        for (UserFederationProviderModel fed : realm.getUserFederationProviders()) {
            if (!fed.getId().equals(user.getFederationLink())) continue;
            return this.getFederationProvider(fed);
        }
        return null;
    }

    @Override
    public boolean removeUser(RealmModel realm, UserModel user) {
        UserFederationProvider link = this.getFederationLink(realm, user);
        if (link != null) {
            boolean fedRemoved = link.removeUser(realm, user);
            if (fedRemoved) {
                boolean localRemoved = this.session.userStorage().removeUser(realm, user);
                this.managedUsers.remove(user.getId());
                if (!localRemoved) {
                    logger.warn((Object)"User possibly removed from federation provider, but failed to remove him from keycloak model");
                }
                return localRemoved;
            }
            logger.warn((Object)"Failed to remove user from federation provider");
            return false;
        }
        return this.session.userStorage().removeUser(realm, user);
    }

    public void validateUser(RealmModel realm, UserModel user) {
        if (this.managedUsers.containsKey(user.getId())) {
            return;
        }
        UserFederationProvider link = this.getFederationLink(realm, user);
        if (link != null && !link.isValid(realm, user)) {
            this.deleteInvalidUser(realm, user);
            throw new IllegalStateException("Federated user no longer valid");
        }
    }

    protected void deleteInvalidUser(final RealmModel realm, final UserModel user) {
        KeycloakModelUtils.runJobInTransaction(this.session.getKeycloakSessionFactory(), new KeycloakSessionTask(){

            @Override
            public void run(KeycloakSession session) {
                RealmModel realmModel = session.realms().getRealm(realm.getId());
                if (realmModel == null) {
                    return;
                }
                UserModel deletedUser = session.userStorage().getUserById(user.getId(), realmModel);
                new UserManager(session).removeUser(realmModel, deletedUser, session.userStorage());
                logger.debugf("Removed invalid user '%s'", (Object)user.getUsername());
            }
        });
    }

    protected UserModel validateAndProxyUser(RealmModel realm, UserModel user) {
        UserModel managed = this.managedUsers.get(user.getId());
        if (managed != null) {
            return managed;
        }
        UserFederationProvider link = this.getFederationLink(realm, user);
        if (link != null) {
            UserModel validatedProxyUser = link.validateAndProxy(realm, user);
            if (validatedProxyUser != null) {
                this.managedUsers.put(user.getId(), validatedProxyUser);
                return validatedProxyUser;
            }
            this.deleteInvalidUser(realm, user);
            return null;
        }
        return user;
    }

    @Override
    public void addFederatedIdentity(RealmModel realm, UserModel user, FederatedIdentityModel socialLink) {
        this.validateUser(realm, user);
        this.session.userStorage().addFederatedIdentity(realm, user, socialLink);
    }

    @Override
    public void updateFederatedIdentity(RealmModel realm, UserModel federatedUser, FederatedIdentityModel federatedIdentityModel) {
        this.session.userStorage().updateFederatedIdentity(realm, federatedUser, federatedIdentityModel);
    }

    @Override
    public boolean removeFederatedIdentity(RealmModel realm, UserModel user, String socialProvider) {
        this.validateUser(realm, user);
        if (user == null) {
            throw new IllegalStateException("Federated user no longer valid");
        }
        return this.session.userStorage().removeFederatedIdentity(realm, user, socialProvider);
    }

    @Override
    public void addConsent(RealmModel realm, String userId, UserConsentModel consent) {
        this.session.userStorage().addConsent(realm, userId, consent);
    }

    @Override
    public UserConsentModel getConsentByClient(RealmModel realm, String userId, String clientInternalId) {
        return this.session.userStorage().getConsentByClient(realm, userId, clientInternalId);
    }

    @Override
    public List<UserConsentModel> getConsents(RealmModel realm, String userId) {
        return this.session.userStorage().getConsents(realm, userId);
    }

    @Override
    public void updateConsent(RealmModel realm, String userId, UserConsentModel consent) {
        this.session.userStorage().updateConsent(realm, userId, consent);
    }

    @Override
    public boolean revokeConsentForClient(RealmModel realm, String userId, String clientInternalId) {
        return this.session.userStorage().revokeConsentForClient(realm, userId, clientInternalId);
    }

    @Override
    public UserModel getUserById(String id, RealmModel realm) {
        UserModel user = this.session.userStorage().getUserById(id, realm);
        if (user != null) {
            user = this.validateAndProxyUser(realm, user);
        }
        return user;
    }

    @Override
    public List<UserModel> getGroupMembers(RealmModel realm, final GroupModel group, int firstResult, int maxResults) {
        int maxTotal = firstResult + maxResults;
        List<UserModel> localMembers = this.query(new PaginatedQuery(){

            @Override
            public List<UserModel> query(RealmModel realm, int first, int max) {
                return UserFederationManager.this.session.userStorage().getGroupMembers(realm, group, first, max);
            }
        }, realm, 0, maxTotal);
        LinkedHashSet<UserModel> result = new LinkedHashSet<UserModel>(localMembers);
        for (UserFederationProviderModel federation : realm.getUserFederationProviders()) {
            if (result.size() >= maxTotal) break;
            int max = maxTotal - result.size();
            UserFederationProvider fed = this.getFederationProvider(federation);
            List<UserModel> current = fed.getGroupMembers(realm, group, 0, max);
            if (current == null) continue;
            result.addAll(current);
        }
        if (result.size() <= firstResult) {
            return Collections.emptyList();
        }
        int max = Math.min(maxTotal, result.size());
        return new ArrayList<UserModel>(result).subList(firstResult, max);
    }

    @Override
    public List<UserModel> getGroupMembers(RealmModel realm, GroupModel group) {
        return this.getGroupMembers(realm, group, -1, -1);
    }

    @Override
    public UserModel getUserByUsername(String username, RealmModel realm) {
        UserModel user = this.session.userStorage().getUserByUsername(username.toLowerCase(), realm);
        if (user != null && (user = this.validateAndProxyUser(realm, user)) != null) {
            return user;
        }
        for (UserFederationProviderModel federation : realm.getUserFederationProviders()) {
            UserFederationProvider fed = this.getFederationProvider(federation);
            user = fed.getUserByUsername(realm, username);
            if (user == null) continue;
            return user;
        }
        return user;
    }

    @Override
    public UserModel getUserByEmail(String email, RealmModel realm) {
        UserModel user = this.session.userStorage().getUserByEmail(email.toLowerCase(), realm);
        if (user != null && (user = this.validateAndProxyUser(realm, user)) != null) {
            return user;
        }
        for (UserFederationProviderModel federation : realm.getUserFederationProviders()) {
            UserFederationProvider fed = this.getFederationProvider(federation);
            user = fed.getUserByEmail(realm, email);
            if (user == null) continue;
            return user;
        }
        return user;
    }

    @Override
    public UserModel getUserByFederatedIdentity(FederatedIdentityModel socialLink, RealmModel realm) {
        UserModel user = this.session.userStorage().getUserByFederatedIdentity(socialLink, realm);
        if (user != null) {
            user = this.validateAndProxyUser(realm, user);
        }
        return user;
    }

    @Override
    public UserModel getServiceAccount(ClientModel client) {
        UserModel user = this.session.userStorage().getServiceAccount(client);
        if (user != null) {
            user = this.validateAndProxyUser(client.getRealm(), user);
        }
        return user;
    }

    @Override
    public List<UserModel> getUsers(RealmModel realm, boolean includeServiceAccounts) {
        return this.getUsers(realm, 0, 0x7FFFFFFE, includeServiceAccounts);
    }

    @Override
    public List<UserModel> getUsers(RealmModel realm) {
        return this.getUsers(realm, false);
    }

    @Override
    public List<UserModel> getUsers(RealmModel realm, int firstResult, int maxResults) {
        return this.getUsers(realm, firstResult, maxResults, false);
    }

    @Override
    public int getUsersCount(RealmModel realm) {
        return this.session.userStorage().getUsersCount(realm);
    }

    protected List<UserModel> query(PaginatedQuery pagedQuery, RealmModel realm, int firstResult, int maxResults) {
        int added;
        LinkedList<UserModel> results = new LinkedList<UserModel>();
        if (maxResults == 0) {
            return results;
        }
        int first = firstResult;
        int max = maxResults;
        do {
            List<UserModel> query;
            if ((query = pagedQuery.query(realm, first, max)) == null || query.size() == 0) {
                return results;
            }
            added = 0;
            for (UserModel user : query) {
                if ((user = this.validateAndProxyUser(realm, user)) == null) continue;
                results.add(user);
                ++added;
            }
            if (results.size() == maxResults) {
                return results;
            }
            if (query.size() < max) {
                return results;
            }
            first = query.size();
        } while ((max -= added) > 0);
        return results;
    }

    @Override
    public List<UserModel> getUsers(RealmModel realm, int firstResult, int maxResults, final boolean includeServiceAccounts) {
        return this.query(new PaginatedQuery(){

            @Override
            public List<UserModel> query(RealmModel realm, int first, int max) {
                return UserFederationManager.this.session.userStorage().getUsers(realm, first, max, includeServiceAccounts);
            }
        }, realm, firstResult, maxResults);
    }

    @Override
    public List<UserModel> searchForUser(String search, RealmModel realm) {
        return this.searchForUser(search, realm, 0, 0x7FFFFFFE);
    }

    void federationLoad(RealmModel realm, Map<String, String> attributes) {
        for (UserFederationProviderModel federation : realm.getUserFederationProviders()) {
            UserFederationProvider fed = this.getFederationProvider(federation);
            fed.searchByAttributes(attributes, realm, 30);
        }
    }

    @Override
    public List<UserModel> searchForUser(final String search, RealmModel realm, int firstResult, int maxResults) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        int spaceIndex = search.lastIndexOf(32);
        if (spaceIndex > -1) {
            String firstName = search.substring(0, spaceIndex).trim();
            String lastName = search.substring(spaceIndex).trim();
            attributes.put("firstName", firstName);
            attributes.put("lastName", lastName);
        } else if (search.indexOf(64) > -1) {
            attributes.put("username", search.trim().toLowerCase());
            attributes.put("email", search.trim().toLowerCase());
        } else {
            attributes.put("lastName", search.trim());
            attributes.put("username", search.trim().toLowerCase());
        }
        this.federationLoad(realm, attributes);
        return this.query(new PaginatedQuery(){

            @Override
            public List<UserModel> query(RealmModel realm, int first, int max) {
                return UserFederationManager.this.session.userStorage().searchForUser(search, realm, first, max);
            }
        }, realm, firstResult, maxResults);
    }

    @Override
    public List<UserModel> searchForUser(Map<String, String> attributes, RealmModel realm) {
        return this.searchForUser(attributes, realm, 0, 0x7FFFFFFE);
    }

    @Override
    public List<UserModel> searchForUser(final Map<String, String> attributes, RealmModel realm, int firstResult, int maxResults) {
        this.federationLoad(realm, attributes);
        return this.query(new PaginatedQuery(){

            @Override
            public List<UserModel> query(RealmModel realm, int first, int max) {
                return UserFederationManager.this.session.userStorage().searchForUser(attributes, realm, first, max);
            }
        }, realm, firstResult, maxResults);
    }

    @Override
    public List<UserModel> searchForUserByUserAttribute(String attrName, String attrValue, RealmModel realm) {
        return this.session.userStorage().searchForUserByUserAttribute(attrName, attrValue, realm);
    }

    @Override
    public Set<FederatedIdentityModel> getFederatedIdentities(UserModel user, RealmModel realm) {
        this.validateUser(realm, user);
        if (user == null) {
            throw new IllegalStateException("Federated user no longer valid");
        }
        return this.session.userStorage().getFederatedIdentities(user, realm);
    }

    @Override
    public FederatedIdentityModel getFederatedIdentity(UserModel user, String socialProvider, RealmModel realm) {
        this.validateUser(realm, user);
        if (user == null) {
            throw new IllegalStateException("Federated user no longer valid");
        }
        return this.session.userStorage().getFederatedIdentity(user, socialProvider, realm);
    }

    @Override
    public void grantToAllUsers(RealmModel realm, RoleModel role) {
        this.session.userStorage().grantToAllUsers(realm, role);
    }

    @Override
    public void preRemove(RealmModel realm) {
        for (UserFederationProviderModel federation : realm.getUserFederationProviders()) {
            UserFederationProvider fed = this.getFederationProvider(federation);
            fed.preRemove(realm);
        }
        this.session.userStorage().preRemove(realm);
    }

    @Override
    public void preRemove(RealmModel realm, UserFederationProviderModel model) {
        this.session.userStorage().preRemove(realm, model);
    }

    @Override
    public void preRemove(RealmModel realm, GroupModel group) {
        for (UserFederationProviderModel federation : realm.getUserFederationProviders()) {
            UserFederationProvider fed = this.getFederationProvider(federation);
            fed.preRemove(realm, group);
        }
        this.session.userStorage().preRemove(realm, group);
    }

    @Override
    public void preRemove(RealmModel realm, RoleModel role) {
        for (UserFederationProviderModel federation : realm.getUserFederationProviders()) {
            UserFederationProvider fed = this.getFederationProvider(federation);
            fed.preRemove(realm, role);
        }
        this.session.userStorage().preRemove(realm, role);
    }

    @Override
    public void preRemove(RealmModel realm, ClientModel client) {
        this.session.userStorage().preRemove(realm, client);
    }

    @Override
    public void preRemove(ProtocolMapperModel protocolMapper) {
        this.session.userStorage().preRemove(protocolMapper);
    }

    @Override
    public void preRemove(RealmModel realm, ComponentModel component) {
        this.session.userStorage().preRemove(realm, component);
    }

    @Override
    public void close() {
    }

    static interface PaginatedQuery {
        public List<UserModel> query(RealmModel var1, int var2, int var3);
    }
}

