/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.Time;
import org.keycloak.component.ComponentModel;
import org.keycloak.events.Event;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.events.admin.AuthDetails;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserFederationMapperModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.ComponentUtil;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.AuthDetailsRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionExportRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientTemplateRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.ConfigPropertyRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.FederatedIdentityRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmEventsConfigRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserConsentRepresentation;
import org.keycloak.representations.idm.UserFederationMapperRepresentation;
import org.keycloak.representations.idm.UserFederationProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceOwnerRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.util.JsonSerialization;

public class ModelToRepresentation {
    public static void buildGroupPath(StringBuilder sb, GroupModel group) {
        if (group.getParent() != null) {
            ModelToRepresentation.buildGroupPath(sb, group.getParent());
        }
        sb.append('/').append(group.getName());
    }

    public static String buildGroupPath(GroupModel group) {
        StringBuilder sb = new StringBuilder();
        ModelToRepresentation.buildGroupPath(sb, group);
        return sb.toString();
    }

    public static GroupRepresentation toRepresentation(GroupModel group, boolean full) {
        GroupRepresentation rep = new GroupRepresentation();
        rep.setId(group.getId());
        rep.setName(group.getName());
        rep.setPath(ModelToRepresentation.buildGroupPath(group));
        if (!full) {
            return rep;
        }
        Set<RoleModel> roles = group.getRoleMappings();
        ArrayList<String> realmRoleNames = new ArrayList<String>();
        HashMap<String, ArrayList<String>> clientRoleNames = new HashMap<String, ArrayList<String>>();
        for (RoleModel role : roles) {
            if (role.getContainer() instanceof RealmModel) {
                realmRoleNames.add(role.getName());
                continue;
            }
            ClientModel client = (ClientModel)role.getContainer();
            String clientId = client.getClientId();
            ArrayList<String> currentClientRoles = (ArrayList<String>)clientRoleNames.get(clientId);
            if (currentClientRoles == null) {
                currentClientRoles = new ArrayList<String>();
                clientRoleNames.put(clientId, currentClientRoles);
            }
            currentClientRoles.add(role.getName());
        }
        rep.setRealmRoles(realmRoleNames);
        rep.setClientRoles(clientRoleNames);
        Map<String, List<String>> attributes = group.getAttributes();
        rep.setAttributes(attributes);
        return rep;
    }

    public static List<GroupRepresentation> toGroupHierarchy(RealmModel realm, boolean full) {
        LinkedList<GroupRepresentation> hierarchy = new LinkedList<GroupRepresentation>();
        List<GroupModel> groups = realm.getTopLevelGroups();
        if (groups == null) {
            return hierarchy;
        }
        for (GroupModel group : groups) {
            GroupRepresentation rep = ModelToRepresentation.toGroupHierarchy(group, full);
            hierarchy.add(rep);
        }
        return hierarchy;
    }

    public static GroupRepresentation toGroupHierarchy(GroupModel group, boolean full) {
        GroupRepresentation rep = ModelToRepresentation.toRepresentation(group, full);
        LinkedList<GroupRepresentation> subGroups = new LinkedList<GroupRepresentation>();
        for (GroupModel subGroup : group.getSubGroups()) {
            subGroups.add(ModelToRepresentation.toGroupHierarchy(subGroup, full));
        }
        rep.setSubGroups(subGroups);
        return rep;
    }

    public static UserRepresentation toRepresentation(KeycloakSession session, RealmModel realm, UserModel user) {
        UserRepresentation rep = new UserRepresentation();
        rep.setId(user.getId());
        rep.setUsername(user.getUsername());
        rep.setCreatedTimestamp(user.getCreatedTimestamp());
        rep.setLastName(user.getLastName());
        rep.setFirstName(user.getFirstName());
        rep.setEmail(user.getEmail());
        rep.setEnabled(Boolean.valueOf(user.isEnabled()));
        rep.setEmailVerified(Boolean.valueOf(user.isEmailVerified()));
        rep.setTotp(Boolean.valueOf(session.userCredentialManager().isConfiguredFor(realm, user, "otp")));
        rep.setFederationLink(user.getFederationLink());
        ArrayList<String> reqActions = new ArrayList<String>();
        Set<String> requiredActions = user.getRequiredActions();
        for (String ra : requiredActions) {
            reqActions.add(ra);
        }
        rep.setRequiredActions(reqActions);
        if (user.getAttributes() != null && !user.getAttributes().isEmpty()) {
            HashMap<String, List<String>> attrs = new HashMap<String, List<String>>();
            attrs.putAll(user.getAttributes());
            rep.setAttributes(attrs);
        }
        return rep;
    }

    public static EventRepresentation toRepresentation(Event event) {
        EventRepresentation rep = new EventRepresentation();
        rep.setTime(event.getTime());
        rep.setType(event.getType().toString());
        rep.setRealmId(event.getRealmId());
        rep.setClientId(event.getClientId());
        rep.setUserId(event.getUserId());
        rep.setSessionId(event.getSessionId());
        rep.setIpAddress(event.getIpAddress());
        rep.setError(event.getError());
        rep.setDetails(event.getDetails());
        return rep;
    }

    public static AdminEventRepresentation toRepresentation(AdminEvent adminEvent) {
        AdminEventRepresentation rep = new AdminEventRepresentation();
        rep.setTime(adminEvent.getTime());
        rep.setRealmId(adminEvent.getRealmId());
        if (adminEvent.getAuthDetails() != null) {
            rep.setAuthDetails(ModelToRepresentation.toRepresentation(adminEvent.getAuthDetails()));
        }
        rep.setOperationType(adminEvent.getOperationType().toString());
        if (adminEvent.getResourceType() != null) {
            rep.setResourceType(adminEvent.getResourceType().toString());
        }
        rep.setResourcePath(adminEvent.getResourcePath());
        rep.setRepresentation(adminEvent.getRepresentation());
        rep.setError(adminEvent.getError());
        return rep;
    }

    public static AuthDetailsRepresentation toRepresentation(AuthDetails authDetails) {
        AuthDetailsRepresentation rep = new AuthDetailsRepresentation();
        rep.setRealmId(authDetails.getRealmId());
        rep.setClientId(authDetails.getClientId());
        rep.setUserId(authDetails.getUserId());
        rep.setIpAddress(authDetails.getIpAddress());
        return rep;
    }

    public static RoleRepresentation toRepresentation(RoleModel role) {
        RoleRepresentation rep = new RoleRepresentation();
        rep.setId(role.getId());
        rep.setName(role.getName());
        rep.setDescription(role.getDescription());
        rep.setScopeParamRequired(Boolean.valueOf(role.isScopeParamRequired()));
        rep.setComposite(role.isComposite());
        rep.setClientRole(Boolean.valueOf(role.isClientRole()));
        rep.setContainerId(role.getContainerId());
        return rep;
    }

    public static RealmRepresentation toRepresentation(RealmModel realm, boolean internal) {
        List<UserFederationProviderModel> fedProviderModels;
        List<RequiredCredentialModel> requiredCredentialModels;
        List<GroupModel> defaultGroups;
        List<String> defaultRoles;
        RealmRepresentation rep = new RealmRepresentation();
        rep.setId(realm.getId());
        rep.setRealm(realm.getName());
        rep.setDisplayName(realm.getDisplayName());
        rep.setDisplayNameHtml(realm.getDisplayNameHtml());
        rep.setEnabled(Boolean.valueOf(realm.isEnabled()));
        rep.setNotBefore(Integer.valueOf(realm.getNotBefore()));
        rep.setSslRequired(realm.getSslRequired().name().toLowerCase());
        rep.setRegistrationAllowed(Boolean.valueOf(realm.isRegistrationAllowed()));
        rep.setRegistrationEmailAsUsername(Boolean.valueOf(realm.isRegistrationEmailAsUsername()));
        rep.setRememberMe(Boolean.valueOf(realm.isRememberMe()));
        rep.setBruteForceProtected(Boolean.valueOf(realm.isBruteForceProtected()));
        rep.setMaxFailureWaitSeconds(Integer.valueOf(realm.getMaxFailureWaitSeconds()));
        rep.setMinimumQuickLoginWaitSeconds(Integer.valueOf(realm.getMinimumQuickLoginWaitSeconds()));
        rep.setWaitIncrementSeconds(Integer.valueOf(realm.getWaitIncrementSeconds()));
        rep.setQuickLoginCheckMilliSeconds(Long.valueOf(realm.getQuickLoginCheckMilliSeconds()));
        rep.setMaxDeltaTimeSeconds(Integer.valueOf(realm.getMaxDeltaTimeSeconds()));
        rep.setFailureFactor(Integer.valueOf(realm.getFailureFactor()));
        rep.setEventsEnabled(realm.isEventsEnabled());
        if (realm.getEventsExpiration() != 0L) {
            rep.setEventsExpiration(realm.getEventsExpiration());
        }
        if (realm.getEventsListeners() != null) {
            rep.setEventsListeners(new LinkedList<String>(realm.getEventsListeners()));
        }
        if (realm.getEnabledEventTypes() != null) {
            rep.setEnabledEventTypes(new LinkedList<String>(realm.getEnabledEventTypes()));
        }
        rep.setAdminEventsEnabled(Boolean.valueOf(realm.isAdminEventsEnabled()));
        rep.setAdminEventsDetailsEnabled(Boolean.valueOf(realm.isAdminEventsDetailsEnabled()));
        rep.setVerifyEmail(Boolean.valueOf(realm.isVerifyEmail()));
        rep.setResetPasswordAllowed(Boolean.valueOf(realm.isResetPasswordAllowed()));
        rep.setEditUsernameAllowed(Boolean.valueOf(realm.isEditUsernameAllowed()));
        rep.setRevokeRefreshToken(Boolean.valueOf(realm.isRevokeRefreshToken()));
        rep.setAccessTokenLifespan(Integer.valueOf(realm.getAccessTokenLifespan()));
        rep.setAccessTokenLifespanForImplicitFlow(Integer.valueOf(realm.getAccessTokenLifespanForImplicitFlow()));
        rep.setSsoSessionIdleTimeout(Integer.valueOf(realm.getSsoSessionIdleTimeout()));
        rep.setSsoSessionMaxLifespan(Integer.valueOf(realm.getSsoSessionMaxLifespan()));
        rep.setOfflineSessionIdleTimeout(Integer.valueOf(realm.getOfflineSessionIdleTimeout()));
        rep.setAccessCodeLifespan(Integer.valueOf(realm.getAccessCodeLifespan()));
        rep.setAccessCodeLifespanUserAction(Integer.valueOf(realm.getAccessCodeLifespanUserAction()));
        rep.setAccessCodeLifespanLogin(Integer.valueOf(realm.getAccessCodeLifespanLogin()));
        rep.setSmtpServer(realm.getSmtpConfig());
        rep.setBrowserSecurityHeaders(realm.getBrowserSecurityHeaders());
        rep.setAccountTheme(realm.getAccountTheme());
        rep.setLoginTheme(realm.getLoginTheme());
        rep.setAdminTheme(realm.getAdminTheme());
        rep.setEmailTheme(realm.getEmailTheme());
        if (realm.getPasswordPolicy() != null) {
            rep.setPasswordPolicy(realm.getPasswordPolicy().toString());
        }
        OTPPolicy otpPolicy = realm.getOTPPolicy();
        rep.setOtpPolicyAlgorithm(otpPolicy.getAlgorithm());
        rep.setOtpPolicyPeriod(Integer.valueOf(otpPolicy.getPeriod()));
        rep.setOtpPolicyDigits(Integer.valueOf(otpPolicy.getDigits()));
        rep.setOtpPolicyInitialCounter(Integer.valueOf(otpPolicy.getInitialCounter()));
        rep.setOtpPolicyType(otpPolicy.getType());
        rep.setOtpPolicyLookAheadWindow(Integer.valueOf(otpPolicy.getLookAheadWindow()));
        if (realm.getBrowserFlow() != null) {
            rep.setBrowserFlow(realm.getBrowserFlow().getAlias());
        }
        if (realm.getRegistrationFlow() != null) {
            rep.setRegistrationFlow(realm.getRegistrationFlow().getAlias());
        }
        if (realm.getDirectGrantFlow() != null) {
            rep.setDirectGrantFlow(realm.getDirectGrantFlow().getAlias());
        }
        if (realm.getResetCredentialsFlow() != null) {
            rep.setResetCredentialsFlow(realm.getResetCredentialsFlow().getAlias());
        }
        if (realm.getClientAuthenticationFlow() != null) {
            rep.setClientAuthenticationFlow(realm.getClientAuthenticationFlow().getAlias());
        }
        if (!(defaultRoles = realm.getDefaultRoles()).isEmpty()) {
            ArrayList<String> roleStrings = new ArrayList<String>();
            roleStrings.addAll(defaultRoles);
            rep.setDefaultRoles(roleStrings);
        }
        if (!(defaultGroups = realm.getDefaultGroups()).isEmpty()) {
            LinkedList<String> groupPaths = new LinkedList<String>();
            for (GroupModel group : defaultGroups) {
                groupPaths.add(ModelToRepresentation.buildGroupPath(group));
            }
            rep.setDefaultGroups(groupPaths);
        }
        if ((requiredCredentialModels = realm.getRequiredCredentials()).size() > 0) {
            rep.setRequiredCredentials(new HashSet());
            for (RequiredCredentialModel cred : requiredCredentialModels) {
                rep.getRequiredCredentials().add(cred.getType());
            }
        }
        if ((fedProviderModels = realm.getUserFederationProviders()).size() > 0) {
            Iterator<Serializable> fedProviderReps = new ArrayList();
            for (UserFederationProviderModel model : fedProviderModels) {
                UserFederationProviderRepresentation fedProvRep = ModelToRepresentation.toRepresentation(model);
                fedProviderReps.add((Serializable)fedProvRep);
            }
            rep.setUserFederationProviders(fedProviderReps);
        }
        for (UserFederationMapperModel userFederationMapperModel : realm.getUserFederationMappers()) {
            rep.addUserFederationMapper(ModelToRepresentation.toRepresentation(realm, userFederationMapperModel));
        }
        for (IdentityProviderModel identityProviderModel : realm.getIdentityProviders()) {
            rep.addIdentityProvider(ModelToRepresentation.toRepresentation(realm, identityProviderModel));
        }
        for (IdentityProviderMapperModel identityProviderMapperModel : realm.getIdentityProviderMappers()) {
            rep.addIdentityProviderMapper(ModelToRepresentation.toRepresentation(identityProviderMapperModel));
        }
        rep.setInternationalizationEnabled(Boolean.valueOf(realm.isInternationalizationEnabled()));
        if (realm.getSupportedLocales() != null) {
            rep.setSupportedLocales(new HashSet());
            rep.getSupportedLocales().addAll(realm.getSupportedLocales());
        }
        rep.setDefaultLocale(realm.getDefaultLocale());
        if (internal) {
            ModelToRepresentation.exportAuthenticationFlows(realm, rep);
            ModelToRepresentation.exportRequiredActions(realm, rep);
            ModelToRepresentation.exportGroups(realm, rep);
        }
        Map<String, String> attributes = realm.getAttributes();
        rep.setAttributes(attributes);
        return rep;
    }

    public static void exportGroups(RealmModel realm, RealmRepresentation rep) {
        List<GroupRepresentation> groups = ModelToRepresentation.toGroupHierarchy(realm, true);
        rep.setGroups(groups);
    }

    public static void exportAuthenticationFlows(RealmModel realm, RealmRepresentation rep) {
        rep.setAuthenticationFlows(new LinkedList());
        rep.setAuthenticatorConfig(new LinkedList());
        ArrayList<AuthenticationFlowModel> authenticationFlows = new ArrayList<AuthenticationFlowModel>(realm.getAuthenticationFlows());
        Collections.sort(authenticationFlows, new Comparator<AuthenticationFlowModel>(){

            @Override
            public int compare(AuthenticationFlowModel left, AuthenticationFlowModel right) {
                return left.getAlias().compareTo(right.getAlias());
            }
        });
        for (AuthenticationFlowModel model : authenticationFlows) {
            AuthenticationFlowRepresentation flowRep = ModelToRepresentation.toRepresentation(realm, model);
            rep.getAuthenticationFlows().add(flowRep);
        }
        ArrayList<AuthenticatorConfigModel> authenticatorConfigs = new ArrayList<AuthenticatorConfigModel>(realm.getAuthenticatorConfigs());
        Collections.sort(authenticatorConfigs, new Comparator<AuthenticatorConfigModel>(){

            @Override
            public int compare(AuthenticatorConfigModel left, AuthenticatorConfigModel right) {
                return left.getAlias().compareTo(right.getAlias());
            }
        });
        for (AuthenticatorConfigModel model : authenticatorConfigs) {
            rep.getAuthenticatorConfig().add(ModelToRepresentation.toRepresentation(model));
        }
    }

    public static void exportRequiredActions(RealmModel realm, RealmRepresentation rep) {
        rep.setRequiredActions(new LinkedList());
        List<RequiredActionProviderModel> requiredActionProviders = realm.getRequiredActionProviders();
        LinkedList<RequiredActionProviderModel> copy = new LinkedList<RequiredActionProviderModel>();
        copy.addAll(requiredActionProviders);
        requiredActionProviders = copy;
        Collections.sort(requiredActionProviders, new Comparator<RequiredActionProviderModel>(){

            @Override
            public int compare(RequiredActionProviderModel left, RequiredActionProviderModel right) {
                return left.getAlias().compareTo(right.getAlias());
            }
        });
        for (RequiredActionProviderModel model : requiredActionProviders) {
            RequiredActionProviderRepresentation action = ModelToRepresentation.toRepresentation(model);
            rep.getRequiredActions().add(action);
        }
    }

    public static RealmEventsConfigRepresentation toEventsConfigReprensetation(RealmModel realm) {
        RealmEventsConfigRepresentation rep = new RealmEventsConfigRepresentation();
        rep.setEventsEnabled(realm.isEventsEnabled());
        if (realm.getEventsExpiration() != 0L) {
            rep.setEventsExpiration(Long.valueOf(realm.getEventsExpiration()));
        }
        if (realm.getEventsListeners() != null) {
            rep.setEventsListeners(new LinkedList<String>(realm.getEventsListeners()));
        }
        if (realm.getEnabledEventTypes() != null) {
            rep.setEnabledEventTypes(new LinkedList<String>(realm.getEnabledEventTypes()));
        }
        rep.setAdminEventsEnabled(Boolean.valueOf(realm.isAdminEventsEnabled()));
        rep.setAdminEventsDetailsEnabled(Boolean.valueOf(realm.isAdminEventsDetailsEnabled()));
        return rep;
    }

    public static CredentialRepresentation toRepresentation(UserCredentialModel cred) {
        CredentialRepresentation rep = new CredentialRepresentation();
        rep.setType("secret");
        rep.setValue(cred.getValue());
        return rep;
    }

    public static FederatedIdentityRepresentation toRepresentation(FederatedIdentityModel socialLink) {
        FederatedIdentityRepresentation rep = new FederatedIdentityRepresentation();
        rep.setUserName(socialLink.getUserName());
        rep.setIdentityProvider(socialLink.getIdentityProvider());
        rep.setUserId(socialLink.getUserId());
        return rep;
    }

    public static UserSessionRepresentation toRepresentation(UserSessionModel session) {
        UserSessionRepresentation rep = new UserSessionRepresentation();
        rep.setId(session.getId());
        rep.setStart(Time.toMillis((int)session.getStarted()));
        rep.setLastAccess(Time.toMillis((int)session.getLastSessionRefresh()));
        rep.setUsername(session.getUser().getUsername());
        rep.setUserId(session.getUser().getId());
        rep.setIpAddress(session.getIpAddress());
        for (ClientSessionModel clientSession : session.getClientSessions()) {
            ClientModel client = clientSession.getClient();
            rep.getClients().put(client.getId(), client.getClientId());
        }
        return rep;
    }

    public static ClientTemplateRepresentation toRepresentation(ClientTemplateModel clientModel) {
        ClientTemplateRepresentation rep = new ClientTemplateRepresentation();
        rep.setId(clientModel.getId());
        rep.setName(clientModel.getName());
        rep.setDescription(clientModel.getDescription());
        rep.setProtocol(clientModel.getProtocol());
        if (!clientModel.getProtocolMappers().isEmpty()) {
            LinkedList<ProtocolMapperRepresentation> mappings = new LinkedList<ProtocolMapperRepresentation>();
            for (ProtocolMapperModel model : clientModel.getProtocolMappers()) {
                mappings.add(ModelToRepresentation.toRepresentation(model));
            }
            rep.setProtocolMappers(mappings);
        }
        rep.setFullScopeAllowed(Boolean.valueOf(clientModel.isFullScopeAllowed()));
        return rep;
    }

    public static ClientRepresentation toRepresentation(ClientModel clientModel) {
        Set<String> webOrigins;
        Set<String> redirectUris;
        ClientRepresentation rep = new ClientRepresentation();
        rep.setId(clientModel.getId());
        rep.setClientId(clientModel.getClientId());
        rep.setName(clientModel.getName());
        rep.setDescription(clientModel.getDescription());
        rep.setEnabled(Boolean.valueOf(clientModel.isEnabled()));
        rep.setAdminUrl(clientModel.getManagementUrl());
        rep.setPublicClient(Boolean.valueOf(clientModel.isPublicClient()));
        rep.setFrontchannelLogout(Boolean.valueOf(clientModel.isFrontchannelLogout()));
        rep.setProtocol(clientModel.getProtocol());
        rep.setAttributes(clientModel.getAttributes());
        rep.setFullScopeAllowed(Boolean.valueOf(clientModel.isFullScopeAllowed()));
        rep.setBearerOnly(Boolean.valueOf(clientModel.isBearerOnly()));
        rep.setConsentRequired(Boolean.valueOf(clientModel.isConsentRequired()));
        rep.setStandardFlowEnabled(Boolean.valueOf(clientModel.isStandardFlowEnabled()));
        rep.setImplicitFlowEnabled(Boolean.valueOf(clientModel.isImplicitFlowEnabled()));
        rep.setDirectAccessGrantsEnabled(Boolean.valueOf(clientModel.isDirectAccessGrantsEnabled()));
        rep.setServiceAccountsEnabled(Boolean.valueOf(clientModel.isServiceAccountsEnabled()));
        rep.setSurrogateAuthRequired(Boolean.valueOf(clientModel.isSurrogateAuthRequired()));
        rep.setRootUrl(clientModel.getRootUrl());
        rep.setBaseUrl(clientModel.getBaseUrl());
        rep.setNotBefore(Integer.valueOf(clientModel.getNotBefore()));
        rep.setNodeReRegistrationTimeout(Integer.valueOf(clientModel.getNodeReRegistrationTimeout()));
        rep.setClientAuthenticatorType(clientModel.getClientAuthenticatorType());
        if (clientModel.getClientTemplate() != null) {
            rep.setClientTemplate(clientModel.getClientTemplate().getName());
        }
        if ((redirectUris = clientModel.getRedirectUris()) != null) {
            rep.setRedirectUris(new LinkedList<String>(redirectUris));
        }
        if ((webOrigins = clientModel.getWebOrigins()) != null) {
            rep.setWebOrigins(new LinkedList<String>(webOrigins));
        }
        if (!clientModel.getDefaultRoles().isEmpty()) {
            rep.setDefaultRoles(clientModel.getDefaultRoles().toArray(new String[0]));
        }
        if (!clientModel.getRegisteredNodes().isEmpty()) {
            rep.setRegisteredNodes(new HashMap<String, Integer>(clientModel.getRegisteredNodes()));
        }
        if (!clientModel.getProtocolMappers().isEmpty()) {
            LinkedList<ProtocolMapperRepresentation> mappings = new LinkedList<ProtocolMapperRepresentation>();
            for (ProtocolMapperModel model : clientModel.getProtocolMappers()) {
                mappings.add(ModelToRepresentation.toRepresentation(model));
            }
            rep.setProtocolMappers(mappings);
        }
        rep.setUseTemplateMappers(Boolean.valueOf(clientModel.useTemplateMappers()));
        rep.setUseTemplateConfig(Boolean.valueOf(clientModel.useTemplateConfig()));
        rep.setUseTemplateScope(Boolean.valueOf(clientModel.useTemplateScope()));
        return rep;
    }

    public static UserFederationProviderRepresentation toRepresentation(UserFederationProviderModel model) {
        UserFederationProviderRepresentation rep = new UserFederationProviderRepresentation();
        rep.setId(model.getId());
        rep.setConfig(model.getConfig());
        rep.setProviderName(model.getProviderName());
        rep.setPriority(model.getPriority());
        rep.setDisplayName(model.getDisplayName());
        rep.setFullSyncPeriod(model.getFullSyncPeriod());
        rep.setChangedSyncPeriod(model.getChangedSyncPeriod());
        rep.setLastSync(model.getLastSync());
        return rep;
    }

    public static UserFederationMapperRepresentation toRepresentation(RealmModel realm, UserFederationMapperModel model) {
        UserFederationMapperRepresentation rep = new UserFederationMapperRepresentation();
        rep.setId(model.getId());
        rep.setName(model.getName());
        rep.setFederationMapperType(model.getFederationMapperType());
        HashMap<String, String> config = new HashMap<String, String>();
        config.putAll(model.getConfig());
        rep.setConfig(config);
        UserFederationProviderModel fedProvider = KeycloakModelUtils.findUserFederationProviderById(model.getFederationProviderId(), realm);
        if (fedProvider == null) {
            throw new ModelException("Couldn't find federation provider with ID " + model.getId());
        }
        rep.setFederationProviderDisplayName(fedProvider.getDisplayName());
        return rep;
    }

    public static IdentityProviderRepresentation toRepresentation(RealmModel realm, IdentityProviderModel identityProviderModel) {
        String postBrokerLoginFlowId;
        IdentityProviderRepresentation providerRep = new IdentityProviderRepresentation();
        providerRep.setInternalId(identityProviderModel.getInternalId());
        providerRep.setProviderId(identityProviderModel.getProviderId());
        providerRep.setAlias(identityProviderModel.getAlias());
        providerRep.setDisplayName(identityProviderModel.getDisplayName());
        providerRep.setEnabled(identityProviderModel.isEnabled());
        providerRep.setStoreToken(identityProviderModel.isStoreToken());
        providerRep.setTrustEmail(identityProviderModel.isTrustEmail());
        providerRep.setAuthenticateByDefault(identityProviderModel.isAuthenticateByDefault());
        providerRep.setConfig(identityProviderModel.getConfig());
        providerRep.setAddReadTokenRoleOnCreate(identityProviderModel.isAddReadTokenRoleOnCreate());
        String firstBrokerLoginFlowId = identityProviderModel.getFirstBrokerLoginFlowId();
        if (firstBrokerLoginFlowId != null) {
            AuthenticationFlowModel flow = realm.getAuthenticationFlowById(firstBrokerLoginFlowId);
            if (flow == null) {
                throw new ModelException("Couldn't find authentication flow with id " + firstBrokerLoginFlowId);
            }
            providerRep.setFirstBrokerLoginFlowAlias(flow.getAlias());
        }
        if ((postBrokerLoginFlowId = identityProviderModel.getPostBrokerLoginFlowId()) != null) {
            AuthenticationFlowModel flow = realm.getAuthenticationFlowById(postBrokerLoginFlowId);
            if (flow == null) {
                throw new ModelException("Couldn't find authentication flow with id " + postBrokerLoginFlowId);
            }
            providerRep.setPostBrokerLoginFlowAlias(flow.getAlias());
        }
        return providerRep;
    }

    public static ProtocolMapperRepresentation toRepresentation(ProtocolMapperModel model) {
        ProtocolMapperRepresentation rep = new ProtocolMapperRepresentation();
        rep.setId(model.getId());
        rep.setProtocol(model.getProtocol());
        HashMap<String, String> config = new HashMap<String, String>();
        config.putAll(model.getConfig());
        rep.setConfig(config);
        rep.setName(model.getName());
        rep.setProtocolMapper(model.getProtocolMapper());
        rep.setConsentText(model.getConsentText());
        rep.setConsentRequired(model.isConsentRequired());
        return rep;
    }

    public static IdentityProviderMapperRepresentation toRepresentation(IdentityProviderMapperModel model) {
        IdentityProviderMapperRepresentation rep = new IdentityProviderMapperRepresentation();
        rep.setId(model.getId());
        rep.setIdentityProviderMapper(model.getIdentityProviderMapper());
        rep.setIdentityProviderAlias(model.getIdentityProviderAlias());
        HashMap<String, String> config = new HashMap<String, String>();
        config.putAll(model.getConfig());
        rep.setConfig(config);
        rep.setName(model.getName());
        return rep;
    }

    public static UserConsentRepresentation toRepresentation(UserConsentModel model) {
        String clientId = model.getClient().getClientId();
        HashMap<Object, LinkedList<String>> grantedProtocolMappers = new HashMap<Object, LinkedList<String>>();
        for (ProtocolMapperModel protocolMapper : model.getGrantedProtocolMappers()) {
            String protocol = protocolMapper.getProtocol();
            LinkedList<String> currentProtocolMappers = (LinkedList<String>)grantedProtocolMappers.get(protocol);
            if (currentProtocolMappers == null) {
                currentProtocolMappers = new LinkedList<String>();
                grantedProtocolMappers.put(protocol, currentProtocolMappers);
            }
            currentProtocolMappers.add(protocolMapper.getName());
        }
        LinkedList<String> grantedRealmRoles = new LinkedList<String>();
        HashMap<String, LinkedList<String>> grantedClientRoles = new HashMap<String, LinkedList<String>>();
        for (RoleModel role : model.getGrantedRoles()) {
            if (role.getContainer() instanceof RealmModel) {
                grantedRealmRoles.add(role.getName());
                continue;
            }
            ClientModel client2 = (ClientModel)role.getContainer();
            String clientId2 = client2.getClientId();
            LinkedList<String> currentClientRoles = (LinkedList<String>)grantedClientRoles.get(clientId2);
            if (currentClientRoles == null) {
                currentClientRoles = new LinkedList<String>();
                grantedClientRoles.put(clientId2, currentClientRoles);
            }
            currentClientRoles.add(role.getName());
        }
        UserConsentRepresentation consentRep = new UserConsentRepresentation();
        consentRep.setClientId(clientId);
        consentRep.setGrantedProtocolMappers(grantedProtocolMappers);
        consentRep.setGrantedRealmRoles(grantedRealmRoles);
        consentRep.setGrantedClientRoles(grantedClientRoles);
        consentRep.setCreatedDate(model.getCreatedDate());
        consentRep.setLastUpdatedDate(model.getLastUpdatedDate());
        return consentRep;
    }

    public static AuthenticationFlowRepresentation toRepresentation(RealmModel realm, AuthenticationFlowModel model) {
        AuthenticationFlowRepresentation rep = new AuthenticationFlowRepresentation();
        rep.setId(model.getId());
        rep.setBuiltIn(model.isBuiltIn());
        rep.setTopLevel(model.isTopLevel());
        rep.setProviderId(model.getProviderId());
        rep.setAlias(model.getAlias());
        rep.setDescription(model.getDescription());
        rep.setAuthenticationExecutions(new LinkedList());
        for (AuthenticationExecutionModel execution : realm.getAuthenticationExecutions(model.getId())) {
            rep.getAuthenticationExecutions().add(ModelToRepresentation.toRepresentation(realm, execution));
        }
        return rep;
    }

    public static AuthenticationExecutionExportRepresentation toRepresentation(RealmModel realm, AuthenticationExecutionModel model) {
        AuthenticationExecutionExportRepresentation rep = new AuthenticationExecutionExportRepresentation();
        if (model.getAuthenticatorConfig() != null) {
            AuthenticatorConfigModel config = realm.getAuthenticatorConfigById(model.getAuthenticatorConfig());
            rep.setAuthenticatorConfig(config.getAlias());
        }
        rep.setAuthenticator(model.getAuthenticator());
        rep.setAutheticatorFlow(model.isAuthenticatorFlow());
        if (model.getFlowId() != null) {
            AuthenticationFlowModel flow = realm.getAuthenticationFlowById(model.getFlowId());
            rep.setFlowAlias(flow.getAlias());
        }
        rep.setPriority(model.getPriority());
        rep.setRequirement(model.getRequirement().name());
        return rep;
    }

    public static AuthenticatorConfigRepresentation toRepresentation(AuthenticatorConfigModel model) {
        AuthenticatorConfigRepresentation rep = new AuthenticatorConfigRepresentation();
        rep.setId(model.getId());
        rep.setAlias(model.getAlias());
        rep.setConfig(model.getConfig());
        return rep;
    }

    public static RequiredActionProviderRepresentation toRepresentation(RequiredActionProviderModel model) {
        RequiredActionProviderRepresentation rep = new RequiredActionProviderRepresentation();
        rep.setAlias(model.getAlias());
        rep.setDefaultAction(model.isDefaultAction());
        rep.setEnabled(model.isEnabled());
        rep.setConfig(model.getConfig());
        rep.setName(model.getName());
        rep.setProviderId(model.getProviderId());
        return rep;
    }

    public static List<ConfigPropertyRepresentation> toRepresentation(List<ProviderConfigProperty> configProperties) {
        LinkedList<ConfigPropertyRepresentation> propertiesRep = new LinkedList<ConfigPropertyRepresentation>();
        for (ProviderConfigProperty prop : configProperties) {
            ConfigPropertyRepresentation propRep = ModelToRepresentation.toRepresentation(prop);
            propertiesRep.add(propRep);
        }
        return propertiesRep;
    }

    public static ConfigPropertyRepresentation toRepresentation(ProviderConfigProperty prop) {
        ConfigPropertyRepresentation propRep = new ConfigPropertyRepresentation();
        propRep.setName(prop.getName());
        propRep.setLabel(prop.getLabel());
        propRep.setType(prop.getType());
        propRep.setDefaultValue(prop.getDefaultValue());
        propRep.setOptions(prop.getOptions());
        propRep.setHelpText(prop.getHelpText());
        propRep.setSecret(prop.isSecret());
        return propRep;
    }

    public static ComponentRepresentation toRepresentation(KeycloakSession session, ComponentModel component, boolean internal) {
        ComponentRepresentation rep = new ComponentRepresentation();
        rep.setId(component.getId());
        rep.setName(component.getName());
        rep.setProviderId(component.getProviderId());
        rep.setProviderType(component.getProviderType());
        rep.setSubType(component.getSubType());
        rep.setParentId(component.getParentId());
        if (internal) {
            rep.setConfig(component.getConfig());
        } else {
            Map<String, ProviderConfigProperty> configProperties = ComponentUtil.getComponentConfigProperties(session, component);
            MultivaluedHashMap config = new MultivaluedHashMap();
            for (Map.Entry e : component.getConfig().entrySet()) {
                ProviderConfigProperty configProperty = configProperties.get(e.getKey());
                if (configProperty == null) continue;
                if (configProperty.isSecret()) {
                    config.putSingle(e.getKey(), (Object)"**********");
                    continue;
                }
                config.put(e.getKey(), e.getValue());
            }
            rep.setConfig(config);
        }
        return rep;
    }

    public static ScopeRepresentation toRepresentation(Scope model, AuthorizationProvider authorizationProvider) {
        ScopeRepresentation scope = new ScopeRepresentation();
        scope.setId(model.getId());
        scope.setName(model.getName());
        scope.setIconUri(model.getIconUri());
        StoreFactory storeFactory = authorizationProvider.getStoreFactory();
        scope.setResources(new ArrayList());
        storeFactory.getResourceStore().findByScope(model.getId()).forEach(resource -> scope.getResources().add(ModelToRepresentation.toRepresentation(resource, resource.getResourceServer(), authorizationProvider)));
        PolicyStore policyStore = storeFactory.getPolicyStore();
        scope.setPolicies(new ArrayList());
        policyStore.findByScopeIds(Arrays.asList(model.getId()), model.getResourceServer().getId()).forEach(policyModel -> {
            PolicyRepresentation policy = new PolicyRepresentation();
            policy.setId(policyModel.getId());
            policy.setName(policyModel.getName());
            policy.setType(policyModel.getType());
            if (!scope.getPolicies().contains(policy)) {
                scope.getPolicies().add(policy);
            }
        });
        return scope;
    }

    public static ResourceServerRepresentation toRepresentation(ResourceServer model, ClientModel client) {
        ResourceServerRepresentation server = new ResourceServerRepresentation();
        server.setId(model.getId());
        server.setClientId(model.getClientId());
        server.setName(client.getClientId());
        server.setAllowRemoteResourceManagement(model.isAllowRemoteResourceManagement());
        server.setPolicyEnforcementMode(model.getPolicyEnforcementMode());
        return server;
    }

    public static PolicyRepresentation toRepresentation(Policy model, AuthorizationProvider authorization) {
        PolicyRepresentation representation = new PolicyRepresentation();
        representation.setId(model.getId());
        representation.setName(model.getName());
        representation.setDescription(model.getDescription());
        representation.setType(model.getType());
        representation.setDecisionStrategy(model.getDecisionStrategy());
        representation.setLogic(model.getLogic());
        representation.setConfig(new HashMap<String, String>(model.getConfig()));
        List<Policy> policies = authorization.getStoreFactory().getPolicyStore().findDependentPolicies(model.getId());
        representation.setDependentPolicies(policies.stream().map(policy -> {
            PolicyRepresentation representation1 = new PolicyRepresentation();
            representation1.setId(policy.getId());
            representation1.setName(policy.getName());
            return representation1;
        }).collect(Collectors.toList()));
        ArrayList associatedPolicies = new ArrayList();
        List obj = model.getAssociatedPolicies().stream().map(policy -> {
            PolicyRepresentation representation1 = new PolicyRepresentation();
            representation1.setId(policy.getId());
            representation1.setName(policy.getName());
            representation1.setType(policy.getType());
            associatedPolicies.add(representation1);
            return policy.getId();
        }).collect(Collectors.toList());
        representation.setAssociatedPolicies(associatedPolicies);
        try {
            representation.getConfig().put("applyPolicies", JsonSerialization.writeValueAsString(obj));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return representation;
    }

    public static ResourceRepresentation toRepresentation(Resource model, ResourceServer resourceServer, AuthorizationProvider authorization) {
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setId(model.getId());
        resource.setType(model.getType());
        resource.setName(model.getName());
        resource.setUri(model.getUri());
        resource.setIconUri(model.getIconUri());
        ResourceOwnerRepresentation owner = new ResourceOwnerRepresentation();
        owner.setId(model.getOwner());
        KeycloakSession keycloakSession = authorization.getKeycloakSession();
        RealmModel realm = authorization.getRealm();
        if (owner.getId().equals(resourceServer.getClientId())) {
            ClientModel clientModel = realm.getClientById(resourceServer.getClientId());
            owner.setName(clientModel.getClientId());
        } else {
            UserModel userModel = keycloakSession.users().getUserById(owner.getId(), realm);
            if (userModel == null) {
                throw new RuntimeException("Could not find the user [" + owner.getId() + "] who owns the Resource [" + resource.getId() + "].");
            }
            owner.setName(userModel.getUsername());
        }
        resource.setOwner(owner);
        resource.setScopes(model.getScopes().stream().map(model1 -> {
            ScopeRepresentation scope = new ScopeRepresentation();
            scope.setId(model1.getId());
            scope.setName(model1.getName());
            String iconUri = model1.getIconUri();
            if (iconUri != null) {
                scope.setIconUri(iconUri);
            }
            return scope;
        }).collect(Collectors.toSet()));
        resource.setTypedScopes(new ArrayList());
        if (resource.getType() != null) {
            ResourceStore resourceStore = authorization.getStoreFactory().getResourceStore();
            for (Resource typed : resourceStore.findByType(resource.getType())) {
                if (!typed.getOwner().equals(resourceServer.getClientId()) || typed.getId().equals(resource.getId())) continue;
                resource.setTypedScopes(typed.getScopes().stream().map(model1 -> {
                    ScopeRepresentation scope = new ScopeRepresentation();
                    scope.setId(model1.getId());
                    scope.setName(model1.getName());
                    String iconUri = model1.getIconUri();
                    if (iconUri != null) {
                        scope.setIconUri(iconUri);
                    }
                    return scope;
                }).filter(scopeRepresentation -> !resource.getScopes().contains(scopeRepresentation)).collect(Collectors.toList()));
            }
        }
        resource.setPolicies(new ArrayList());
        HashSet<Policy> policies = new HashSet<Policy>();
        PolicyStore policyStore = authorization.getStoreFactory().getPolicyStore();
        policies.addAll(policyStore.findByResource(resource.getId()));
        policies.addAll(policyStore.findByResourceType(resource.getType(), resourceServer.getId()));
        policies.addAll(policyStore.findByScopeIds(resource.getScopes().stream().map(scope -> scope.getId()).collect(Collectors.toList()), resourceServer.getId()));
        for (Policy policyModel : policies) {
            PolicyRepresentation policy = new PolicyRepresentation();
            policy.setId(policyModel.getId());
            policy.setName(policyModel.getName());
            policy.setType(policyModel.getType());
            if (resource.getPolicies().contains(policy)) continue;
            resource.getPolicies().add(policy);
        }
        return resource;
    }
}

