/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.provider;

import java.util.List;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.provider.ProviderConfigProperty;

public class ConfigurationValidationHelper {
    private ComponentModel model;

    private ConfigurationValidationHelper(ComponentModel model) {
        this.model = model;
    }

    public static ConfigurationValidationHelper check(ComponentModel model) {
        return new ConfigurationValidationHelper(model);
    }

    public ConfigurationValidationHelper checkInt(ProviderConfigProperty property, boolean required) throws ComponentValidationException {
        return this.checkInt(property.getName(), property.getLabel(), required);
    }

    public ConfigurationValidationHelper checkInt(String key, String label, boolean required) throws ComponentValidationException {
        this.checkSingle(key, label, required);
        String val = (String)this.model.getConfig().getFirst((Object)key);
        if (val != null) {
            try {
                Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                throw new ComponentValidationException("''{0}'' should be a number", label);
            }
        }
        return this;
    }

    public ConfigurationValidationHelper checkLong(ProviderConfigProperty property, boolean required) throws ComponentValidationException {
        return this.checkLong(property.getName(), property.getLabel(), required);
    }

    public ConfigurationValidationHelper checkLong(String key, String label, boolean required) throws ComponentValidationException {
        this.checkSingle(key, label, required);
        String val = (String)this.model.getConfig().getFirst((Object)key);
        if (val != null) {
            try {
                Long.parseLong(val);
            }
            catch (NumberFormatException e) {
                throw new ComponentValidationException("''{0}'' should be a number", label);
            }
        }
        return this;
    }

    public ConfigurationValidationHelper checkSingle(ProviderConfigProperty property, boolean required) throws ComponentValidationException {
        return this.checkSingle(property.getName(), property.getLabel(), required);
    }

    public ConfigurationValidationHelper checkSingle(String key, String label, boolean required) throws ComponentValidationException {
        if (this.model.getConfig().containsKey((Object)key) && ((List)this.model.getConfig().get((Object)key)).size() > 1) {
            throw new ComponentValidationException("''{0}'' should be a single entry", label);
        }
        if (required) {
            this.checkRequired(key, label);
        }
        return this;
    }

    public ConfigurationValidationHelper checkRequired(ProviderConfigProperty property) throws ComponentValidationException {
        return this.checkRequired(property.getName(), property.getLabel());
    }

    public ConfigurationValidationHelper checkRequired(String key, String label) throws ComponentValidationException {
        List values = (List)this.model.getConfig().get((Object)key);
        if (values == null) {
            throw new ComponentValidationException("''{0}'' is required", label);
        }
        return this;
    }

    public ConfigurationValidationHelper checkBoolean(ProviderConfigProperty property, boolean required) throws ComponentValidationException {
        return this.checkBoolean(property.getName(), property.getLabel(), required);
    }

    public ConfigurationValidationHelper checkBoolean(String key, String label, boolean required) {
        this.checkSingle(key, label, required);
        String val = (String)this.model.getConfig().getFirst((Object)key);
        if (val != null && !val.equals("true") && !val.equals("false")) {
            throw new ComponentValidationException("''{0}'' should be ''true'' or ''false''", label);
        }
        return this;
    }
}

