/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.bitmask;

import org.drools.core.util.bitmask.AllSetBitMask;
import org.drools.core.util.bitmask.AllSetButLastBitMask;
import org.drools.core.util.bitmask.BitMask;
import org.drools.core.util.bitmask.EmptyBitMask;
import org.drools.core.util.bitmask.EmptyButLastBitMask;
import org.drools.core.util.bitmask.OpenBitSet;
import org.drools.core.util.bitmask.SingleLongBitMask;

public class LongBitMask
extends SingleLongBitMask
implements BitMask {
    private long mask;

    public LongBitMask() {
    }

    public LongBitMask(long mask) {
        this.mask = mask;
    }

    @Override
    public BitMask set(int index) {
        if (index >= 64) {
            return BitMask.Factory.getEmpty(index + 1).setAll(this).set(index);
        }
        this.mask |= 1L << index;
        return this;
    }

    @Override
    public BitMask setAll(BitMask mask) {
        if (mask instanceof LongBitMask) {
            this.mask |= ((LongBitMask)mask).asLong();
        } else {
            if (mask instanceof AllSetBitMask) {
                return AllSetBitMask.get();
            }
            if (mask instanceof AllSetButLastBitMask) {
                return this.isSet(0) ? AllSetBitMask.get() : AllSetButLastBitMask.get();
            }
            if (mask instanceof OpenBitSet) {
                return mask.setAll(this);
            }
            if (mask instanceof EmptyButLastBitMask) {
                return this.set(0);
            }
        }
        return this;
    }

    @Override
    public BitMask reset(int index) {
        if (index < 64) {
            this.mask &= Long.MAX_VALUE - (1L << index);
        }
        return this;
    }

    @Override
    public BitMask resetAll(BitMask mask) {
        if (mask instanceof LongBitMask) {
            this.mask &= -1L - ((LongBitMask)mask).asLong();
            return this;
        }
        if (mask instanceof AllSetBitMask) {
            return EmptyBitMask.get();
        }
        if (mask instanceof AllSetButLastBitMask) {
            this.mask &= Long.MIN_VALUE;
            return this;
        }
        if (mask instanceof EmptyButLastBitMask) {
            return this.reset(0);
        }
        if (mask instanceof EmptyBitMask) {
            return this;
        }
        throw new RuntimeException("Cannot resetAll a LongBitMask with a " + mask.getClass().getSimpleName());
    }

    @Override
    public boolean isSet(int index) {
        long bit = 1L << index;
        return (this.mask & bit) == bit;
    }

    @Override
    public boolean isAllSet() {
        return this.mask == -1L;
    }

    @Override
    public boolean isEmpty() {
        return this.mask == 0L;
    }

    @Override
    public boolean intersects(BitMask mask) {
        return mask instanceof LongBitMask ? (this.mask & ((LongBitMask)mask).asLong()) != 0L : mask.intersects(this);
    }

    @Override
    public long asLong() {
        return this.mask;
    }

    @Override
    public LongBitMask clone() {
        return new LongBitMask(this.mask);
    }

    @Override
    public String getInstancingStatement() {
        BitMask normalizedMask = this.normalize();
        return normalizedMask instanceof LongBitMask ? "new " + LongBitMask.class.getCanonicalName() + "(" + this.mask + "L)" : normalizedMask.getInstancingStatement();
    }

    private BitMask normalize() {
        if (this.mask == 0L) {
            return EmptyBitMask.get();
        }
        if (this.mask == 1L) {
            return EmptyButLastBitMask.get();
        }
        if (this.mask == Long.MAX_VALUE) {
            return AllSetButLastBitMask.get();
        }
        if (this.mask == -1L) {
            return AllSetBitMask.get();
        }
        return this;
    }
}

