/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.plugins;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.jboss.as.security.logging.SecurityLogger;
import org.jboss.as.security.plugins.SecurityActions;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.security.plugins.ClassLoaderLocator;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ModuleClassLoaderLocator
implements ClassLoaderLocator {
    private final ModuleLoader moduleLoader;

    public ModuleClassLoaderLocator(ModuleLoader loader) {
        this.moduleLoader = loader;
    }

    public ClassLoader get(String key) {
        try {
            ModuleClassLoader moduleClassLoader = SecurityActions.getModuleClassLoader(this.moduleLoader, key);
            ClassLoader tccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
            return new CombinedClassLoader((ClassLoader)moduleClassLoader, tccl);
        }
        catch (ModuleLoadException e) {
            throw SecurityLogger.ROOT_LOGGER.runtimeException(e);
        }
    }

    public class CombinedClassLoader
    extends SecureClassLoader {
        private ClassLoader first;
        private ClassLoader second;

        public CombinedClassLoader(ClassLoader firstCL, ClassLoader secondCL) {
            this.first = firstCL;
            this.second = secondCL;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            Class<?> theClass = null;
            try {
                theClass = this.first.loadClass(name);
            }
            catch (ClassNotFoundException ce) {
                theClass = this.second.loadClass(name);
            }
            return theClass;
        }

        @Override
        public URL getResource(String name) {
            URL resource = null;
            resource = this.first.getResource(name);
            if (resource == null) {
                resource = this.second.getResource(name);
            }
            return resource;
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            InputStream is = null;
            is = this.first.getResourceAsStream(name);
            if (is == null) {
                is = this.second.getResourceAsStream(name);
            }
            return is;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            ArrayList<URL> combinedList = new ArrayList<URL>();
            combinedList.addAll(Collections.list(this.first.getResources(name)));
            combinedList.addAll(Collections.list(this.second.getResources(name)));
            return Collections.enumeration(combinedList);
        }
    }
}

