/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan;

import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterListener;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.cache.CacheRealmProvider;
import org.keycloak.models.cache.CacheRealmProviderFactory;
import org.keycloak.models.cache.infinispan.RealmCacheManager;
import org.keycloak.models.cache.infinispan.RealmCacheSession;

public class InfinispanCacheRealmProviderFactory
implements CacheRealmProviderFactory {
    private static final Logger log = Logger.getLogger(InfinispanCacheRealmProviderFactory.class);
    public static final String REALM_CLEAR_CACHE_EVENTS = "REALM_CLEAR_CACHE_EVENTS";
    protected volatile RealmCacheManager realmCache;

    public CacheRealmProvider create(KeycloakSession session) {
        this.lazyInit(session);
        return new RealmCacheSession(this.realmCache, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit(KeycloakSession session) {
        if (this.realmCache == null) {
            InfinispanCacheRealmProviderFactory infinispanCacheRealmProviderFactory = this;
            synchronized (infinispanCacheRealmProviderFactory) {
                if (this.realmCache == null) {
                    Cache cache = ((InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class)).getCache("realms");
                    Cache revisions = ((InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class)).getCache("realmRevisions");
                    this.realmCache = new RealmCacheManager(cache, revisions);
                    ClusterProvider cluster = (ClusterProvider)session.getProvider(ClusterProvider.class);
                    cluster.registerListener(REALM_CLEAR_CACHE_EVENTS, new ClusterListener(){

                        public void run(ClusterEvent event) {
                            InfinispanCacheRealmProviderFactory.this.realmCache.clear();
                        }
                    });
                }
            }
        }
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "default";
    }
}

