/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.deployment;

import java.io.Serializable;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.jms.BytesMessage;
import javax.jms.ConnectionFactory;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSConnectionFactory;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.JMSPasswordCredential;
import javax.jms.JMSProducer;
import javax.jms.JMSSessionMode;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.XAConnectionFactory;
import javax.jms.XAJMSContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.metadata.property.PropertyReplacer;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class JMSContextProducer {
    private static final String TRANSACTION_SYNCHRONIZATION_REGISTRY_LOOKUP = "java:comp/TransactionSynchronizationRegistry";
    private static final Object TRANSACTION_KEY = "TRANSACTED_JMS_CONTEXT";
    private PropertyReplacer propertyReplacer;

    void setPropertyReplacer(PropertyReplacer propertyReplacer) {
        this.propertyReplacer = propertyReplacer;
    }

    @Produces
    public JMSContext getJMSContext(InjectionPoint injectionPoint) throws NamingException {
        String connectionFactoryLookup = "java:comp/DefaultJMSConnectionFactory";
        String userName = null;
        String password = null;
        int ackMode = 1;
        if (injectionPoint != null) {
            if (injectionPoint.getAnnotated().isAnnotationPresent(JMSConnectionFactory.class)) {
                JMSConnectionFactory cf = (JMSConnectionFactory)injectionPoint.getAnnotated().getAnnotation(JMSConnectionFactory.class);
                connectionFactoryLookup = this.propertyReplacer.replaceProperties(cf.value());
            }
            if (injectionPoint.getAnnotated().isAnnotationPresent(JMSPasswordCredential.class)) {
                JMSPasswordCredential credential = (JMSPasswordCredential)injectionPoint.getAnnotated().getAnnotation(JMSPasswordCredential.class);
                userName = this.propertyReplacer.replaceProperties(credential.userName());
                password = this.propertyReplacer.replaceProperties(credential.password());
            }
            if (injectionPoint.getAnnotated().isAnnotationPresent(JMSSessionMode.class)) {
                JMSSessionMode sessionMode = (JMSSessionMode)injectionPoint.getAnnotated().getAnnotation(JMSSessionMode.class);
                ackMode = sessionMode.value();
            }
        }
        JMSInfo info = new JMSInfo(connectionFactoryLookup, userName, password, ackMode);
        return new JMSContextWrapper(info);
    }

    public void closeJMSContext(@Disposes JMSContext context) {
        if (context instanceof JMSContextWrapper) {
            ((JMSContextWrapper)context).internalClose();
        }
    }

    private class JMSContextWrapper
    implements JMSContext {
        private final JMSInfo info;
        private JMSContext delegate;
        private boolean inTransaction = false;

        JMSContextWrapper(JMSInfo info) {
            this.info = info;
        }

        private JMSContext create(JMSInfo info, boolean inTx) {
            this.inTransaction = inTx;
            ConnectionFactory cf = (ConnectionFactory)this.lookup(info.connectionFactoryLookup);
            if (this.inTransaction) {
                XAJMSContext xaContext = ((XAConnectionFactory)cf).createXAContext(info.userName, info.password);
                return xaContext.getContext();
            }
            return cf.createContext(info.userName, info.password, info.ackMode);
        }

        private void internalClose() {
            if (this.delegate != null && !this.inTransaction) {
                this.delegate.close();
                this.delegate = null;
            }
        }

        private synchronized JMSContext getDelegate() {
            boolean inTx;
            TransactionSynchronizationRegistry txSyncRegistry = (TransactionSynchronizationRegistry)this.lookup(JMSContextProducer.TRANSACTION_SYNCHRONIZATION_REGISTRY_LOOKUP);
            boolean bl = inTx = txSyncRegistry.getTransactionStatus() == 0;
            if (inTx) {
                Object resource = txSyncRegistry.getResource(TRANSACTION_KEY);
                if (resource != null) {
                    return (JMSContext)resource;
                }
                final JMSContext transactedContext = this.create(this.info, inTx);
                txSyncRegistry.putResource(TRANSACTION_KEY, resource);
                txSyncRegistry.registerInterposedSynchronization(new Synchronization(){

                    public void beforeCompletion() {
                    }

                    public synchronized void afterCompletion(int status) {
                        transactedContext.close();
                        JMSContextWrapper.this.inTransaction = false;
                    }
                });
                return transactedContext;
            }
            if (this.delegate == null) {
                try {
                    this.delegate = this.create(this.info, inTx);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return this.delegate;
        }

        private Object lookup(String name) {
            InitialContext ctx = null;
            try {
                ctx = new InitialContext();
                Object object = ctx.lookup(name);
                return object;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (NamingException namingException) {}
                }
            }
        }

        public JMSContext createContext(int sessionMode) {
            return this.getDelegate().createContext(sessionMode);
        }

        public JMSProducer createProducer() {
            return this.getDelegate().createProducer();
        }

        public String getClientID() {
            return this.getDelegate().getClientID();
        }

        public void setClientID(String clientID) {
            throw MessagingLogger.ROOT_LOGGER.callNotPermittedOnInjectedJMSContext();
        }

        public ConnectionMetaData getMetaData() {
            return this.getDelegate().getMetaData();
        }

        public ExceptionListener getExceptionListener() {
            return this.getDelegate().getExceptionListener();
        }

        public void setExceptionListener(ExceptionListener listener) {
            throw MessagingLogger.ROOT_LOGGER.callNotPermittedOnInjectedJMSContext();
        }

        public void start() {
            throw MessagingLogger.ROOT_LOGGER.callNotPermittedOnInjectedJMSContext();
        }

        public void stop() {
            throw MessagingLogger.ROOT_LOGGER.callNotPermittedOnInjectedJMSContext();
        }

        public void setAutoStart(boolean autoStart) {
            throw MessagingLogger.ROOT_LOGGER.callNotPermittedOnInjectedJMSContext();
        }

        public boolean getAutoStart() {
            return this.getDelegate().getAutoStart();
        }

        public void close() {
            throw MessagingLogger.ROOT_LOGGER.callNotPermittedOnInjectedJMSContext();
        }

        public BytesMessage createBytesMessage() {
            return this.getDelegate().createBytesMessage();
        }

        public MapMessage createMapMessage() {
            return this.getDelegate().createMapMessage();
        }

        public Message createMessage() {
            return this.getDelegate().createMessage();
        }

        public ObjectMessage createObjectMessage() {
            return this.getDelegate().createObjectMessage();
        }

        public ObjectMessage createObjectMessage(Serializable object) {
            return this.getDelegate().createObjectMessage(object);
        }

        public StreamMessage createStreamMessage() {
            return this.getDelegate().createStreamMessage();
        }

        public TextMessage createTextMessage() {
            return this.getDelegate().createTextMessage();
        }

        public TextMessage createTextMessage(String text) {
            return this.getDelegate().createTextMessage(text);
        }

        public boolean getTransacted() {
            return this.getDelegate().getTransacted();
        }

        public int getSessionMode() {
            return this.getDelegate().getSessionMode();
        }

        public void commit() {
            throw MessagingLogger.ROOT_LOGGER.callNotPermittedOnInjectedJMSContext();
        }

        public void rollback() {
            throw MessagingLogger.ROOT_LOGGER.callNotPermittedOnInjectedJMSContext();
        }

        public void recover() {
            throw MessagingLogger.ROOT_LOGGER.callNotPermittedOnInjectedJMSContext();
        }

        public JMSConsumer createConsumer(Destination destination) {
            return this.getDelegate().createConsumer(destination);
        }

        public JMSConsumer createConsumer(Destination destination, String messageSelector) {
            return this.getDelegate().createConsumer(destination, messageSelector);
        }

        public JMSConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) {
            return this.getDelegate().createConsumer(destination, messageSelector, noLocal);
        }

        public Queue createQueue(String queueName) {
            return this.getDelegate().createQueue(queueName);
        }

        public Topic createTopic(String topicName) {
            return this.getDelegate().createTopic(topicName);
        }

        public JMSConsumer createDurableConsumer(Topic topic, String name) {
            return this.getDelegate().createDurableConsumer(topic, name);
        }

        public JMSConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) {
            return this.getDelegate().createDurableConsumer(topic, name, messageSelector, noLocal);
        }

        public JMSConsumer createSharedDurableConsumer(Topic topic, String name) {
            return this.getDelegate().createSharedDurableConsumer(topic, name);
        }

        public JMSConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) {
            return this.getDelegate().createSharedDurableConsumer(topic, name, messageSelector);
        }

        public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) {
            return this.getDelegate().createSharedConsumer(topic, sharedSubscriptionName);
        }

        public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) {
            return this.getDelegate().createSharedConsumer(topic, sharedSubscriptionName, messageSelector);
        }

        public QueueBrowser createBrowser(Queue queue) {
            return this.getDelegate().createBrowser(queue);
        }

        public QueueBrowser createBrowser(Queue queue, String messageSelector) {
            return this.getDelegate().createBrowser(queue, messageSelector);
        }

        public TemporaryQueue createTemporaryQueue() {
            return this.getDelegate().createTemporaryQueue();
        }

        public TemporaryTopic createTemporaryTopic() {
            return this.getDelegate().createTemporaryTopic();
        }

        public void unsubscribe(String name) {
            this.getDelegate().unsubscribe(name);
        }

        public void acknowledge() {
            throw MessagingLogger.ROOT_LOGGER.callNotPermittedOnInjectedJMSContext();
        }

        public String toString() {
            return "JMSContextWrapper{, delegate=" + this.getDelegate() + ", inTransaction=" + this.inTransaction + '}';
        }
    }

    private final class JMSInfo {
        private final String connectionFactoryLookup;
        private final String userName;
        private final String password;
        private final int ackMode;

        JMSInfo(String connectionFactoryLookup, String userName, String password, int ackMode) {
            this.connectionFactoryLookup = connectionFactoryLookup;
            this.userName = userName;
            this.password = password;
            this.ackMode = ackMode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JMSInfo jmsInfo = (JMSInfo)o;
            if (this.ackMode != jmsInfo.ackMode) {
                return false;
            }
            if (this.connectionFactoryLookup != null ? !this.connectionFactoryLookup.equals(jmsInfo.connectionFactoryLookup) : jmsInfo.connectionFactoryLookup != null) {
                return false;
            }
            if (this.password != null ? !this.password.equals(jmsInfo.password) : jmsInfo.password != null) {
                return false;
            }
            return !(this.userName != null ? !this.userName.equals(jmsInfo.userName) : jmsInfo.userName != null);
        }

        public int hashCode() {
            int result = this.connectionFactoryLookup != null ? this.connectionFactoryLookup.hashCode() : 0;
            result = 31 * result + (this.userName != null ? this.userName.hashCode() : 0);
            result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
            result = 31 * result + this.ackMode;
            return result;
        }
    }
}

