/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.MultistepUtil;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.web.WebAccessLogDefinition;
import org.jboss.as.web.WebConnectorDefinition;
import org.jboss.as.web.WebDefinition;
import org.jboss.as.web.WebExtension;
import org.jboss.as.web.WebLogger;
import org.jboss.as.web.WebSSLDefinition;
import org.jboss.as.web.WebSSODefinition;
import org.jboss.as.web.WebStaticResources;
import org.jboss.as.web.WebValveDefinition;
import org.jboss.as.web.WebVirtualHostDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.ValueExpression;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.filters.CustomFilterDefinition;
import org.wildfly.extension.undertow.filters.ExpressionFilterDefinition;

public class WebMigrateOperation
implements OperationStepHandler {
    private static final String UNDERTOW_EXTENSION = "org.wildfly.extension.undertow";
    private static final String IO_EXTENSION = "org.wildfly.extension.io";
    private static final String REALM_NAME = "jbossweb-migration-security-realm";
    private static final OperationStepHandler DESCRIBE_MIGRATION_INSTANCE = new WebMigrateOperation(true);
    private static final OperationStepHandler MIGRATE_INSTANCE = new WebMigrateOperation(false);
    public static final PathElement DEFAULT_SERVER_PATH = PathElement.pathElement((String)"server", (String)"default-server");
    public static final PathAddress EXTENSION_ADDRESS = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"extension", (String)"org.jboss.as.web")});
    private static final PathAddress VALVE_ACCESS_LOG_ADDRESS = PathAddress.pathAddress((PathElement[])new PathElement[]{UndertowExtension.SUBSYSTEM_PATH, DEFAULT_SERVER_PATH, PathElement.pathElement((String)"host"), UndertowExtension.PATH_ACCESS_LOG});
    public static final String MIGRATE = "migrate";
    public static final String MIGRATION_WARNINGS = "migration-warnings";
    public static final String MIGRATION_ERROR = "migration-error";
    public static final String MIGRATION_OPERATIONS = "migration-operations";
    public static final String DESCRIBE_MIGRATION = "describe-migration";
    private static final Pattern ACCESS_LOG_PATTERN = Pattern.compile("%\\{(.*?)\\}(\\w)");
    public static final StringListAttributeDefinition MIGRATION_WARNINGS_ATTR = ((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("migration-warnings").setAllowNull(true)).build();
    public static final SimpleMapAttributeDefinition MIGRATION_ERROR_ATTR = ((SimpleMapAttributeDefinition.Builder)new SimpleMapAttributeDefinition.Builder("migration-error", ModelType.OBJECT, true).setValueType(ModelType.OBJECT).setAllowNull(true)).build();
    private static final Map<String, ValveHandler> VALVES_TO_FILTERS = new HashMap<String, ValveHandler>(){
        {
            this.put("org.apache.catalina.valves.RemoteHostValve", new ValveHandler("io.undertow.server.handlers.AccessControlListHandler", "io.undertow.core"));
            this.put("org.apache.catalina.valves.RemoteAddrValve", new ValveHandler("io.undertow.server.handlers.IPAddressAccessControlHandler", "io.undertow.core"));
            this.put("org.apache.catalina.valves.RemoteIpValve", new ValveHandler("io.undertow.server.handlers.ProxyPeerAddressHandler", "io.undertow.core"));
            this.put("org.apache.catalina.valves.StuckThreadDetectionValve", new ValveHandler("io.undertow.server.handlers.StuckThreadDetectionHandler", "io.undertow.core"));
        }
    };
    private final boolean describe;

    private WebMigrateOperation(boolean describe) {
        this.describe = describe;
    }

    static void registerOperations(ManagementResourceRegistration registry, ResourceDescriptionResolver resourceDescriptionResolver) {
        registry.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder(MIGRATE, resourceDescriptionResolver).setRuntimeOnly().setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.READ_WHOLE_CONFIG}).setReplyParameters(new AttributeDefinition[]{MIGRATION_WARNINGS_ATTR, MIGRATION_ERROR_ATTR}).build(), MIGRATE_INSTANCE);
        registry.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder(DESCRIBE_MIGRATION, resourceDescriptionResolver).setRuntimeOnly().setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.READ_WHOLE_CONFIG}).setReplyParameters(new AttributeDefinition[]{MIGRATION_WARNINGS_ATTR}).build(), DESCRIBE_MIGRATION_INSTANCE);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (!this.describe && context.getRunningMode() != RunningMode.ADMIN_ONLY) {
            throw WebLogger.ROOT_LOGGER.migrateOperationAllowedOnlyInAdminOnly();
        }
        final ArrayList warnings = new ArrayList();
        final ModelNode legacyModelAddOps = new ModelNode();
        final TreeMap<PathAddress, ModelNode> sortedMigrationOperations = new TreeMap<PathAddress, ModelNode>(new Comparator<PathAddress>(){

            @Override
            public int compare(PathAddress o1, PathAddress o2) {
                int compare = Integer.compare(o1.size(), o2.size());
                if (compare != 0) {
                    return compare;
                }
                return o1.toString().compareTo(o2.toString());
            }
        });
        this.describeLegacyWebResources(context, legacyModelAddOps);
        this.addExtension(context, sortedMigrationOperations, this.describe, UNDERTOW_EXTENSION);
        this.addExtension(context, sortedMigrationOperations, this.describe, IO_EXTENSION);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                WebMigrateOperation.this.addDefaultResources(sortedMigrationOperations, legacyModelAddOps, warnings);
                boolean domainMode = context.getCallEnvironment().getProcessType() != ProcessType.STANDALONE_SERVER;
                PathAddress baseAddres = domainMode ? PathAddress.pathAddress((ModelNode)operation.get("address")).getParent() : PathAddress.pathAddress((PathElement[])new PathElement[0]);
                WebMigrateOperation.this.createIoSubsystem(context, sortedMigrationOperations, baseAddres);
                WebMigrateOperation.this.createWelcomeContentHandler(sortedMigrationOperations);
                WebMigrateOperation.this.transformResources(context, legacyModelAddOps, sortedMigrationOperations, warnings, domainMode);
                WebMigrateOperation.this.fixAddressesForDomainMode(PathAddress.pathAddress((ModelNode)operation.get("address")), sortedMigrationOperations);
                final LinkedHashMap orderedMigrationOperations = new LinkedHashMap(sortedMigrationOperations);
                WebMigrateOperation.this.removeWebSubsystem(orderedMigrationOperations, context.getProcessType() == ProcessType.STANDALONE_SERVER, PathAddress.pathAddress((ModelNode)operation.get("address")));
                if (WebMigrateOperation.this.describe) {
                    Collection values = orderedMigrationOperations.values();
                    ModelNode result = new ModelNode();
                    if (!warnings.isEmpty()) {
                        ModelNode rw = new ModelNode().setEmptyList();
                        for (String warning : warnings) {
                            rw.add(warning);
                        }
                        result.get(WebMigrateOperation.MIGRATION_WARNINGS).set(rw);
                    }
                    result.get(WebMigrateOperation.MIGRATION_OPERATIONS).set(values);
                    context.getResult().set(result);
                } else {
                    final Map migrateOpResponses = WebMigrateOperation.this.migrateSubsystems(context, orderedMigrationOperations);
                    context.completeStep(new OperationContext.ResultHandler(){

                        public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                            ModelNode result = new ModelNode();
                            ModelNode rw = new ModelNode().setEmptyList();
                            for (String string : warnings) {
                                rw.add(string);
                            }
                            result.get(WebMigrateOperation.MIGRATION_WARNINGS).set(rw);
                            if (resultAction == OperationContext.ResultAction.ROLLBACK) {
                                for (Map.Entry entry : migrateOpResponses.entrySet()) {
                                    if (!((ModelNode)entry.getValue()).hasDefined("failure-description")) continue;
                                    ModelNode desc = new ModelNode();
                                    desc.get("operation").set((ModelNode)orderedMigrationOperations.get(entry.getKey()));
                                    desc.get("result").set((ModelNode)entry.getValue());
                                    result.get(WebMigrateOperation.MIGRATION_ERROR).set(desc);
                                    break;
                                }
                                context.getFailureDescription().set(new ModelNode(WebLogger.ROOT_LOGGER.migrationFailed()));
                            }
                            context.getResult().set(result);
                        }
                    });
                }
            }
        }, OperationContext.Stage.MODEL);
    }

    private SSLInformation createSecurityRealm(OperationContext context, Map<PathAddress, ModelNode> migrationOperations, ModelNode legacyModelAddOps, String connector, List<String> warnings, boolean domainMode) {
        String realmName;
        ModelNode legacyAddOp = WebMigrateOperation.findResource(PathAddress.pathAddress((PathElement[])new PathElement[]{WebExtension.SUBSYSTEM_PATH, PathElement.pathElement((String)WebExtension.CONNECTOR_PATH.getKey(), (String)connector), PathElement.pathElement((String)"configuration", (String)"ssl")}), legacyModelAddOps);
        if (legacyAddOp == null) {
            return null;
        }
        ModelNode keyAlias = legacyAddOp.get(WebSSLDefinition.KEY_ALIAS.getName());
        ModelNode password = legacyAddOp.get(WebSSLDefinition.PASSWORD.getName());
        ModelNode certificateKeyFile = legacyAddOp.get(WebSSLDefinition.CERTIFICATE_KEY_FILE.getName());
        ModelNode cipherSuite = legacyAddOp.get(WebSSLDefinition.CIPHER_SUITE.getName());
        ModelNode protocol = legacyAddOp.get(WebSSLDefinition.PROTOCOL.getName());
        ModelNode verifyClient = legacyAddOp.get(WebSSLDefinition.VERIFY_CLIENT.getName());
        ModelNode verifyDepth = legacyAddOp.get(WebSSLDefinition.VERIFY_DEPTH.getName());
        ModelNode certificateFile = legacyAddOp.get(WebSSLDefinition.CERTIFICATE_FILE.getName());
        ModelNode caCertificateFile = legacyAddOp.get(WebSSLDefinition.CA_CERTIFICATE_FILE.getName());
        ModelNode caCertificatePassword = legacyAddOp.get(WebSSLDefinition.CA_CERTIFICATE_PASSWORD.getName());
        ModelNode csRevocationURL = legacyAddOp.get(WebSSLDefinition.CA_REVOCATION_URL.getName());
        ModelNode trustStoreType = legacyAddOp.get(WebSSLDefinition.TRUSTSTORE_TYPE.getName());
        ModelNode keystoreType = legacyAddOp.get(WebSSLDefinition.KEYSTORE_TYPE.getName());
        ModelNode sessionCacheSize = legacyAddOp.get(WebSSLDefinition.SESSION_CACHE_SIZE.getName());
        ModelNode sessionTimeout = legacyAddOp.get(WebSSLDefinition.SESSION_TIMEOUT.getName());
        ModelNode sslProvider = legacyAddOp.get(WebSSLDefinition.SSL_PROTOCOL.getName());
        if (verifyDepth.isDefined()) {
            warnings.add(WebLogger.ROOT_LOGGER.couldNotMigrateResource(WebSSLDefinition.VERIFY_DEPTH.getName(), PathAddress.pathAddress((ModelNode)legacyAddOp.get("address"))));
        }
        if (certificateFile.isDefined()) {
            warnings.add(WebLogger.ROOT_LOGGER.couldNotMigrateResource(WebSSLDefinition.CERTIFICATE_FILE.getName(), PathAddress.pathAddress((ModelNode)legacyAddOp.get("address"))));
        }
        if (sslProvider.isDefined()) {
            warnings.add(WebLogger.ROOT_LOGGER.couldNotMigrateResource(WebSSLDefinition.SSL_PROTOCOL.getName(), PathAddress.pathAddress((ModelNode)legacyAddOp.get("address"))));
        }
        if (csRevocationURL.isDefined()) {
            warnings.add(WebLogger.ROOT_LOGGER.couldNotMigrateResource(WebSSLDefinition.CA_REVOCATION_URL.getName(), PathAddress.pathAddress((ModelNode)legacyAddOp.get("address"))));
        }
        if (domainMode) {
            boolean hostOk;
            HashSet hosts = new HashSet();
            Resource hostResource = context.readResourceFromRoot(PathAddress.pathAddress((PathElement[])new PathElement[0]), false);
            hosts.addAll(hostResource.getChildrenNames("host"));
            int counter = 1;
            realmName = REALM_NAME + counter;
            block0: do {
                hostOk = true;
                for (String host : hosts) {
                    Resource root = context.readResourceFromRoot(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"host", (String)host), PathElement.pathElement((String)"core-service", (String)"management")}), false);
                    if (!root.getChildrenNames("security-realm").contains(realmName)) continue;
                    realmName = REALM_NAME + ++counter;
                    hostOk = false;
                    continue block0;
                }
            } while (!hostOk);
            for (String host : hosts) {
                this.createHostSSLConfig(realmName, migrationOperations, keyAlias, password, certificateKeyFile, protocol, caCertificateFile, caCertificatePassword, trustStoreType, keystoreType, PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"host", (String)host), PathElement.pathElement((String)"core-service", (String)"management")}));
            }
        } else {
            PathAddress managementCoreService = PathAddress.pathAddress((String)"core-service", (String)"management");
            int counter = 1;
            realmName = REALM_NAME + counter;
            boolean ok = false;
            do {
                Resource root;
                if ((root = context.readResourceFromRoot(managementCoreService, false)).getChildrenNames("security-realm").contains(realmName)) {
                    realmName = REALM_NAME + ++counter;
                    continue;
                }
                ok = true;
            } while (!ok);
            this.createHostSSLConfig(realmName, migrationOperations, keyAlias, password, certificateKeyFile, protocol, caCertificateFile, caCertificatePassword, trustStoreType, keystoreType, managementCoreService);
        }
        return new SSLInformation(realmName, verifyClient, sessionCacheSize, sessionTimeout, protocol, cipherSuite);
    }

    private String createHostSSLConfig(String realmName, Map<PathAddress, ModelNode> migrationOperations, ModelNode keyAlias, ModelNode password, ModelNode certificateKeyFile, ModelNode protocol, ModelNode caCertificateFile, ModelNode caCertificatePassword, ModelNode trustStoreType, ModelNode keystoreType, PathAddress managementCoreService) {
        PathAddress addres = PathAddress.pathAddress((PathAddress)managementCoreService, (PathElement[])new PathElement[]{PathElement.pathElement((String)"security-realm", (String)realmName)});
        migrationOperations.put(addres, Util.createAddOperation((PathAddress)addres));
        addres = PathAddress.pathAddress((PathAddress)managementCoreService, (PathElement[])new PathElement[]{PathElement.pathElement((String)"security-realm", (String)realmName), PathElement.pathElement((String)"authentication", (String)"truststore")});
        ModelNode addOp = Util.createAddOperation((PathAddress)addres);
        addOp.get("keystore-path").set(caCertificateFile);
        addOp.get("keystore-password").set(password);
        addOp.get("keystore-provider").set(trustStoreType);
        migrationOperations.put(addres, addOp);
        addres = PathAddress.pathAddress((PathAddress)managementCoreService, (PathElement[])new PathElement[]{PathElement.pathElement((String)"security-realm", (String)realmName), PathElement.pathElement((String)"server-identity", (String)"ssl")});
        addOp = Util.createAddOperation((PathAddress)addres);
        addOp.get("keystore-path").set(certificateKeyFile);
        addOp.get("keystore-password").set(password);
        addOp.get("keystore-provider").set(keystoreType);
        addOp.get("alias").set(keyAlias);
        addOp.get("protocol").set(protocol);
        migrationOperations.put(addres, addOp);
        return realmName;
    }

    private void fixAddressesForDomainMode(PathAddress migrateAddress, Map<PathAddress, ModelNode> migrationOperations) {
        int i;
        for (i = 0; i < migrateAddress.size() && !migrateAddress.getElement(i).equals(WebExtension.SUBSYSTEM_PATH); ++i) {
        }
        if (i == 0) {
            return;
        }
        PathAddress prefix = migrateAddress.subAddress(0, i);
        HashMap<PathAddress, ModelNode> old = new HashMap<PathAddress, ModelNode>(migrationOperations);
        migrationOperations.clear();
        for (Map.Entry e : old.entrySet()) {
            if (((PathAddress)e.getKey()).getElement(0).getKey().equals("subsystem")) {
                PathAddress oldAddress = PathAddress.pathAddress((ModelNode)((ModelNode)e.getValue()).get("address"));
                ArrayList<PathElement> elements = new ArrayList<PathElement>();
                for (PathElement j : prefix) {
                    elements.add(j);
                }
                for (PathElement j : oldAddress) {
                    elements.add(j);
                }
                PathAddress newAddress = PathAddress.pathAddress(elements);
                ((ModelNode)e.getValue()).get("address").set(newAddress.toModelNode());
                migrationOperations.put(newAddress, (ModelNode)e.getValue());
                continue;
            }
            migrationOperations.put((PathAddress)e.getKey(), (ModelNode)e.getValue());
        }
    }

    private void createIoSubsystem(OperationContext context, Map<PathAddress, ModelNode> migrationOperations, PathAddress baseAddress) {
        Resource root = context.readResourceFromRoot(baseAddress, false);
        if (root.getChildrenNames("subsystem").contains("io")) {
            return;
        }
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"io")});
        migrationOperations.put(address, Util.createAddOperation((PathAddress)address));
        address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"io"), PathElement.pathElement((String)"worker", (String)"default")});
        migrationOperations.put(address, Util.createAddOperation((PathAddress)address));
        address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"io"), PathElement.pathElement((String)"buffer-pool", (String)"default")});
        migrationOperations.put(address, Util.createAddOperation((PathAddress)address));
    }

    private void createWelcomeContentHandler(Map<PathAddress, ModelNode> migrationOperations) {
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"undertow"), PathElement.pathElement((String)"configuration", (String)"handler")});
        migrationOperations.put(address, Util.createAddOperation((PathAddress)address));
        address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"undertow"), PathElement.pathElement((String)"configuration", (String)"handler"), PathElement.pathElement((String)"file", (String)"welcome-content")});
        ModelNode add = Util.createAddOperation((PathAddress)address);
        add.get("path").set(new ModelNode(new ValueExpression("${jboss.home.dir}/welcome-content")));
        migrationOperations.put(address, add);
    }

    private void addDefaultResources(Map<PathAddress, ModelNode> migrationOperations, ModelNode legacyModelDescription, List<String> warnings) {
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"undertow"), DEFAULT_SERVER_PATH});
        ModelNode add = Util.createAddOperation((PathAddress)address);
        ModelNode defaultSessionTimeout = null;
        ModelNode directoryListing = null;
        ModelNode sendfile = null;
        ModelNode fileEncoding = null;
        ModelNode readOnly = null;
        ModelNode webdav = null;
        ModelNode secret = null;
        ModelNode maxDepth = null;
        ModelNode disabled = null;
        for (ModelNode legacyAddOp : legacyModelDescription.get("result").asList()) {
            PathAddress la = PathAddress.pathAddress((ModelNode)legacyAddOp.get("address"));
            if (la.equals(PathAddress.pathAddress((PathElement[])new PathElement[]{WebExtension.SUBSYSTEM_PATH}))) {
                ModelNode sessionTimeout;
                ModelNode defaultHost = legacyAddOp.get(WebDefinition.DEFAULT_VIRTUAL_SERVER.getName());
                if (defaultHost.isDefined()) {
                    add.get("default-host").set(defaultHost.clone());
                }
                if (!(sessionTimeout = legacyAddOp.get(WebDefinition.DEFAULT_SESSION_TIMEOUT.getName())).isDefined()) continue;
                defaultSessionTimeout = sessionTimeout;
                continue;
            }
            if (!la.equals(PathAddress.pathAddress((PathElement[])new PathElement[]{WebExtension.SUBSYSTEM_PATH, WebExtension.STATIC_RESOURCES_PATH}))) continue;
            ModelNode node = legacyAddOp.get(WebStaticResources.LISTINGS.getName());
            if (node.isDefined()) {
                directoryListing = node;
            }
            if ((node = legacyAddOp.get(WebStaticResources.SENDFILE.getName())).isDefined()) {
                warnings.add(WebLogger.ROOT_LOGGER.couldNotMigrateResource(WebStaticResources.SENDFILE.getName(), PathAddress.pathAddress((ModelNode)legacyAddOp.get("address"))));
                sendfile = node;
            }
            if ((node = legacyAddOp.get(WebStaticResources.FILE_ENCODING.getName())).isDefined()) {
                warnings.add(WebLogger.ROOT_LOGGER.couldNotMigrateResource(WebStaticResources.FILE_ENCODING.getName(), PathAddress.pathAddress((ModelNode)legacyAddOp.get("address"))));
                fileEncoding = node;
            }
            if ((node = legacyAddOp.get(WebStaticResources.READ_ONLY.getName())).isDefined()) {
                warnings.add(WebLogger.ROOT_LOGGER.couldNotMigrateResource(WebStaticResources.READ_ONLY.getName(), PathAddress.pathAddress((ModelNode)legacyAddOp.get("address"))));
                readOnly = node;
            }
            if ((node = legacyAddOp.get(WebStaticResources.WEBDAV.getName())).isDefined()) {
                warnings.add(WebLogger.ROOT_LOGGER.couldNotMigrateResource(WebStaticResources.WEBDAV.getName(), PathAddress.pathAddress((ModelNode)legacyAddOp.get("address"))));
                webdav = node;
            }
            if ((node = legacyAddOp.get(WebStaticResources.SECRET.getName())).isDefined()) {
                warnings.add(WebLogger.ROOT_LOGGER.couldNotMigrateResource(WebStaticResources.SECRET.getName(), PathAddress.pathAddress((ModelNode)legacyAddOp.get("address"))));
                secret = node;
            }
            if ((node = legacyAddOp.get(WebStaticResources.MAX_DEPTH.getName())).isDefined()) {
                warnings.add(WebLogger.ROOT_LOGGER.couldNotMigrateResource(WebStaticResources.MAX_DEPTH.getName(), PathAddress.pathAddress((ModelNode)legacyAddOp.get("address"))));
                maxDepth = node;
            }
            if (!(node = legacyAddOp.get(WebStaticResources.DISABLED.getName())).isDefined()) continue;
            warnings.add(WebLogger.ROOT_LOGGER.couldNotMigrateResource(WebStaticResources.DISABLED.getName(), PathAddress.pathAddress((ModelNode)legacyAddOp.get("address"))));
            disabled = node;
        }
        migrationOperations.put(address, add);
        address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"undertow"), PathElement.pathElement((String)"buffer-cache", (String)"default")});
        add = Util.createAddOperation((PathAddress)address);
        migrationOperations.put(address, add);
        address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"undertow"), PathElement.pathElement((String)"servlet-container", (String)"default")});
        add = Util.createAddOperation((PathAddress)address);
        if (defaultSessionTimeout != null) {
            add.get("default-session-timeout").set(defaultSessionTimeout.clone());
        }
        if (directoryListing != null) {
            add.get("directory-listing").set(directoryListing);
        }
        migrationOperations.put(address, add);
    }

    private void addExtension(OperationContext context, Map<PathAddress, ModelNode> migrationOperations, boolean describe, String extension) {
        Resource root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, false);
        if (root.getChildrenNames("extension").contains(extension)) {
            return;
        }
        PathAddress extensionAddress = PathAddress.pathAddress((String)"extension", (String)extension);
        OperationEntry addEntry = context.getRootResourceRegistration().getOperationEntry(extensionAddress, "add");
        ModelNode addOperation = Util.createAddOperation((PathAddress)extensionAddress);
        addOperation.get("module").set(extension);
        if (describe) {
            migrationOperations.put(extensionAddress, addOperation);
        } else {
            context.addStep(context.getResult().get(extensionAddress.toString()), addOperation, addEntry.getOperationHandler(), OperationContext.Stage.MODEL);
        }
    }

    private void removeWebSubsystem(Map<PathAddress, ModelNode> migrationOperations, boolean standalone, PathAddress subsystemAddress) {
        ModelNode removeOperation = Util.createRemoveOperation((PathAddress)subsystemAddress);
        migrationOperations.put(subsystemAddress, removeOperation);
        if (standalone) {
            removeOperation = Util.createRemoveOperation((PathAddress)EXTENSION_ADDRESS);
            migrationOperations.put(EXTENSION_ADDRESS, removeOperation);
        }
    }

    private Map<PathAddress, ModelNode> migrateSubsystems(OperationContext context, Map<PathAddress, ModelNode> migrationOperations) throws OperationFailedException {
        LinkedHashMap<PathAddress, ModelNode> result = new LinkedHashMap<PathAddress, ModelNode>();
        MultistepUtil.recordOperationSteps((OperationContext)context, migrationOperations, result);
        return result;
    }

    private void transformResources(OperationContext context, ModelNode legacyModelDescription, Map<PathAddress, ModelNode> newAddOperations, List<String> warnings, boolean domainMode) throws OperationFailedException {
        for (ModelNode legacyAddOp : legacyModelDescription.get("result").asList()) {
            ModelNode newAddOp = legacyAddOp.clone();
            PathAddress address = PathAddress.pathAddress((ModelNode)newAddOp.get("address"));
            if (address.size() == 1) {
                this.migrateSubsystem(newAddOperations, newAddOp);
                continue;
            }
            if (address.equals(PathAddress.pathAddress((PathElement[])new PathElement[]{WebExtension.SUBSYSTEM_PATH, WebExtension.STATIC_RESOURCES_PATH}))) continue;
            if (address.equals(PathAddress.pathAddress((PathElement[])new PathElement[]{WebExtension.SUBSYSTEM_PATH, WebExtension.JSP_CONFIGURATION_PATH}))) {
                this.migrateJSPConfig(newAddOperations, newAddOp);
                continue;
            }
            if (address.equals(PathAddress.pathAddress((PathElement[])new PathElement[]{WebExtension.SUBSYSTEM_PATH, WebExtension.CONTAINER_PATH}))) {
                this.migrateMimeMapping(newAddOperations, newAddOp);
                continue;
            }
            if (this.wildcardEquals(address, PathAddress.pathAddress((PathElement[])new PathElement[]{WebExtension.SUBSYSTEM_PATH, WebExtension.CONNECTOR_PATH}))) {
                this.migrateConnector(context, newAddOperations, newAddOp, address, legacyModelDescription, warnings, domainMode);
                continue;
            }
            if (this.wildcardEquals(address, PathAddress.pathAddress((PathElement[])new PathElement[]{WebExtension.SUBSYSTEM_PATH, WebExtension.CONNECTOR_PATH, WebExtension.SSL_PATH}))) continue;
            if (this.wildcardEquals(address, PathAddress.pathAddress((PathElement[])new PathElement[]{WebExtension.SUBSYSTEM_PATH, WebExtension.HOST_PATH}))) {
                this.migrateVirtualHost(newAddOperations, newAddOp, address);
                continue;
            }
            if (this.wildcardEquals(address, PathAddress.pathAddress((PathElement[])new PathElement[]{WebExtension.SUBSYSTEM_PATH, WebExtension.VALVE_PATH}))) {
                this.migrateValves(newAddOperations, newAddOp, address, warnings);
                continue;
            }
            if (this.wildcardEquals(address, PathAddress.pathAddress((PathElement[])new PathElement[]{WebExtension.SUBSYSTEM_PATH, WebExtension.HOST_PATH, WebExtension.ACCESS_LOG_PATH}))) {
                this.migrateAccessLog(newAddOperations, newAddOp, address, legacyModelDescription, warnings);
                continue;
            }
            if (this.wildcardEquals(address, PathAddress.pathAddress((PathElement[])new PathElement[]{WebExtension.SUBSYSTEM_PATH, WebExtension.HOST_PATH, WebExtension.ACCESS_LOG_PATH, WebExtension.DIRECTORY_PATH}))) continue;
            if (this.wildcardEquals(address, PathAddress.pathAddress((PathElement[])new PathElement[]{WebExtension.SUBSYSTEM_PATH, WebExtension.HOST_PATH, WebExtension.SSO_PATH}))) {
                this.migrateSso(newAddOperations, newAddOp, address, warnings);
                continue;
            }
            warnings.add(WebLogger.ROOT_LOGGER.couldNotMigrateResource(legacyAddOp));
        }
        newAddOperations.remove(VALVE_ACCESS_LOG_ADDRESS);
    }

    private void migrateSso(Map<PathAddress, ModelNode> newAddOperations, ModelNode newAddOp, PathAddress address, List<String> warnings) {
        PathAddress newAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{UndertowExtension.SUBSYSTEM_PATH, DEFAULT_SERVER_PATH, PathElement.pathElement((String)"host", (String)address.getElement(address.size() - 2).getValue()), UndertowExtension.PATH_SSO});
        ModelNode add = Util.createAddOperation((PathAddress)newAddress);
        add.get("domain").set(newAddOp.get(WebSSODefinition.DOMAIN.getName()).clone());
        add.get("http-only").set(newAddOp.get(WebSSODefinition.HTTP_ONLY.getName()).clone());
        if (newAddOp.hasDefined(WebSSODefinition.CACHE_CONTAINER.getName())) {
            warnings.add(WebLogger.ROOT_LOGGER.couldNotMigrateResource(WebSSODefinition.CACHE_CONTAINER.getName(), PathAddress.pathAddress((ModelNode)newAddOp.get("address"))));
        }
        if (newAddOp.hasDefined(WebSSODefinition.REAUTHENTICATE.getName())) {
            warnings.add(WebLogger.ROOT_LOGGER.couldNotMigrateResource(WebSSODefinition.REAUTHENTICATE.getName(), PathAddress.pathAddress((ModelNode)newAddOp.get("address"))));
        }
        if (newAddOp.hasDefined(WebSSODefinition.CACHE_NAME.getName())) {
            warnings.add(WebLogger.ROOT_LOGGER.couldNotMigrateResource(WebSSODefinition.CACHE_NAME.getName(), PathAddress.pathAddress((ModelNode)newAddOp.get("address"))));
        }
        newAddOperations.put(newAddress, add);
    }

    private void migrateAccessLog(Map<PathAddress, ModelNode> newAddOperations, ModelNode newAddOp, PathAddress address, ModelNode legacyAddOps, List<String> warnings) {
        PathAddress newAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{UndertowExtension.SUBSYSTEM_PATH, DEFAULT_SERVER_PATH, PathElement.pathElement((String)"host", (String)address.getElement(address.size() - 2).getValue()), UndertowExtension.PATH_ACCESS_LOG});
        ModelNode add = Util.createAddOperation((PathAddress)newAddress);
        ModelNode patternNode = newAddOp.get(WebAccessLogDefinition.PATTERN.getName());
        if (patternNode.isDefined()) {
            add.get("pattern").set(this.migrateAccessLogPattern(patternNode.asString()));
        }
        add.get("prefix").set(newAddOp.get(WebAccessLogDefinition.PREFIX.getName()).clone());
        add.get("rotate").set(newAddOp.get(WebAccessLogDefinition.ROTATE.getName()).clone());
        if (newAddOp.hasDefined(WebAccessLogDefinition.RESOLVE_HOSTS.getName())) {
            warnings.add(WebLogger.ROOT_LOGGER.couldNotMigrateResource(WebAccessLogDefinition.RESOLVE_HOSTS.getName(), PathAddress.pathAddress((ModelNode)newAddOp.get("address"))));
        }
        add.get("extended").set(newAddOp.get(WebAccessLogDefinition.EXTENDED.getName()).clone());
        ModelNode directory = WebMigrateOperation.findResource(PathAddress.pathAddress((PathAddress)PathAddress.pathAddress((ModelNode)newAddOp.get("address")), (PathElement[])new PathElement[]{WebExtension.DIRECTORY_PATH}), legacyAddOps);
        if (directory != null) {
            add.get("directory").set(directory.get("path"));
            add.get("relative-to").set(directory.get("relative-to"));
        }
        newAddOperations.put(newAddress, add);
    }

    private String migrateAccessLogPattern(String legacyPattern) {
        Matcher m = ACCESS_LOG_PATTERN.matcher(legacyPattern);
        StringBuilder sb = new StringBuilder();
        int lastIndex = 0;
        while (m.find()) {
            sb.append(legacyPattern.substring(lastIndex, m.start()));
            lastIndex = m.end();
            sb.append("%{");
            sb.append(m.group(2));
            sb.append(",");
            sb.append(m.group(1));
            sb.append("}");
        }
        sb.append(legacyPattern.substring(lastIndex));
        return sb.toString();
    }

    private void migrateAccessLogValve(Map<PathAddress, ModelNode> newAddOperations, ModelNode newAddOp, PathAddress address, ModelNode legacyAddOps, List<String> warnings) {
        String[] unsupportedConfigParams;
        ModelNode add = Util.createAddOperation((PathAddress)VALVE_ACCESS_LOG_ADDRESS);
        ModelNode params = newAddOp.get(WebValveDefinition.PARAMS.getName());
        ModelNode patternNode = params.get("pattern");
        if (patternNode.isDefined()) {
            add.get("pattern").set(this.migrateAccessLogPattern(patternNode.asString()));
        }
        add.get("prefix").set(params.get("prefix").clone());
        add.get("suffix").set(params.get("suffix").clone());
        add.get("rotate").set(params.get("rotatable").clone());
        add.get("extended").set(newAddOp.get("extended").clone());
        if (params.hasDefined("directory")) {
            add.get("directory").set(params.get("directory").clone());
        }
        if (params.hasDefined("conditionIf")) {
            add.get("predicate").set("exists(%{r," + params.get("conditionIf").asString() + "})");
        }
        if (params.hasDefined("conditionUnless")) {
            add.get("predicate").set("not exists(%{r," + params.get("conditionUnless").asString() + "})");
        }
        if (params.hasDefined("condition")) {
            add.get("predicate").set("not exists(%{r," + params.get("conditionUnless").asString() + "})");
        }
        for (String unsupportedConfigParam : unsupportedConfigParams = new String[]{"resolveHosts", "fileDateFormat", "renameOnRotate", "encoding", "locale", "requestAttributesEnabled", "buffered"}) {
            warnings.add(WebLogger.ROOT_LOGGER.couldNotMigrateResource(unsupportedConfigParam, PathAddress.pathAddress((ModelNode)newAddOp.get("address"))));
        }
        newAddOperations.put(VALVE_ACCESS_LOG_ADDRESS, add);
    }

    private boolean wildcardEquals(PathAddress a1, PathAddress a2) {
        if (a1.size() != a2.size()) {
            return false;
        }
        for (int i = 0; i < a1.size(); ++i) {
            PathElement p1 = a1.getElement(i);
            PathElement p2 = a2.getElement(i);
            if (!p1.getKey().equals(p2.getKey())) {
                return false;
            }
            if (p1.isWildcard() || p2.isWildcard() || p1.getValue().equals(p2.getValue())) continue;
            return false;
        }
        return true;
    }

    private void migrateVirtualHost(Map<PathAddress, ModelNode> newAddOperations, ModelNode newAddOp, PathAddress address) {
        PathAddress newAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{UndertowExtension.SUBSYSTEM_PATH, DEFAULT_SERVER_PATH, PathElement.pathElement((String)"host", (String)address.getLastElement().getValue())});
        ModelNode add = Util.createAddOperation((PathAddress)newAddress);
        if (newAddOp.hasDefined(WebVirtualHostDefinition.ENABLE_WELCOME_ROOT.getName()) && newAddOp.get(WebVirtualHostDefinition.ENABLE_WELCOME_ROOT.getName()).asBoolean()) {
            PathAddress welcomeAddress = PathAddress.pathAddress((PathAddress)newAddress, (PathElement[])new PathElement[]{PathElement.pathElement((String)"location", (String)"/")});
            ModelNode welcomeAdd = Util.createAddOperation((PathAddress)welcomeAddress);
            welcomeAdd.get("handler").set("welcome-content");
            newAddOperations.put(welcomeAddress, welcomeAdd);
        }
        add.get("alias").set(newAddOp.get(WebVirtualHostDefinition.ALIAS.getName()).clone());
        add.get("default-web-module").set(newAddOp.get(WebVirtualHostDefinition.DEFAULT_WEB_MODULE.getName()));
        newAddOperations.put(newAddress, add);
        PathAddress customFilterAddresses = PathAddress.pathAddress((PathElement[])new PathElement[]{UndertowExtension.SUBSYSTEM_PATH, UndertowExtension.PATH_FILTERS, PathElement.pathElement((String)CustomFilterDefinition.INSTANCE.getPathElement().getKey())});
        PathAddress expressionFilterAddresses = PathAddress.pathAddress((PathElement[])new PathElement[]{UndertowExtension.SUBSYSTEM_PATH, UndertowExtension.PATH_FILTERS, PathElement.pathElement((String)ExpressionFilterDefinition.INSTANCE.getPathElement().getKey())});
        ArrayList<PathAddress> filterAddresses = new ArrayList<PathAddress>();
        for (PathAddress a : newAddOperations.keySet()) {
            if (!this.wildcardEquals(customFilterAddresses, a) && !this.wildcardEquals(expressionFilterAddresses, a)) continue;
            filterAddresses.add(a);
        }
        for (PathAddress filterAddress : filterAddresses) {
            PathAddress filterRefAddress = PathAddress.pathAddress((PathAddress)newAddress, (PathElement[])new PathElement[]{PathElement.pathElement((String)"filter-ref", (String)filterAddress.getLastElement().getValue())});
            ModelNode filterRefAdd = Util.createAddOperation((PathAddress)filterRefAddress);
            newAddOperations.put(filterRefAddress, filterRefAdd);
        }
        PathAddress accessLogAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{UndertowExtension.SUBSYSTEM_PATH, DEFAULT_SERVER_PATH, PathElement.pathElement((String)"host", (String)address.getLastElement().getValue()), UndertowExtension.PATH_ACCESS_LOG});
        if (newAddOperations.containsKey(VALVE_ACCESS_LOG_ADDRESS) && !newAddOperations.containsKey(accessLogAddress)) {
            ModelNode operation = newAddOperations.get(VALVE_ACCESS_LOG_ADDRESS).clone();
            operation.get("address").set(accessLogAddress.toModelNode());
            newAddOperations.put(accessLogAddress, operation);
        }
    }

    private void migrateValves(Map<PathAddress, ModelNode> newAddOperations, ModelNode newAddOp, PathAddress address, List<String> warnings) {
        if (newAddOp.hasDefined(WebValveDefinition.CLASS_NAME.getName())) {
            String valveClassName = newAddOp.get(WebValveDefinition.CLASS_NAME.getName()).asString();
            if (valveClassName.equals("org.apache.catalina.valves.CrawlerSessionManagerValve")) {
                PathAddress crawlerAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"undertow"), PathElement.pathElement((String)"servlet-container", (String)"default"), PathElement.pathElement((String)"setting", (String)"crawler-session-management")});
                ModelNode crawlerAdd = Util.createAddOperation((PathAddress)crawlerAddress);
                if (newAddOp.hasDefined(WebValveDefinition.PARAMS.getName())) {
                    ModelNode params = newAddOp.get(WebValveDefinition.PARAMS.getName());
                    if (params.hasDefined("crawlerUserAgents")) {
                        crawlerAdd.get("user-agents").set(params.get("crawlerUserAgents"));
                    }
                    if (params.hasDefined("sessionInactiveInterval")) {
                        crawlerAdd.get("session-timeout").set(params.get("sessionInactiveInterval"));
                    }
                }
                newAddOperations.put(crawlerAddress, crawlerAdd);
            } else if (valveClassName.equals("org.apache.catalina.valves.RequestDumperValve")) {
                newAddOperations.putIfAbsent(PathAddress.pathAddress((PathElement[])new PathElement[]{UndertowExtension.SUBSYSTEM_PATH, UndertowExtension.PATH_FILTERS}), Util.createAddOperation((PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{UndertowExtension.SUBSYSTEM_PATH, UndertowExtension.PATH_FILTERS})));
                PathAddress filterAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{UndertowExtension.SUBSYSTEM_PATH, UndertowExtension.PATH_FILTERS, PathElement.pathElement((String)ExpressionFilterDefinition.INSTANCE.getPathElement().getKey(), (String)address.getLastElement().getValue())});
                ModelNode filterAdd = Util.createAddOperation((PathAddress)filterAddress);
                filterAdd.get(ExpressionFilterDefinition.EXPRESSION.getName()).set("dump-request");
                newAddOperations.put(filterAddress, filterAdd);
            } else if ("org.apache.catalina.valves.AccessLogValve".equals(valveClassName)) {
                newAddOp.get(WebAccessLogDefinition.EXTENDED.getName()).set(false);
                this.migrateAccessLogValve(newAddOperations, newAddOp, address, newAddOp, warnings);
            } else if ("org.apache.catalina.valves.ExtendedAccessLogValve".equals(valveClassName)) {
                newAddOp.get(WebAccessLogDefinition.EXTENDED.getName()).set(true);
                this.migrateAccessLogValve(newAddOperations, newAddOp, address, newAddOp, warnings);
            } else if (VALVES_TO_FILTERS.containsKey(valveClassName)) {
                newAddOperations.putIfAbsent(PathAddress.pathAddress((PathElement[])new PathElement[]{UndertowExtension.SUBSYSTEM_PATH, UndertowExtension.PATH_FILTERS}), Util.createAddOperation((PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{UndertowExtension.SUBSYSTEM_PATH, UndertowExtension.PATH_FILTERS})));
                PathAddress filterAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{UndertowExtension.SUBSYSTEM_PATH, UndertowExtension.PATH_FILTERS, PathElement.pathElement((String)CustomFilterDefinition.INSTANCE.getPathElement().getKey(), (String)address.getLastElement().getValue())});
                if (!newAddOperations.containsKey(filterAddress)) {
                    ModelNode filterAdd = Util.createAddOperation((PathAddress)filterAddress);
                    filterAdd.get("module").set(VALVES_TO_FILTERS.get(valveClassName).module);
                    filterAdd.get(CustomFilterDefinition.CLASS_NAME.getName()).set(VALVES_TO_FILTERS.get(valveClassName).handlerClassName);
                    if (newAddOp.hasDefined(WebValveDefinition.PARAMS.getName())) {
                        filterAdd.get(CustomFilterDefinition.PARAMETERS.getName()).set(newAddOp.get(WebValveDefinition.PARAMS.getName()));
                    }
                    newAddOperations.putIfAbsent(filterAddress, filterAdd);
                }
            } else {
                warnings.add(WebLogger.ROOT_LOGGER.couldNotMigrateResource(newAddOp));
            }
        }
    }

    private void migrateConnector(OperationContext context, Map<PathAddress, ModelNode> newAddOperations, ModelNode newAddOp, PathAddress address, ModelNode legacyModelAddOps, List<String> warnings, boolean domainMode) throws OperationFailedException {
        ModelNode addConnector;
        PathAddress newAddress;
        String protocol = newAddOp.get(WebConnectorDefinition.PROTOCOL.getName()).asString();
        String scheme = null;
        if (newAddOp.hasDefined(WebConnectorDefinition.SCHEME.getName())) {
            scheme = newAddOp.get(WebConnectorDefinition.SCHEME.getName()).asString();
        }
        switch (protocol) {
            case "org.apache.coyote.http11.Http11Protocol": 
            case "org.apache.coyote.http11.Http11NioProtocol": 
            case "org.apache.coyote.http11.Http11AprProtocol": 
            case "HTTP/1.1": {
                if (scheme == null || scheme.equals("http")) {
                    newAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{UndertowExtension.SUBSYSTEM_PATH, DEFAULT_SERVER_PATH, PathElement.pathElement((String)"http-listener", (String)address.getLastElement().getValue())});
                    addConnector = Util.createAddOperation((PathAddress)newAddress);
                    break;
                }
                if (scheme.equals("https")) {
                    newAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{UndertowExtension.SUBSYSTEM_PATH, DEFAULT_SERVER_PATH, PathElement.pathElement((String)"https-listener", (String)address.getLastElement().getValue())});
                    addConnector = Util.createAddOperation((PathAddress)newAddress);
                    SSLInformation sslInfo = this.createSecurityRealm(context, newAddOperations, legacyModelAddOps, newAddress.getLastElement().getValue(), warnings, domainMode);
                    if (sslInfo == null) {
                        throw WebLogger.ROOT_LOGGER.noSslConfig();
                    }
                    addConnector.get("security-realm").set(sslInfo.realmName);
                    ModelNode verify = sslInfo.verifyClient;
                    if (verify.isDefined()) {
                        if (verify.getType() == ModelType.EXPRESSION) {
                            warnings.add(WebLogger.ROOT_LOGGER.couldNotTranslateVerifyClientExpression(verify.toString()));
                            addConnector.get("verify-client").set(verify);
                        } else {
                            String translated = this.translateVerifyClient(verify.asString(), warnings);
                            if (translated != null) {
                                addConnector.get("verify-client").set(translated);
                            }
                        }
                    }
                    addConnector.get("ssl-session-cache-size").set(sslInfo.sessionCacheSize);
                    addConnector.get("ssl-session-timeout").set(sslInfo.sessionTimeout);
                    addConnector.get("enabled-protocols").set(sslInfo.sslProtocol);
                    addConnector.get("enabled-cipher-suites").set(sslInfo.cipherSuites);
                    break;
                }
                newAddress = null;
                addConnector = null;
                break;
            }
            case "org.apache.coyote.ajp.AjpAprProtocol": 
            case "org.apache.coyote.ajp.AjpProtocol": 
            case "AJP/1.3": {
                newAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{UndertowExtension.SUBSYSTEM_PATH, DEFAULT_SERVER_PATH, PathElement.pathElement((String)"ajp-listener", (String)address.getLastElement().getValue())});
                addConnector = Util.createAddOperation((PathAddress)newAddress);
                addConnector.get("scheme").set(newAddOp.get("scheme"));
                break;
            }
            default: {
                newAddress = null;
                addConnector = null;
            }
        }
        if (newAddress == null) {
            warnings.add(WebLogger.ROOT_LOGGER.couldNotMigrateResource(newAddOp));
            return;
        }
        addConnector.get("socket-binding").set(newAddOp.get("socket-binding"));
        addConnector.get("secure").set(newAddOp.get(WebConnectorDefinition.SECURE.getName()));
        addConnector.get("redirect-socket").set(newAddOp.get(WebConnectorDefinition.REDIRECT_BINDING.getName()));
        addConnector.get("enabled").set(newAddOp.get(WebConnectorDefinition.ENABLED.getName()));
        addConnector.get("resolve-peer-address").set(newAddOp.get(WebConnectorDefinition.ENABLE_LOOKUPS.getName()));
        addConnector.get("max-post-size").set(newAddOp.get(WebConnectorDefinition.MAX_POST_SIZE.getName()));
        addConnector.get("redirect-socket").set(newAddOp.get(WebConnectorDefinition.REDIRECT_BINDING.getName()));
        addConnector.get("max-connections").set(newAddOp.get(WebConnectorDefinition.MAX_CONNECTIONS.getName()));
        addConnector.get("max-buffered-request-size").set(newAddOp.get(WebConnectorDefinition.MAX_SAVE_POST_SIZE.getName()));
        addConnector.get("secure").set(newAddOp.get(WebConnectorDefinition.SECURE.getName()));
        if (newAddOp.hasDefined(WebConnectorDefinition.REDIRECT_PORT.getName())) {
            warnings.add(WebLogger.ROOT_LOGGER.couldNotMigrateResource(WebConnectorDefinition.REDIRECT_PORT.getName(), PathAddress.pathAddress((ModelNode)newAddOp.get("address"))));
        }
        if (newAddOp.hasDefined(WebConnectorDefinition.PROXY_BINDING.getName())) {
            warnings.add(WebLogger.ROOT_LOGGER.couldNotMigrateResource(WebConnectorDefinition.PROXY_BINDING.getName(), PathAddress.pathAddress((ModelNode)newAddOp.get("address"))));
        }
        if (newAddOp.hasDefined(WebConnectorDefinition.EXECUTOR.getName())) {
            warnings.add(WebLogger.ROOT_LOGGER.couldNotMigrateResource(WebConnectorDefinition.EXECUTOR.getName(), PathAddress.pathAddress((ModelNode)newAddOp.get("address"))));
        }
        newAddOperations.put(PathAddress.pathAddress((ModelNode)newAddOp.get("address")), addConnector);
    }

    private String translateVerifyClient(String s, List<String> warnings) {
        switch (s) {
            case "optionalNoCA": 
            case "optional": {
                return "REQUESTED";
            }
            case "require": {
                return "REQUIRED";
            }
            case "none": {
                return "NOT_REQUESTED";
            }
            case "true": {
                return "REQUIRED";
            }
            case "false": {
                return "NOT_REQUESTED";
            }
        }
        warnings.add(WebLogger.ROOT_LOGGER.couldNotTranslateVerifyClient(s));
        return null;
    }

    private void migrateMimeMapping(Map<PathAddress, ModelNode> newAddOperations, ModelNode newAddOp) {
        this.migrateWelcomeFiles(newAddOperations, newAddOp);
        ModelNode mime = newAddOp.get("mime-mapping");
        if (mime.isDefined()) {
            for (ModelNode w : mime.asList()) {
                PathAddress wa = PathAddress.pathAddress((PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{UndertowExtension.SUBSYSTEM_PATH, PathElement.pathElement((String)"servlet-container", (String)"default"), PathElement.pathElement((String)"mime-mapping", (String)w.asProperty().getName())}), (PathElement[])new PathElement[0]);
                ModelNode add = Util.createAddOperation((PathAddress)wa);
                add.get("value").set(w.asProperty().getValue());
                newAddOperations.put(wa, add);
            }
        }
    }

    private void migrateWelcomeFiles(Map<PathAddress, ModelNode> newAddOperations, ModelNode newAddOp) {
        ModelNode welcome = newAddOp.get("welcome-file");
        if (welcome.isDefined()) {
            for (ModelNode w : welcome.asList()) {
                PathAddress wa = PathAddress.pathAddress((PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{UndertowExtension.SUBSYSTEM_PATH, PathElement.pathElement((String)"servlet-container", (String)"default"), PathElement.pathElement((String)"welcome-file", (String)w.asString())}), (PathElement[])new PathElement[0]);
                ModelNode add = Util.createAddOperation((PathAddress)wa);
                newAddOperations.put(wa, add);
            }
        }
    }

    private void migrateJSPConfig(Map<PathAddress, ModelNode> newAddOperations, ModelNode newAddOp) {
        newAddOp.get("address").set(PathAddress.pathAddress((PathElement[])new PathElement[]{UndertowExtension.SUBSYSTEM_PATH, PathElement.pathElement((String)"servlet-container", (String)"default"), UndertowExtension.PATH_JSP}).toModelNode());
        newAddOperations.put(PathAddress.pathAddress((ModelNode)newAddOp.get("address")), newAddOp);
    }

    private void migrateSubsystem(Map<PathAddress, ModelNode> newAddOperations, ModelNode newAddOp) {
        newAddOp.get("address").set(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"undertow")}).toModelNode());
        PathAddress address = PathAddress.pathAddress((ModelNode)newAddOp.get("address"));
        newAddOperations.put(address, Util.createAddOperation((PathAddress)address));
    }

    private void describeLegacyWebResources(OperationContext context, ModelNode legacyModelDescription) {
        ModelNode describeLegacySubsystem = Util.createOperation((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (PathAddress)context.getCurrentAddress());
        context.addStep(legacyModelDescription, describeLegacySubsystem, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE, OperationContext.Stage.MODEL, true);
    }

    private static ModelNode findResource(PathAddress address, ModelNode legacyAddOps) {
        for (ModelNode legacyAddOp : legacyAddOps.get("result").asList()) {
            PathAddress la = PathAddress.pathAddress((ModelNode)legacyAddOp.get("address"));
            if (!la.equals(address)) continue;
            return legacyAddOp;
        }
        return null;
    }

    private static class ValveHandler {
        private String handlerClassName;
        private String module;

        private ValveHandler(String handlerClassName, String module) {
            this.handlerClassName = handlerClassName;
            this.module = module;
        }
    }

    private class SSLInformation {
        final String realmName;
        final ModelNode verifyClient;
        final ModelNode sessionCacheSize;
        final ModelNode sessionTimeout;
        final ModelNode sslProtocol;
        final ModelNode cipherSuites;

        private SSLInformation(String realmName, ModelNode verifyClient, ModelNode sessionCacheSize, ModelNode sessionTimeout, ModelNode sslProtocol, ModelNode cipherSuites) {
            this.realmName = realmName;
            this.verifyClient = verifyClient;
            this.sessionCacheSize = sessionCacheSize;
            this.sessionTimeout = sessionTimeout;
            this.sslProtocol = sslProtocol;
            this.cipherSuites = cipherSuites;
        }
    }
}

