/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice;

import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import javax.ejb.EJBException;
import javax.ejb.ScheduleExpression;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.timerservice.CalendarTimerTask;
import org.jboss.as.ejb3.timerservice.TimerImpl;
import org.jboss.as.ejb3.timerservice.TimerServiceImpl;
import org.jboss.as.ejb3.timerservice.TimerTask;
import org.jboss.as.ejb3.timerservice.persistence.TimeoutMethod;
import org.jboss.as.ejb3.timerservice.schedule.CalendarBasedTimeout;

public class CalendarTimer
extends TimerImpl {
    private final CalendarBasedTimeout calendarTimeout;
    private final boolean autoTimer;
    private final Method timeoutMethod;

    public CalendarTimer(Builder builder, TimerServiceImpl timerService) {
        super(builder, timerService);
        Calendar nextTimeout;
        this.autoTimer = builder.autoTimer;
        if (this.autoTimer) {
            assert (builder.timeoutMethod != null);
            this.timeoutMethod = builder.timeoutMethod;
        } else {
            assert (builder.timeoutMethod == null);
            this.timeoutMethod = null;
        }
        ScheduleExpression s = new ScheduleExpression();
        s.second(builder.scheduleExprSecond);
        s.minute(builder.scheduleExprMinute);
        s.hour(builder.scheduleExprHour);
        s.dayOfWeek(builder.scheduleExprDayOfWeek);
        s.dayOfMonth(builder.scheduleExprDayOfMonth);
        s.month(builder.scheduleExprMonth);
        s.year(builder.scheduleExprYear);
        s.start(builder.scheduleExprStartDate);
        s.end(builder.scheduleExprEndDate);
        s.timezone(builder.scheduleExprTimezone);
        this.calendarTimeout = new CalendarBasedTimeout(s);
        if (builder.nextDate == null && builder.newTimer && (nextTimeout = this.calendarTimeout.getNextTimeout()) != null) {
            this.nextExpiration = nextTimeout.getTime();
        }
    }

    @Override
    public ScheduleExpression getSchedule() throws IllegalStateException, EJBException {
        this.assertTimerState();
        return this.calendarTimeout.getScheduleExpression();
    }

    public ScheduleExpression getScheduleExpression() {
        return this.calendarTimeout.getScheduleExpression();
    }

    @Override
    public boolean isCalendarTimer() throws IllegalStateException, EJBException {
        this.assertTimerState();
        return true;
    }

    public CalendarBasedTimeout getCalendarTimeout() {
        return this.calendarTimeout;
    }

    @Override
    public boolean isAutoTimer() {
        return this.autoTimer;
    }

    @Override
    protected TimerTask<?> getTimerTask() {
        return new CalendarTimerTask(this);
    }

    public Method getTimeoutMethod() {
        if (!this.autoTimer) {
            throw EjbLogger.ROOT_LOGGER.failToInvokegetTimeoutMethod();
        }
        return this.timeoutMethod;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.handle == null) {
            return false;
        }
        if (!(obj instanceof CalendarTimer)) {
            return false;
        }
        CalendarTimer otherTimer = (CalendarTimer)obj;
        return this.handle.equals(otherTimer.getTimerHandle());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Method getTimeoutMethod(TimeoutMethod timeoutMethodInfo, ClassLoader classLoader) {
        if (timeoutMethodInfo == null) {
            return null;
        }
        String declaringClass = timeoutMethodInfo.getDeclaringClass();
        Class<?> timeoutMethodDeclaringClass = null;
        try {
            timeoutMethodDeclaringClass = Class.forName(declaringClass, false, classLoader);
        }
        catch (ClassNotFoundException cnfe) {
            throw EjbLogger.ROOT_LOGGER.failToLoadDeclaringClassOfTimeOut(declaringClass);
        }
        String timeoutMethodName = timeoutMethodInfo.getMethodName();
        String[] timeoutMethodParams = timeoutMethodInfo.getMethodParams();
        Class[] timeoutMethodParamTypes = new Class[]{};
        if (timeoutMethodParams != null) {
            timeoutMethodParamTypes = new Class[timeoutMethodParams.length];
            int i = 0;
            for (String paramClassName : timeoutMethodParams) {
                Class<?> methodParamClass = null;
                try {
                    methodParamClass = Class.forName(paramClassName, false, classLoader);
                }
                catch (ClassNotFoundException cnfe) {
                    throw EjbLogger.ROOT_LOGGER.failedToLoadTimeoutMethodParamClass(cnfe, paramClassName);
                }
                timeoutMethodParamTypes[i++] = methodParamClass;
            }
        }
        for (Class<?> klass = timeoutMethodDeclaringClass; klass != null; klass = klass.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = klass.getDeclaredMethods()) {
                Class<?>[] methodParamTypes;
                if (!method.getName().equals(timeoutMethodName) || timeoutMethodParamTypes.length != (methodParamTypes = method.getParameterTypes()).length) continue;
                boolean match = true;
                for (int i = 0; i < methodParamTypes.length; ++i) {
                    if (timeoutMethodParamTypes[i].equals(methodParamTypes[i])) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                return method;
            }
        }
        return null;
    }

    public static class Builder
    extends TimerImpl.Builder {
        private String scheduleExprSecond;
        private String scheduleExprMinute;
        private String scheduleExprHour;
        private String scheduleExprDayOfWeek;
        private String scheduleExprDayOfMonth;
        private String scheduleExprMonth;
        private String scheduleExprYear;
        private Date scheduleExprStartDate;
        private Date scheduleExprEndDate;
        private String scheduleExprTimezone;
        private boolean autoTimer;
        private Method timeoutMethod;

        public Builder setScheduleExprSecond(String scheduleExprSecond) {
            this.scheduleExprSecond = scheduleExprSecond;
            return this;
        }

        public Builder setScheduleExprMinute(String scheduleExprMinute) {
            this.scheduleExprMinute = scheduleExprMinute;
            return this;
        }

        public Builder setScheduleExprHour(String scheduleExprHour) {
            this.scheduleExprHour = scheduleExprHour;
            return this;
        }

        public Builder setScheduleExprDayOfWeek(String scheduleExprDayOfWeek) {
            this.scheduleExprDayOfWeek = scheduleExprDayOfWeek;
            return this;
        }

        public Builder setScheduleExprDayOfMonth(String scheduleExprDayOfMonth) {
            this.scheduleExprDayOfMonth = scheduleExprDayOfMonth;
            return this;
        }

        public Builder setScheduleExprMonth(String scheduleExprMonth) {
            this.scheduleExprMonth = scheduleExprMonth;
            return this;
        }

        public Builder setScheduleExprYear(String scheduleExprYear) {
            this.scheduleExprYear = scheduleExprYear;
            return this;
        }

        public Builder setScheduleExprStartDate(Date scheduleExprStartDate) {
            this.scheduleExprStartDate = scheduleExprStartDate;
            return this;
        }

        public Builder setScheduleExprEndDate(Date scheduleExprEndDate) {
            this.scheduleExprEndDate = scheduleExprEndDate;
            return this;
        }

        public Builder setScheduleExprTimezone(String scheduleExprTimezone) {
            this.scheduleExprTimezone = scheduleExprTimezone;
            return this;
        }

        public Builder setAutoTimer(boolean autoTimer) {
            this.autoTimer = autoTimer;
            return this;
        }

        public Builder setTimeoutMethod(Method timeoutMethod) {
            this.timeoutMethod = timeoutMethod;
            return this;
        }

        @Override
        public CalendarTimer build(TimerServiceImpl timerService) {
            return new CalendarTimer(this, timerService);
        }
    }
}

