/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.kerberos;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.credential.CredentialInput;
import org.keycloak.federation.kerberos.KerberosConfig;
import org.keycloak.federation.kerberos.KerberosFederationProviderFactory;
import org.keycloak.federation.kerberos.ReadOnlyKerberosUserModelDelegate;
import org.keycloak.federation.kerberos.impl.KerberosUsernamePasswordAuthenticator;
import org.keycloak.federation.kerberos.impl.SPNEGOAuthenticator;
import org.keycloak.models.CredentialValidationOutput;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelReadOnlyException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserFederationProvider;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserManager;
import org.keycloak.models.UserModel;

public class KerberosFederationProvider
implements UserFederationProvider {
    private static final Logger logger = Logger.getLogger(KerberosFederationProvider.class);
    public static final String KERBEROS_PRINCIPAL = "KERBEROS_PRINCIPAL";
    protected KeycloakSession session;
    protected UserFederationProviderModel model;
    protected KerberosConfig kerberosConfig;
    protected KerberosFederationProviderFactory factory;

    public KerberosFederationProvider(KeycloakSession session, UserFederationProviderModel model, KerberosFederationProviderFactory factory) {
        this.session = session;
        this.model = model;
        this.kerberosConfig = new KerberosConfig(model);
        this.factory = factory;
    }

    public UserModel validateAndProxy(RealmModel realm, UserModel local) {
        if (!this.isValid(realm, local)) {
            return null;
        }
        if (this.kerberosConfig.getEditMode() == UserFederationProvider.EditMode.READ_ONLY) {
            return new ReadOnlyKerberosUserModelDelegate(local, this);
        }
        return local;
    }

    public boolean synchronizeRegistrations() {
        return false;
    }

    public UserModel register(RealmModel realm, UserModel user) {
        return null;
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        return true;
    }

    public UserModel getUserByUsername(RealmModel realm, String username) {
        KerberosUsernamePasswordAuthenticator authenticator = this.factory.createKerberosUsernamePasswordAuthenticator(this.kerberosConfig);
        if (authenticator.isUserAvailable(username)) {
            if (username.contains("@")) {
                username = username.split("@")[0];
            }
            return this.findOrCreateAuthenticatedUser(realm, username);
        }
        return null;
    }

    public UserModel getUserByEmail(RealmModel realm, String email) {
        return null;
    }

    public List<UserModel> searchByAttributes(Map<String, String> attributes, RealmModel realm, int maxResults) {
        return Collections.emptyList();
    }

    public List<UserModel> getGroupMembers(RealmModel realm, GroupModel group, int firstResult, int maxResults) {
        return Collections.emptyList();
    }

    public void preRemove(RealmModel realm) {
    }

    public void preRemove(RealmModel realm, RoleModel role) {
    }

    public void preRemove(RealmModel realm, GroupModel group) {
    }

    public boolean isValid(RealmModel realm, UserModel local) {
        String kerberosPrincipal = local.getUsername() + "@" + this.kerberosConfig.getKerberosRealm();
        return kerberosPrincipal.equalsIgnoreCase(local.getFirstAttribute(KERBEROS_PRINCIPAL));
    }

    public Set<String> getSupportedCredentialTypes() {
        HashSet<String> supportedCredTypes = new HashSet<String>();
        supportedCredTypes.add("kerberos");
        return supportedCredTypes;
    }

    public boolean updateCredential(RealmModel realm, UserModel user, CredentialInput input) {
        if (!(input instanceof UserCredentialModel) || !"password".equals(input.getType())) {
            return false;
        }
        if (this.kerberosConfig.getEditMode() == UserFederationProvider.EditMode.READ_ONLY) {
            throw new ModelReadOnlyException("Can't change password in Keycloak database. Change password with your Kerberos server");
        }
        return false;
    }

    public void disableCredentialType(RealmModel realm, UserModel user, String credentialType) {
    }

    public Set<String> getDisableableCredentialTypes(RealmModel realm, UserModel user) {
        return Collections.EMPTY_SET;
    }

    public boolean supportsCredentialType(String credentialType) {
        return credentialType.equals("kerberos") || this.kerberosConfig.isAllowPasswordAuthentication() && credentialType.equals("password");
    }

    public boolean isConfiguredFor(RealmModel realm, UserModel user, String credentialType) {
        return this.supportsCredentialType(credentialType);
    }

    public boolean isValid(RealmModel realm, UserModel user, CredentialInput input) {
        if (!(input instanceof UserCredentialModel)) {
            return false;
        }
        if (input.getType().equals("password") && !this.session.userCredentialManager().isConfiguredLocally(realm, user, "password")) {
            return this.validPassword(user.getUsername(), ((UserCredentialModel)input).getValue());
        }
        return false;
    }

    protected boolean validPassword(String username, String password) {
        if (this.kerberosConfig.isAllowPasswordAuthentication()) {
            KerberosUsernamePasswordAuthenticator authenticator = this.factory.createKerberosUsernamePasswordAuthenticator(this.kerberosConfig);
            return authenticator.validUser(username, password);
        }
        return false;
    }

    public CredentialValidationOutput validCredentials(RealmModel realm, UserCredentialModel credential) {
        if (credential.getType().equals("kerberos")) {
            String spnegoToken = credential.getValue();
            SPNEGOAuthenticator spnegoAuthenticator = this.factory.createSPNEGOAuthenticator(spnegoToken, this.kerberosConfig);
            spnegoAuthenticator.authenticate();
            HashMap<String, String> state = new HashMap<String, String>();
            if (spnegoAuthenticator.isAuthenticated()) {
                String username = spnegoAuthenticator.getAuthenticatedUsername();
                UserModel user = this.findOrCreateAuthenticatedUser(realm, username);
                if (user == null) {
                    return CredentialValidationOutput.failed();
                }
                String delegationCredential = spnegoAuthenticator.getSerializedDelegationCredential();
                if (delegationCredential != null) {
                    state.put("gss_delegation_credential", delegationCredential);
                }
                return new CredentialValidationOutput(user, CredentialValidationOutput.Status.AUTHENTICATED, state);
            }
            state.put("SpnegoResponseToken", spnegoAuthenticator.getResponseToken());
            return new CredentialValidationOutput(null, CredentialValidationOutput.Status.CONTINUE, state);
        }
        return CredentialValidationOutput.failed();
    }

    public void close() {
    }

    protected UserModel findOrCreateAuthenticatedUser(RealmModel realm, String username) {
        UserModel user = this.session.userStorage().getUserByUsername(username, realm);
        if (user != null) {
            logger.debug((Object)("Kerberos authenticated user " + username + " found in Keycloak storage"));
            if (!this.model.getId().equals(user.getFederationLink())) {
                logger.warn((Object)("User with username " + username + " already exists, but is not linked to provider [" + this.model.getDisplayName() + "]"));
                return null;
            }
            UserModel proxied = this.validateAndProxy(realm, user);
            if (proxied != null) {
                return proxied;
            }
            logger.warn((Object)("User with username " + username + " already exists and is linked to provider [" + this.model.getDisplayName() + "] but kerberos principal is not correct. Kerberos principal on user is: " + user.getFirstAttribute(KERBEROS_PRINCIPAL)));
            logger.warn((Object)"Will re-create user");
            new UserManager(this.session).removeUser(realm, user, this.session.userStorage());
        }
        logger.debug((Object)("Kerberos authenticated user " + username + " not in Keycloak storage. Creating him"));
        return this.importUserToKeycloak(realm, username);
    }

    protected UserModel importUserToKeycloak(RealmModel realm, String username) {
        String email = username + "@" + this.kerberosConfig.getKerberosRealm().toLowerCase();
        logger.debugf("Creating kerberos user: %s, email: %s to local Keycloak storage", (Object)username, (Object)email);
        UserModel user = this.session.userStorage().addUser(realm, username);
        user.setEnabled(true);
        user.setEmail(email);
        user.setFederationLink(this.model.getId());
        user.setSingleAttribute(KERBEROS_PRINCIPAL, username + "@" + this.kerberosConfig.getKerberosRealm());
        if (this.kerberosConfig.isUpdateProfileFirstLogin()) {
            user.addRequiredAction(UserModel.RequiredAction.UPDATE_PROFILE);
        }
        return this.validateAndProxy(realm, user);
    }
}

